#include "fastcharbuf.h"
#include <stdlib.h>
#include <stdio.h>

fastCharBuffer::fastCharBuffer(long initialSize=10000){

  size=0;
  chunk=initialSize;
  maxSize=initialSize;
  error=0;
  skipNext=0;
  buffer=(char*) malloc(initialSize);
}

fastCharBuffer::~fastCharBuffer(){
  free(buffer);
}

char * fastCharBuffer::str(){
  return buffer;
}

long fastCharBuffer::length(){
  return size;
}

void fastCharBuffer::cat(const char * s){
  long l=strlen(s);
  if(skipNext){
    skipNext--;
    return;
  }
  while(l+size+1>maxSize){
    maxSize+=chunk;
    buffer=(char*) realloc(buffer,maxSize);
  }
  strcpy(buffer+size,s);
  size+=l;
}

fastCharBuffer& fastCharBuffer::operator<<(const String s) {
  cat(s); 
  return *this; 
}

fastCharBuffer& fastCharBuffer::operator<<(const char *s) {
  if(s!=NULL)
    cat(s); 
  else
    cat("(NULL)");
  return *this; 
}

fastCharBuffer& fastCharBuffer::operator<<(char c) {
  char s[2]={c,'\0'};
  cat(s); 
  return *this; 
}

fastCharBuffer& fastCharBuffer::operator<<(long n) {
  char s[20]; 
  sprintf(s,"%ld",n);
  cat(s); 
  return *this; 
}

fastCharBuffer& fastCharBuffer::operator<<(int n) {
  return (*this << (long)n);
}

fastCharBuffer& fastCharBuffer::operator<<(double d) {
  char s[20]; 
  sprintf(s,"%lf",d);
  cat(s); 
  return *this; 
}


