#include <stdio.h>
#include <pcap.h>
#include <net/if.h>
#include <stdlib.h>
#include <string.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include "capture.h"
#include "global.h"

char Capture::errbuf[PCAP_ERRBUF_SIZE] = {};
char Capture::filter_exp[200] = {};

pcap_t * Capture::create_pcap(const void *dev, pcap_style_t style)
{
        pcap_t *handle;                 /* Session handle */
	    struct bpf_program fp;          /* The compiled filter */
        bpf_u_int32 mask;               /* The netmask */
        bpf_u_int32 net;                /* The IP subnet*/
        //const struct pcap_pkthdr* pcap_header;   /* A pointer to pcap_pkthdr structure */
        //const u_char *pcap_packet;           /* The captured packet */

	    char *interface = (char *)dev;

#ifdef DEBUG
	    printf("in create_pcap(), interface is %s\n", interface);
#endif

	/* Find the properties for the network interface */
	if (pcap_lookupnet(interface, &net, &mask, errbuf) == -1) {
		fprintf(stderr, "Pcap counldn't get netmask for device %s: %s\n", interface, errbuf);
		net = 0;
		mask = 0;
	}

	#ifdef DEBUG
		struct in_addr tmp;
		tmp.s_addr=net;
		char IPdotdec[20];
		inet_ntop(AF_INET, (void *)&tmp, IPdotdec, 16);
		tmp.s_addr=mask;
		inet_ntop(AF_INET, (void *)&tmp, IPdotdec, 16);
		printf("net is %s\n", IPdotdec);
		printf("mask is %s\n", IPdotdec);
	#endif

        handle = pcap_open_live(interface, BUFSIZ, 0, 0, errbuf);
        if (handle == NULL) {
		fprintf(stderr, "Pcap open live capture failure: %s\n", errbuf);
                exit(1);
        }

	    //sprintf(filter_exp, "tcp[tcpflags] & (tcp-syn|tcp-ack) != 0 && (src port %d || dst port %d)", RELAY_PORT, RELAY_PORT);
	    sprintf(filter_exp, "port 8000");


        /* Compile and apply the filter */
        if (pcap_compile(handle, &fp, filter_exp, 0, mask) == -1) {
		fprintf(stderr, "Pcap parse filter failure: %s\n", pcap_geterr(handle));
        	exit(1);
	}

        if (pcap_setfilter(handle, &fp) == -1) {
		fprintf(stderr, "Pcap couldn't install filter: %s\n", pcap_geterr(handle));
        	exit(1);
	}

	if(style == NONBLOCKING){
		if(pcap_setnonblock(handle, 1, errbuf) == -1){
        		fprintf(stderr, "Pcap set non-blocking fails: %s\n", errbuf);
                	exit(1);
		}
	}

	return handle;
}
