//=============================================================================
// $Id: Audio.cpp,v 1.1.1.1 1999/11/06 11:54:00 creinig Exp $
//-----------------------------------------------------------------------------
// factory for creating ppsAudio objects
//
// $Log: Audio.cpp,v $
// Revision 1.1.1.1  1999/11/06 11:54:00  creinig
// Back in CVS at last
//
//
//=============================================================================

#include <PenguinPlay/PenguinPlay.h>

#include <PenguinPlay/Factory.h>

#include <PenguinPlay/Audio.h>

#ifdef PP_SYS_OS_WIN32
#include <PenguinPlay/DirectSound.h>
#else
#include <PenguinPlay/Sequencer.h>
#include <PenguinPlay/Dsp.h>
#include <PenguinPlay/Esd.h>
#include <PenguinPlay/DspMmapped.h>
#include <PenguinPlay/FileAudio.h>
#endif

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

//=============================================================================
/// Introduced to provide ppsAudioToFile classes with a way to set the rate
/// and  bit width and select stereo or mono output.
//=============================================================================
template <typename Product>
class AudioToFileFactory : public AbstractFactory<Audio>
{
public:
     AudioToFileFactory(int rate = 44100, int bits = 16, bool stereo = true)
          : m_rate(rate),
            m_bits(bits),
            m_stereo(stereo)
          {
          }
     /// Return a Product as a pointer to the ProductBase.
     virtual Audio* Create()
          {
               return new Product(m_rate, m_bits, m_stereo);
          }

     int  m_rate;
     int  m_bits;
     bool m_stereo;
};

//=============================================================================
///
//=============================================================================
Audio* Audio::Create(int id, int rate, int bits, bool stereo)
{
     typedef RegistryFactory<Audio> AudioFactory;

     AudioFactory* r = AudioFactory::Instance();

     if (r->empty())
          {
               // nobody has registered any factories
               // we'll add the default ones, with the default priorities
#ifdef PP_SYS_OS_WIN32
               static Factory<Audio, DirectSound> directsoundfactory;
               (*r)[r->size()] = &directsoundfactory;
#else

               static AudioToFileFactory<Dsp>
                    dspfactory(rate,bits,stereo);
               (*r)[r->size()] = &dspfactory;
               static AudioToFileFactory<Esd>
                    esdfactory(rate,bits,stereo);
               (*r)[r->size()] = &esdfactory;
               static Factory<Audio, Sequencer>
                    sequencerfactory;
               (*r)[r->size()] = &sequencerfactory;
               static AudioToFileFactory<DspMmapped>
                    dspmmappedfactory(rate, bits, stereo);
               (*r)[r->size()] = &dspmmappedfactory;

               static AudioToFileFactory<FileAudio>
                    fileaudiofactory(rate, bits, stereo);
               (*r)[r->size()] = &fileaudiofactory;

#endif /* PP_SYS_OS_WIN32 */
          }

     if (id != -1)
          {
               return r->Create(id);
          }

     Audio* audio = 0;
     AudioFactory::iterator i = r->begin();
     while (!audio && i != r->end())
          {
               try
                    {
                         audio = r->Create(i++);
                    }
               catch (...)
                    {
                    }
          }
     return audio;
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END

