//=============================================================================
// $Id: Dsp.cpp,v 1.2 1999/11/28 23:47:25 creinig Exp $
//-----------------------------------------------------------------------------
// $Log: Dsp.cpp,v $
// Revision 1.2  1999/11/28 23:47:25  creinig
// adapted sources to use ppconfig(_win32).h
//
// Revision 1.1.1.1  1999/11/06 11:54:00  creinig
// Back in CVS at last
//
//=============================================================================

#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/Dsp.h>

//#ifdef PP_DEBUG
//#include <stdio.h>
//#endif

#include <fcntl.h>

#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include <string>

#include <unistd.h> // close

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

/// Constructor.
/// \param rate   The sample rate.
/// \param bits   The bit width to use.
/// \param stereo Attempt stereo playback?
/// \param device The device to use. Defaults to "/dev/dsp".
Dsp::Dsp(int rate, int bits, bool stereo, const std::string& device)
     : m_device(device)
{
     Create(rate, bits, stereo ? 1 : 0);
}

///  destructor
Dsp::~Dsp()
{
     try
          {
               Destroy();
          }
     catch(...)
          {
          }
}

void Dsp::Create(int rate, int bits, int stereo)
{
     m_rate        = rate;
     m_bits        = bits;
     m_buffer_size = DEFAULT_BUFFER_SIZE;

     if (m_fd == -1)
          {
               // dont open device if it is already open
               if (access(m_device.c_str(), W_OK /*R_OK*/) != 0)
	            {
		         ppWarning ("%s: Can't access.", m_device.c_str ());
                         ppThrow (EHardwareUnavailable, "Can't access.");
                    }
               // we want to be able to record as well as play
               // so we want to be able to read and write
               if ((m_fd = open(m_device.c_str(), O_WRONLY, 0)) == -1)
                    {
                         ppWarning ("%s: Can't open for output.", m_device.c_str ());
                         ppThrow (EAccessFailure, "Can't open for output.");
                    }
          }

     Reset();

     // is there stereo?
     if (ioctl(m_fd, SNDCTL_DSP_STEREO, &stereo) == -1)
          {
               ppWarning ("%s: error setting stereo", m_device.c_str ());
               ppThrow (EUnavailable, "error setting stereo");
          }

     // can I set the dsp to the rate given?
     if (ioctl(m_fd, SNDCTL_DSP_SPEED, &m_rate) == -1)
          {
               ppWarning ("%s: error setting rate", m_device.c_str ());
               ppThrow (EUnavailable, "error setting rate");
          }

     // Can the device play 16bit samples?
     if (ioctl(m_fd,SNDCTL_DSP_SAMPLESIZE,&m_bits) == -1)
          {
               ppWarning ("%s: Error setting sample size", m_device.c_str ());
               ppThrow (EUnavailable, "error setting sample size");
          }

     m_stereo = (stereo != 0);


     if (m_stereo)
	  ppDebug1 ("DSP %d bit %d Hz stereo", m_bits, m_rate);
     else
          ppDebug1 ("DSP %d bit %d Hz mono", m_bits, m_rate);

     GetBlkSize();
     //      bufsize = blksize;

     m_audio_buffer = new unsigned char [m_buffer_size];
}

void Dsp::Destroy()
{
     if (m_fd != -1)
          {
               close(m_fd);
               m_fd = -1;
          }
     if (m_audio_buffer)
          {
               delete [] m_audio_buffer;
               m_audio_buffer = 0;
          }
}



void Dsp::Reset()
{
     ioctl(m_fd, SNDCTL_DSP_RESET, 0);
}

void Dsp::Sync()
{
     ioctl(m_fd, SNDCTL_DSP_SYNC, 0);
}

int Dsp::GetBlkSize()
{
     int blksize;
     ioctl(m_fd, SNDCTL_DSP_GETBLKSIZE, &blksize);
     return blksize;
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END

