#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include <string>
#include <new>

#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/SampleVoc.h>

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

//============================================================================
// constructors and destructors
//============================================================================
SampleVoc::SampleVoc()
{
}

SampleVoc::~SampleVoc()
{
}

//============================================================================
// SampleVoc::Load
//----------------------------------------------------------------------------
///
//============================================================================
bool SampleVoc::Load(const char *filename)
{
  char           magic[20];
  unsigned char  blockid;
  unsigned char  temp;
  unsigned char* tBuf;
  unsigned short firstBlock;
  unsigned short version;
  unsigned short id;
  unsigned long  blocklen = 0;

  m_length = 0;

  FILE* fp = fopen(filename, "rb");

  try
    {
      if (!fp)
        {
        ppThrow (EAccessFailure, "No Such File");
        }

      fread(magic, 1, 20, fp);
      // \x1a is the end-of-file marker in MS-DOS
      if (strncmp(magic, "Creative Voice File\x1a", 20))
        {
          ppThrow (EInvalidData, "Not a valid .VOC file!");
        }

      // read in size of header (or position of the first block)
      fread(&firstBlock, 1, 2, fp);
      fread(&version, 1, 2, fp);
      if (version > 0x010A) /* I don't have the specs for new .VOCs */
        {
          ppThrow (EUnsupported, "Unsupported .VOC file version!");
        }
      fread(&id, 1, 2, fp);
      if (id != (~version) + 0x1234)
        {
         ppThrow (EInvalidData, "Not a valid .VOC file!");
        }

      fseek(fp, firstBlock, SEEK_SET);
      do
        {
          fread(&blockid, 1, 1, fp);
          // a blockid of zero signifies the end of the voc file
          if (blockid)
            {
              // is this right ?
              fread(&blocklen, 1, 3, fp);
              switch(blockid)
                {
                case 1: // Sound Data Block
                  // some voc files have more than one sound data block
                  // so we need to keep reallocating space for the data
                  fread(&temp, 1, 1, fp);   /* Time-constant */
                  if (temp < 256)
                    m_frequency = 1000000 / (256 - temp);

                  fread(&temp, 1, 1,fp);
                  switch (temp)
                    {
                    case 0: // unsigned 8 bit PCM
                      {
                        m_length = m_length + blocklen - 2;
                        if (!m_data0)
                          m_data0 = new unsigned char [m_length];
                        else
                          {
                            // need to reallocate data
                            unsigned char* t = m_data0;
                            m_data0 = new unsigned char [m_length];
                            memcpy(m_data0, t, m_length - blocklen + 2);
                            delete [] t;
                          }

                        if (!m_data0)
                          {
                            throw std::bad_alloc ();
                          }

                        Set16Bit();
                        unsigned char *position=m_data0+m_length+2-blocklen;
                        fread(position, (blocklen - 2), 1, fp);
                        break;
                      }
                    case 1:   // compressed 4 bits per sample
                    case 2:   // compressed 2.6 bits per sample
                    case 3:   // compressed 2 bits per sample
                    default:
                      ppThrow (EUnsupported, "Unknown sample encoding");
                    }
                  break;

                case 2: // sound continuation block
                  tBuf = new unsigned char [m_length + blocklen];
                  if (!tBuf)
                    {
                      delete [] m_data0;
                      throw std::bad_alloc ();
                    }
                  memcpy(tBuf, m_data0, m_length);
                  fread(tBuf + m_length, 1, blocklen, fp);
                  m_length += blocklen;
                  delete [] m_data0;
                  m_data0 = tBuf;
                  break;

                case 3: // a block of silence
                case 4: // Marker Block
                case 5: // Text Block
                case 6: // loop start
                case 7: // loop end
                case 8: // stereo extension block
                case 9: // compression extension block
                default:
                  // fix this up !
                  // use fseek instead !
                  while (blocklen--)
                    fgetc(fp);
                  break;
                }
            }
        }
      while (blockid != 0);

      if (filename)
        {
          SetName(filename);
        }

      fclose(fp);
      return true;
    }
  catch (Exception &message)
    {
      fclose(fp);
      throw message;
    }
}

bool SampleVoc::Save(const char* filename, const Sample& sample) const
{
  return false;
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END
