#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/Thread.h>

#if defined(PP_SYS_OS_WIN32)
#include <windows.h>
#include <process.h>
#else
#include <pthread.h>
#endif // PP_SYS_OS_WIN32

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

//============================================================================
///
//============================================================================
class Thread::ThreadImpl
{
public:

     ThreadImpl(Thread* thread) : m_pThread(thread), m_handle(0) { }

     bool                       Start();
     bool                       WaitForExit();

#if defined(PP_SYS_OS_WIN32)
     typedef unsigned           callback_t;
     typedef HANDLE             thread_handle_t;
#else
     typedef void*              callback_t;
     typedef pthread_t          thread_handle_t;
     // windows _stdcall gets in the way define it if its not defined
     #define _stdcall
#endif

private:

     static callback_t _stdcall Callback(void* data);

     Thread*                    m_pThread;
     thread_handle_t            m_handle;
};

#ifdef PP_SYS_OS_WIN32
//============================================================================
///
//============================================================================
inline bool Thread::ThreadImpl::Start()
{
     if (m_handle != 0) // already started
          return false;
     unsigned int uiThreadId;
     m_handle = (thread_handle_t)_beginthreadex(NULL,
                                                0,
                                                Callback,
                                                (void*)m_pThread,
                                                0,
                                                &uiThreadId);
     return m_handle != 0;
}

#else

//============================================================================
///
//============================================================================
inline bool Thread::ThreadImpl::Start()
{
     if (m_handle != 0) // already started
          return false;
     return pthread_create(&m_handle,
                           0,
                           Callback,
                           (void*)m_pThread);
}


#endif

//============================================================================
///
//============================================================================
inline bool Thread::ThreadImpl::WaitForExit()
{
     bool ret = true;
#ifdef PP_SYS_OS_WIN32
     if (WaitForSingleObject(m_handle, INFINITE) != WAIT_OBJECT_0)
          ret = false;
     CloseHandle(m_handle);
#else
     pthread_join(m_handle, NULL);
#endif
     m_handle = 0;
     return ret;
}

//============================================================================
///
//============================================================================
Thread::ThreadImpl::callback_t
Thread::ThreadImpl::Callback(void* data)
{
     Thread* thread = (Thread*)data;
     if (thread != 0)
        {
               thread->Run();
        }
     return (callback_t)0;
}

//============================================================================
///
//============================================================================
Thread::Thread()
{
     m_pimple = new ThreadImpl(this);
}

//============================================================================
///
//============================================================================
Thread::~Thread()
{
     delete m_pimple;
}

//============================================================================
///
//============================================================================
bool Thread::Start()
{
     return m_pimple->Start();
}

//============================================================================
///
//============================================================================
bool Thread::WaitForExit()
{
     return m_pimple->WaitForExit();
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END
