/*
 * Declaration of PenguinPlay  low level event
 * interface.
 *
 * License: See the accompanying file LICENSE
 *
 * Last change by $Author: raka $
 * on             $Date: 1999/03/03 08:51:20 $
 * to             $Revision: 1.1 $
 *
 */


#ifndef _PP_EVENT_H
#define _PP_EVENT_H


#include <PenguinPlay/PenguinPlay.h>



/**********************************************************
 * General (non evtype specific).
 *********************************************************/


/**********************************************
 * Event Stuff
 */


typedef enum {
  ppeUnknwonEventType,
  ppeUserEventType,
  ppeLastEventType  /*FIX? In C++ code I have been useing xxNumVals*/
} ppeEventType ;

typedef struct  { /* ppEvent guaranteed to be 4 words long? */

  ppWord type;
  ppWord pad[3];
} ppeEvent;


/* Note, these are alloc, and free, not create and destroy. */
_PP_EXTC ppeEvent* ppeAllocEvent();
_PP_EXTC void ppeFreeEvent();


/**************************************
 * Bindings and such.
 */

#ifndef _PP_EVENT_PRIVATE_H
  /*If this is not an implmenetation file, then define this as opaque*/
  typedef void* ppeBinding;
#endif


typedef void (*ppeEventHandler)(void*, ppeEvent*);

/*return nonzero on failure*/
/*can be called more than once, maintains an openning count*/
_PP_EXTC ppBool ppeOpenBindingMap(ppeEventType type);

/*decrement the close count.  Deletes on zero*/
_PP_EXTC ppBool ppeCloseBindingMap(ppeEventType type);

/*delete a given binding from the map it belongs to*/
_PP_EXTC ppBool  ppeDeleteBinding(ppeBinding binding);


/*********************************************************
 * User events.
 ***/

typedef struct {
  ppWord _reserved_1;  /*reserve space for the type field*/
  ppWord subtype;     /*raise event fills this in*/

  ppWord Data[ sizeof(ppeEvent)/sizeof(ppWord) - 2 ];
} ppeUserEvent;

_PP_EXTC ppeBinding  ppeBindUserEvent(
		                  int subtype,
                                  void* object,
                                  ppeEventHandler handler,
				  bool defer_sighandler
                                 );

_PP_EXTC ppBool ppeRaiseEvent(int subtype, ppeUserEvent* ev);

#endif /*_PP_EVENT_H*/
