/*
 * Custom type definitions
 * #included by PenguinPlay.h - please do not include directly
 *
 * Project : PenguinPlay
 * Part    : Generic
 * Authors : Christian Reiniger <warewolf@mayn.de>
 *           Adrian Ratnapala <raka@mailhost.bit.net.au>
 * License : See the accompanying file LICENSE
 *
 * Last change by $Author$
 * on             $Date$
 * to             $Revision$
 *
 */


#ifndef _PP_TYPES_H
#define _PP_TYPES_H



/* Old favourites
 *
 * FIX: Is ppBool really needed?
 */

#ifdef PP_CPLUSPLUS
typedef          bool ppBool;
#else
typedef          int  ppBool;
#endif

typedef unsigned char ppByte;
typedef unsigned int  ppWord;



/*
 * Integers with guaranteed _minimum_ size.
 * These could be larger than you expect,
 * they are designed for speed.
 *
 * FIX: Are the unsigned ones needed? Are they useful?
 */
typedef          long int ppInt32;
typedef          long int ppInt16;
typedef          long int ppInt8;
typedef unsigned long int ppuInt32;
typedef unsigned long int ppuInt16;
typedef unsigned long int ppuInt8;


/* 64 bits ints might exist.  Preferably becuase this is a 64
 * bit architecture, but we will use the GCC long long type if we
 * have to.
 */
#ifdef PP_SYS_64BIT_INTS
# ifdef PP_SYS_64BIT_ARCH
   typedef              long   ppInt64;
   typedef  unsigned    long   ppuInt64;
# elif defined(__GNUC__)
   typedef           long long ppInt64;
   typedef  unsigned long long ppuInt64;
# elif defined (_MSC_VER)
   typedef   signed __int64    ppInt64;
   typedef unsigned __int64    ppuInt64;
# endif
#endif





/*
 * Integers with guaranteed _exact_ size.
 *
 * FIX: Are the unsigned ones needed? Are they useful?
 */
typedef          int      pp32;
typedef          short    pp16;
typedef signed   char     pp8;
typedef unsigned int      ppu32;
typedef unsigned short    ppu16;
typedef unsigned char     ppu8;

#ifdef PP_SYS_64BIT_INTS
# ifdef PP_SYS_64BIT_ARCH
   typedef              long pp64;
   typedef  unsigned    long ppu64;
# elif __GNUC__
   typedef          long long pp64;
   typedef unsigned long long ppu64;
# elif _MSC_VER
   typedef   signed __int64   pp64;
   typedef unsigned __int64   ppu64;
# endif
#endif



/*
 * Special purpose types.
 */

#ifdef _PP_64BIT_ARCH
  typedef ppu64    ppTimeT;
  typedef ppu64    ppSizeT;
  typedef pp64     ppOffsetT;
#else
  typedef ppu32    ppTimeT;
  typedef ppu32    ppSizeT;
  typedef pp32     ppOffsetT;
#endif



#endif