/* Utility functions for parts of LibPenguinPlay.
 *
 *
 * Project : PenguinPlay
 * Part    : PenguinFile
 * Authors : Adrian Ratnapala <a.ratnapala@mailbox.uq.edu.au>
 *           Christian Reiniger <warewolf@mayn.de>
 * License : See the accompanying file LICENSE
 *
 * Last change by $Author$
 * on             $Date$
 * to             $Revision$
 *
 */


#include <PenguinPlay/PenguinPlay.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>




/******************************
  Miscilaneus definitions
**/

// This becomes PP_FUNCTION_NAME, when automatic function name getting is off.
#ifndef __GNUC__
const char* _ppNoFuncNameMsg = "Unknown Function";
#endif







/***********************
  User messages.

***/


/*FIX:  we need to make this much more flexible for the user.
  At the very least allow a file other than stderr, at the
  most, allow the user to implement this function in a nice
  way.
*/
#define outfile stderr


/*
  Some places to store data.  (Thread specific when we get around
  to that.
*/

/*line no of last debug message*/
int* _pp_db_lineno_loc(void) { static int n; return &n;}
/*function of last debug message*/
const char** _pp_db_func_loc(void) { static const char* n; return &n;}
/*filename of last debug message*/
const char** _pp_db_file_loc(void) { static const char* n; return &n;}

void do_dbg_msg(const char* type,
       const char* msg,
       va_list vargs){

    fprintf(outfile, "\n%s:\t In function \"%s\" at %s: %d : ",
    type,
    *_pp_db_func_loc(),
    *_pp_db_file_loc(),
    *_pp_db_lineno_loc()
  );
  vfprintf(outfile, msg, vargs);
}


void _ppFatalError(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("ERROR", msg, vargs);
  va_end(vargs);
  abort();
  //ppShutdown();
}


void _ppInternalError(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("ERROR (I)", msg, vargs);
  va_end(vargs);
  abort();
  //ppShutdown();
}


void _ppWarning(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("WARNING", msg, vargs);
  va_end(vargs);
}


void _ppError(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("ERROR", msg, vargs);
  va_end(vargs);
  abort();
  //ppShutdown();
}


void _ppDebug(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("DEBUG", msg, vargs);
  va_end(vargs);
}


#undef outfile


