"""
== Usage: ==
	in Game.init():
		# creation different options example
		t = Text('foo')
		t.match_font('arial')
		
		# used filepath, else filename list
		t2 = Text('foo', font='ttf/freesansbold.ttf')
		t2 = Text('foo', font='comic sans')	
		t2 = Text('foo', font='arial, verdana, foobar')	
		
		# using align: [ optional offset ]
		t = Text("align=topright,offset(x,y)", size=16,color="darkred")
		t.align( "topright", self.width, self.height, (-60,80))
		
		# usage in Game()
		self.text = Text("text line")
		self.fps = FPSText()
		self.align_list = []
		# ... append to align_list
		
	in Game.draw(self):
		self.text = "Points: %s" % ( player_points ) # caches if same value
		self.text.draw()
		self.fps.draw()
		self.fps.tick()
		
		for t in self.align_list: t.draw()

== Notes ==
	-Text() is 'smart', meaning it will only render the text if needed. the 
	method .draw() will use a cached version of the render.
	
	Meaning: you can do this, and it only renders once: ( or none if it was already set to that. )
		self.text.text="mwhahahaha"
		self.text.text="mwhahahaha"
		self.text.text="mwhahahaha"
"""
import copy
import unittest
def test_init(self):
	# print "Testing: jakelib.text.Text()"		
	# print "Testing: jakelib.text.TextMultiLine()"		
	# print "Testing: jakelib.text.FPSText()"		
	# print "Testing: jakelib.text.Text.align()"
	
	self.textmulti = TextMultiLine()
	self.fps = FPSText()	
	self.text = Text("text line")	
	
	# TextGroup()
	self.textgroup = TextGroup()
	for i,c in enumerate(["red","blue","green"]):
		t = self.textgroup.add( "TextGroup() %s" % (c), size=12, color=c)
		y = i*20
		t.rect.topleft = (200,y)
		
	
	self.align_list = []
		
	
	# Text() add a bunch of Font()s to test all alignments
	for s in ('topright', 'topleft', 'bottomright', 'bottomleft', 'center',
			'middleleft', 'middleright', 'topmiddle', 'bottommiddle' ):
		f = Text("align=%s" % (s), size=16, color="blue" )
		self.align_list.append( f )
		f.align( s ) #, self.width, self.height )
	
	
def test_draw(self):
	# you can do this, and it only renders once:
		# self.text.text="mwhahahaha"
		# self.text.text="mwhahahaha"
		# self.text.text="mwhahahaha"
	
	self.text.draw()
	self.textmulti.draw()
	self.textgroup.draw()
	
	self.fps.draw()
	self.fps.tick() # should be in .update() but I dont want another func. pointer		
	
	for t in self.align_list: t.draw()


def test_event(self, event):
	if event.type == KEYDOWN:
		# scale fonts
		if event.key == K_UP:
			self.text.font_size += 2
		elif event.key == K_DOWN:
			self.text.font_size -= 2
		elif event.key == K_F1:
			self.text.match_font('arial')
		elif event.key == K_F2:
			self.text.match_font('verdana')
		elif event.key == K_F3:
			self.text.match_font('badfontname')

def test_all( game ):
	# todo: add unit tests
	
	# == unit? tests: FPSText() ==
	game.fps.rect.topleft = (15,15)
	game.fps.font_size+=20
	
	# == these are not assert, so not unit? tests: TextMultiLine() ==
	
	# == unit? tests: Text() ==
	#todo: bug: fix: game.text.font_name = "arial"
	game.text.font_size += 4
	game.text.color = "blue"
	game.text.color_bg = 128,255,128
	game.text.color = 0,0,0
	game.text.color_bg = None
	game.text.antialias = True
	# make it show up below game.fps
	game.text.rect = Rect(game.fps.rect)
	game.text.rect.y += game.fps.font.get_linesize()

def test_visual():
	game = TestGame(test_init, test_draw, test_event, "tests: jakelib.text.* v%s" % text_ver)			
	test_all( game )
	game.main_loop()
	
	# change font name after Text() creation
	t = Text('foo')
	t.match_font('arial')
	
	# change default font on creation: manual setting of pathname to font
	t2 = Text('foo', font='ttf/freesansbold.ttf')	
	t2 = Text('foo', font='comic sans')	
	t2 = Text('foo', font='arial, verdana, foobar')	
	t2 = Text('foo', font='arial, verdana, foobar', size=t2.font_size*2)	

class TextTest(unittest.TestCase):
	"""."""
	text = None
	def setUp(self):
		# create empty screen for tests
		self.width, self.height = 640,480
		self.screen = pygame.display.set_mode(( self.width, self.height ))
		pygame.display.set_caption( "unit test: jakelib.text.*" )
		self.screen.fill( (0,0,0) )
		pygame.display.flip()
		
		self.text = Text("hi")
		print "1)", self.text.rect
		self.text.draw()
		print "2)", self.text.rect
		
	def testDraw(self):
		self.text.draw()
		
	def testFontLoading(self):
		# set font after construct
		t = Text("status",color="white",size=10)
		t.match_font("arial")
		t.draw()
		
		# default font
		t = Text("status")			
		
	def testArgInt(self):
		t = Text(2, color="white", size=22)
		

if __name__ == "__main__":
	# unittests:
	test_only_quick = False # need better wya to do this. but set true if on .pyc compile. false if manual test.
	# test_only_quick = False
	
	if not test_only_quick:
		import jakelib
		from jakelib.text import * # for .ver
		from jakelib.text import Text, TextMultiLine, FPSText
		from jakelib.game import TestGame
		test_visual()
	else:
		from text import *
		from game import TestGame
		
		unittest.main()
	
	
	
	print """== Controls: ==
	
	up/down arrows:	change font size
	F1,F2,F3:	cycle through a couple of fonts.
	
	
"""
	# test()
	print "Done!"
	
	if False:
		print """
		
		
				TODO:
				
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
		check out why redtext is copied -- maybe pointer, so need to use: "copy.copy(object)" instead
				
				
		thourough unit tests"""
