from pygame import pypm
import atexit

_init = False

GRAND_PIANO = 0
CHURCH_ORGAN = 19

def initialize():
    global _init
    if not _init:
        pypm.Initialize()
        _init = True
        atexit.register(terminate)

def terminate():
    global _init
    if _init:
        pypm.Terminate()
        _init = False

class Output(pypm.Output):
    def note_on(self, note, velocity=None):
        if velocity is None:
            velocity = 0
        self.WriteShort(0x90, note, velocity)

    def note_off(self, note, velocity=None):
        if velocity is None:
            velocity = 0
        self.WriteShort(0x80, note, velocity)
        
    def set_instrument(self, id):
        if not (0 <= id <= 127):
            raise ValueError("Undefined instrument id: %d" % id)
        self.WriteShort(0xc0, id)
