"""
== Usage: ==
	in Game.init():
		# creation different options example
		t = Text('foo')
		t.match_font('arial')
		
		# used filepath, else filename list
		t2 = Text('foo', font='ttf/freesansbold.ttf')
		t2 = Text('foo', font='comic sans')	
		t2 = Text('foo', font='arial, verdana, foobar')	
		
		# using align: [ optional offset ]
		t = Text("align=topright,offset(x,y)", size=16,color="darkred")
		t.align( "topright", self.width, self.height, (-60,80))
		
		# usage in Game()
		self.text = Text("text line")
		self.fps = FPSText()
		self.align_list = []
		# ... append to align_list
		
	in Game.draw(self):
		self.text = "Points: %s" % ( player_points ) # caches if same value
		self.text.draw()
		self.fps.draw()
		self.fps.tick()
		
		for t in self.align_list: t.draw()

== Notes ==
	-Text() is 'smart', meaning it will only render the text if needed. the 
	method .draw() will use a cached version of the render.
	
	Meaning: you can do this, and it only renders once: ( or none if it was already set to that. )
		self.text.text="mwhahahaha"
		self.text.text="mwhahahaha"
		self.text.text="mwhahahaha"
"""



if True:
	import pygame
	from pygame.locals import *
	from text import Text, FPSText
	from game import TestGame
	import copy
else: # if code is in PYTHONPATH/jakelib/*
	import pygame
	from pygame.locals import *
	import jakelib
	from jakelib.text import Text, FPSText
	from jakelib.game import TestGame
	import copy

def test_init(self):
	print "Testing: jakelib.text.Text()"
	self.text = Text("text line")
	
	print "Testing: jakelib.text.FPSText()"		
	self.fps = FPSText()
	
	print "Testing: jakelib.text.Text.align()"
	self.align_list = []
	
	# add a bunch of Font()s to test all alignments
	for s in ('topright', 'topleft', 'bottomright', 'bottomleft', 'center',
			'middleleft', 'middleright', 'topmiddle', 'bottommiddle' ):
		f = Text("align=%s" % (s), size=16, color="blue")
		self.align_list.append( f )
		f.align( s, self.width, self.height )
		
	t = Text("align=topright,offset(x,y)", size=16,color="darkred")
	t.align( "topright", self.width, self.height, (-60,80))
	self.align_list.append( t )

def test_draw(self):	
	self.text.draw()
	self.fps.draw()
	self.fps.tick()
	
	for t in self.align_list: t.draw()


def test_event(self, event):
	if event.type == KEYDOWN:		
		# change text size
		if event.key == K_UP:
			self.text.font_size += 2
		elif event.key == K_DOWN:
			self.text.font_size -= 2
		elif event.key == K_F1:
			self.text.match_font('arial')
		elif event.key == K_F2:
			self.text.match_font('verdana')
		elif event.key == K_F3:
			self.text.match_font('badfontname')

def test_all( game ):	
	# some tests
	game.fps.rect = (15,15)
	game.fps.font_size+=20	
	game.text.font_size += 4
	game.text.color = "blue"
	game.text.color_bg = 128,255,128
	game.text.color = 0,0,0
	game.text.color_bg = None	
	game.text.antialias = True
	game.text.rect = (game.fps.rect[0], game.fps.rect[1] + game.fps.font.get_linesize())

def test():
	# change font name after Text() creation
	t = Text('foo')
	t.match_font('arial')
	
	# change default font on creation: manual setting of pathname to font
	t2 = Text('foo', font='ttf/freesansbold.ttf')	
	t2 = Text('foo', font='comic sans')	
	t2 = Text('foo', font='arial, verdana, foobar')	
	
	game = TestGame(test_init, test_draw, test_event, "tests: jakelib.text.*")
	test_all( game )
	game.main_loop()

if __name__ == "__main__":
	print """== Controls: ==
	
	up/down arrows:	change font size
	F1,F2,F3:	cycle through a couple of fonts.
	
	
"""
	test()
	print "Done!"
	
	