"""Senso I/O - File handling script
Copyright 2010 Julian Marchant ("onpon4")

This file is part of Senso.

Senso is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Senso is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Senso.  If not, see <http://www.gnu.org/licenses/>.

Start Date:      July 1, 2010
Completion Date: July 6, 2010
Version:         0.1.1
Language:        Python 2.6
Dependencies:    None

"""

VERSION = (0,1,1,0)

def read(fname):
    """Reads a standard Senso file and returns a dictionary containing the data.
    Returns a dictionary containing all objects listed in the Senso file in the
    following form:
        'name':[{'property1':value,'property2':value},{'property1':value}]
    The entry key is a string with the name of the object (defined in brackets).
    The entry value is a list containing all objects with that name. Each
    individual object is represented as a dictionary with properties of the
    object listed as shown.

    """

    objects = {}

    try:
        f = open(fname, 'r')
    except IOError:
        raise

    curobj = None
    props = {}

    line = f.readline()
    while line != '':
        if line != '\n':
            line = line.strip('\n') #remove the newline character
            if line[0] == '[' and line[-1] == ']':
                if line[1] == '/':
                    if curobj in objects:
                        objects[curobj].append(props)
                    else:
                        objects[curobj] = [props]
                    curobj = None
                    props = {}
                else:
                    curobj = line[1:-1]
            else:
                prop = line.split('=')
                if ',' in prop[1]:
                    prop[1] = prop[1].split(',')
                    n = 0
                    for i in prop[1]:
                        n += 1
                    for i in xrange(0,n):
                        try:
                            prop[1][i] = float(prop[1][i])
                            v = prop[1][i]/2.
                            if v == int(v):
                                prop[1][i] = int(prop[1][i])
                        except ValueError:
                            pass
                    prop[1] = tuple(prop[1])
                else:
                    try:
                        prop[1] = float(prop[1])
                        v = prop[1]/2.
                        if v == int(v):
                            prop[1] = int(prop[1])
                    except ValueError:
                        pass
                
                props[prop[0]] = prop[1]

        line = f.readline()

    f.close()
    return objects

def write(fname, objects):
    """The inverse of the read funtion. Writes to a file in the same format.
    See read function for more info.

    """
    
    try:
        f = open(fname, 'w')
    except IOError:
        raise

    for i in objects.keys():
        for obj in objects[i]:
            f.write('[{0}]\n'.format(i))
            for prop in obj.keys():
                f.write('{0}={1}\n'.format(prop,obj[prop]))
            f.write('[/{0}]\n\n'.format(i))

    f.close()

if __name__ == '__main__':
    write('c:\somefile.crap',{'dog':[{'size':5,'color':'red'},{'size':9,'color':'blue'}]})
