import pygame
import worldstuff
from worldstuff import *


tilesize = worldstuff.charsize
chardir = ['up', 'right', 'down', 'left']  #use facing = chardir.index(Dir)
class Person(pygame.sprite.Sprite):
	
	def __init__(self, charset, speed=1, height=tilesize, width=tilesize):
		pygame.sprite.Sprite.__init__(self)
		
		self.image = pygame.image.load(charset)
		self.image.set_colorkey(chartrans,pygame.RLEACCEL)
		self.rect = self.image.get_rect()
		self.rect.topleft = (0,0); self.speed = speed
		self.frame = 0 ; self.facing = 0 ;
		self.rect.h=height; self.rect.w=width;
		self.bg = pygame.Surface((self.rect.h,self.rect.w))
		self.bg.blit(screen,(0,0), self.rect)
		
	def clear(self):
		screen.blit(self.bg, self.rect.topleft)

	def update(self):
		self.bg.blit(screen,(0,0), self.rect)
		posx = self.frame*self.rect.w
		posy = self.facing*self.rect.h

		place = self.rect.topleft
		srcrect = pygame.Rect(posx,posy,self.rect.w,self.rect.h)
		screen.blit(self.image,place, srcrect)
		
	def walk_in_place(self, Dir):
		if (self.frame > 0):
			self.frame -=1
		else:
			self.frame =1
		self.facing = chardir.index(Dir)

	def push(self, Dir):
		
		self.walk_in_place(Dir)
	
		if Dir == 'up': 
			if (self.rect.top > 0):
				self.rect.top -= self.speed
		if Dir == 'right': 
			if (self.rect.right < screenx):
				self.rect.left += self.speed
		if Dir == 'down':
			if (self.rect.bottom < screeny):
				self.rect.top += self.speed
		if Dir == 'left':
			if (self.rect.left > 0):
				self.rect.left -= self.speed
		
	def get_pos(self):
		return self.rect.center
	
	def set_x(self, x):
		self.rect.centerx = x
	def set_y(self, y):
		self.rect.centery = y

		

	
		

