# jake modifications make it use PyGame ( libSDL ) instead of GLUT
	# first convert to Main() class instead of c-like functions
	
#!/usr/bin/python
# Author:
	# based off of the PyOpenGL NeHe demos
	# modified to use pygame instead of GLUT by jake bolton [created: 2007/12/15]	
		# also added showing fps()
		# and limiting by fps

# About: draws colored polygons
	# ESCAPE: to quit
	# F1: toggles framerate limit
	

__author__ = "author: Jake bolton 2nd mod to use PyGame [ modified from the PyOpenGL NeHe demos ]"

try:
	from OpenGL.GL import *
	from OpenGL.GLU import *
	import pygame
	from pygame.locals import *
	import sys
	
	from fps import FPS
except ImportError, err:
	print "Couldn't load module. %s" % (err)
	sys.exit(2)

WINDOW_TITLE = __file__ + " : " + __author__

class Game():
	"""re-write using PyGame"""
	def __init__( self, width=640, height=480 ):
		"""init opengl"""
		self.bDone = False
		
		self.fps = FPS()
		
		# init graphics
		pygame.init()
		self.width, self.height = width, height
		self.screen = pygame.display.set_mode(( self.width, self.height ),
			pygame.DOUBLEBUF | pygame.OPENGL)
		
		pygame.display.set_caption( WINDOW_TITLE )
		
		# init opengl
		glClearColor( 0.0, 0.0, 0.0, 0.0 )
		glClearDepth( 1.0 )
		glDepthFunc( GL_LESS )
		glEnable( GL_DEPTH_TEST )
		glShadeModel( GL_SMOOTH )
		
		# set which matrix stack is target of subsequent matrix operations
		glMatrixMode( GL_PROJECTION )
		glLoadIdentity()
		
		# calc aspect ratio of window
		gluPerspective(45.0, float(width) / float(height), 0.1, 100.0 )
		
		# switch matrix stack target
		glMatrixMode( GL_MODELVIEW )
		
		self.print_status()
		
	def handle_events( self ):
		"""event loop"""
		for event in pygame.event.get():			
			# == copy events to other classes here ==			
			# copy events to player
			# example: self.player.handle_event( event )
						
			if event.type == pygame.QUIT: sys.exit()
			# event: keydown
			elif event.type == KEYDOWN:
				# exit on 'escape'
				if event.key == K_ESCAPE: self.bDone = True
				# F1: toggle limit framerate
				elif event.key == K_F1:
					self.fps.bLimitFPS = not self.fps.bLimitFPS
					print "limitFPS = %s [ max=%d ]" % ( self.fps.bLimitFPS, self.fps.max_fps )
		
	def draw( self ):
		"""draw"""
		# clear screen and depth
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )
		glLoadIdentity()
		
		# move left 1.5 units, and into screen 6.0 units
		glTranslatef( -1.5, 0.0, -6.0 )
		
		# draw triangle
			# coords: top, right, left
			# colors: red, green, blue
		glBegin( GL_POLYGON )
		
		glColor3f( 1.0, 0.0, 0.0 )
		glVertex3f( 0.0, 1.0, 0.0 )
		
		glColor3f( 0.0, 1.0, 0.0 )		
		glVertex3f( 1.0,-1.0, 0.0 )
		
		glColor3f( 0.0, 0.0, 1.0 )
		glVertex3f(-1.0,-1.0, 0.0 )
		glEnd()
		
		# move right 3 units
		glTranslatef( 3.0, 0.0, 0.0 )
		
		# draw square: quadrilateral
			# coords: topleft, topright, bottomright, bottomleft
			# colors: blu-ish
		glColor3f( 0.3, 0.5, 1.0 )		
		glBegin( GL_QUADS )
		glVertex3f(-1.0, 1.0, 0.0)
		glVertex3f( 1.0, 1.0, 0.0)
		glVertex3f( 1.0,-1.0, 0.0)
		glVertex3f(-1.0,-1.0, 0.0)
		glEnd()

		pygame.display.flip()
		
		
	def update( self ):
		"""update"""
		self.fps.tick()
	
	def loop( self ):
		"""main loop"""
		while not self.bDone:
			self.update()
			self.handle_events()
			self.draw()
			
	def print_status( self ):
		"""print status"""
		print "\n== members: ==\n"
		print "limitFPS = %s [ max=%d ]" % ( self.fps.bLimitFPS, self.fps.max_fps )
		
		print "\n== pygame.display.Info() ==\n"
		print pygame.display.Info()
		print "\n== misc info ==\n"
		print "driver: ", pygame.display.get_driver()
		print "\n== OpenGL flags: ==\n"
		self.print_gl_flags()
		
	def print_gl_flags( self ):
		"""print the opengl flags status"""			
		d = { GL_ALPHA_SIZE:'GL_ALPHA_SIZE', GL_DEPTH_SIZE:'GL_DEPTH_SIZE',
			GL_STENCIL_SIZE:'GL_STENCIL_SIZE', GL_ACCUM_RED_SIZE:'GL_ACCUM_RED_SIZE',
			GL_ACCUM_GREEN_SIZE:'GL_ACCUM_GREEN_SIZE', GL_ACCUM_BLUE_SIZE:'GL_ACCUM_BLUE_SIZE',
			GL_ACCUM_ALPHA_SIZE:'GL_ACCUM_ALPHA_SIZE', GL_MULTISAMPLEBUFFERS:'GL_MULTISAMPLEBUFFERS',
			GL_MULTISAMPLESAMPLES:'GL_MULTISAMPLESAMPLES', GL_STEREO:'GL_STEREO'
		}

		# semi-'nice' output of flags
		for flag, name in d.iteritems():
			attr = pygame.display.gl_get_attribute( flag )
			print "\tflag: %s \t= %s" % ( name, attr )
	
# old: but on-resize event code
def ResizeGLScene( width, height ):
	"""old code. could be called on pygame resize window I guess but skipped for now.
	
	this is called when window is re-sized"""
	# prevent divide by zero
	if height == 0: height = 1
	
	glViewport( 0, 0, width, height )
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()
	gluPerspective( 45.0, float(width) / float(height), 0.1, 100.0)
	glMatrixMode(GL_MODELVIEW)

# == entry point ==
if __name__ == "__main__":
	print "press ESC to quit."
	g = Game()
	g.loop()
	
	print "\nDone!\n"