import pygame
import sys

def ExpandRect(rect, size):
    rect.left -= size
    rect.top -= size
    rect.width += size*2
    rect.height += size*2

def PrintCenterRight(dest, font, text, pos):    
    surface = font.render(text, False, (255,255,255))
    drawpos = (pos[0] - surface.get_width(), pos[1] - surface.get_height()/2)
    dest.blit(surface, drawpos)

def PrintCenterLeft(dest, font, text, pos):    
    surface = font.render(text, False, (255,255,255))
    drawpos = (pos[0], pos[1] - surface.get_height()/2)
    dest.blit(surface, drawpos)
    
def DrawFont(dest, text, name, height):
    annotation_font = pygame.font.Font(pygame.font.get_default_font(), 14)
    PrintCenterLeft(dest, annotation_font, "%s: %d:" % (name, height), (20,20))

    origin = (80,60)
    if (name.startswith("file:")):
        print pygame.font.Font.__doc__
        file_name = name[5:]
        print "opening through file object:", file_name
        font = pygame.font.Font(open(file_name), height)
    else:
        font = pygame.font.Font(name, height)
    surface = font.render(text, False, (255,0,0,255), (32,32,32,255))
    dest.blit(surface, origin)
    render_rect = surface.get_rect()
    render_rect.topleft = (origin[0], origin[1])
    pygame.draw.rect(dest, (255,255,255), render_rect, 1)
    size = font.size(text)
    font_box = pygame.Rect(origin, size)
    pygame.draw.rect(dest, (255,255,0), font_box, 1)

    baseline = origin[1] + surface.get_height() + font.get_descent()
    pygame.draw.line(dest, (255,255,0), (render_rect.left - 10, baseline), (render_rect.right, baseline), 1)
    PrintCenterRight(dest, annotation_font, "baseline", (render_rect.left - 10, baseline))
    
    topline_offset = surface.get_height() + font.get_descent() - font.get_ascent()
    topline = origin[1] + topline_offset
    pygame.draw.line(dest, (255,255,0), (render_rect.left - 10, topline), (render_rect.left + 10, topline), 1)
    PrintCenterRight(dest, annotation_font, "ascent", (render_rect.left - 10, topline))

    nextline = origin[1] + font.get_linesize()
    pygame.draw.line(dest, (255,255,0), (render_rect.left - 10, nextline), (render_rect.right, nextline), 1)
    PrintCenterRight(dest, annotation_font, "next line", (render_rect.left - 10, nextline))

    height_line = origin[1] + surface.get_height() - font.get_height()
    pygame.draw.line(dest, (255,255,0), (render_rect.right - 10, height_line), (render_rect.right + 10, height_line), 1)
    PrintCenterLeft(dest, annotation_font, "returned height", (render_rect.right + 10, height_line))

    fontsizeline = origin[1] + surface.get_height() - height
    pygame.draw.line(dest, (255,255,0), (render_rect.right - 10, fontsizeline), (render_rect.right + 10, fontsizeline), 1)
    PrintCenterLeft(dest, annotation_font, "passed height", (render_rect.right + 10, fontsizeline))
    
    
def main():
    pygame.init()
    
    screen = pygame.display.set_mode((800, 400))
#    font_list = pygame.font.get_fonts()
#    font_index = font_list.index("arial")
    font_list = ["verasans.ttf", "file:verasans.ttf"]
    font_index = 0
    test_text = "Test Text, gj"
    height = 64
    
    print font_list
    
    while 1:
        for event in pygame.event.get():
            if event.type == pygame.QUIT: 
        		sys.exit()
            elif event.type == pygame.KEYDOWN:
                if event.key == pygame.K_ESCAPE: 
        			sys.exit()
                elif event.key == pygame.K_UP:
                    height = height + 1
                elif event.key == pygame.K_DOWN:
                    height = max(height - 1, 0)
                elif event.key == pygame.K_LEFT:
                    font_index = max(font_index - 1, 0)
                elif event.key == pygame.K_RIGHT:
                    font_index = min(font_index + 1, len(font_list) - 1)
                elif event.key == pygame.K_DELETE:
                    test_text = test_text[1:]
                elif event.key == pygame.K_BACKSPACE:
                    test_text = test_text[:-1]
                else:
                    test_text += event.unicode
		screen.fill((0,0,0))
        DrawFont(screen, test_text, font_list[font_index], height)
        pygame.display.flip()

if __name__ == '__main__':
       main()

