/* Default unit set definitions for Crimson Fields
   Copyright (C) 2000-2004 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* default_units.c */

#include "ccompat.h"
#include "gamedefs.h"

#define TT_STD_GROUND	(TT_PLAINS|TT_FOREST|TT_ROAD|TT_RAILS|TT_ENTRANCE)
#define TT_STD_SEA	(TT_WATER|TT_WATER_SHALLOW|TT_WATER_DEEP|TT_ENTRANCE)
#define TT_STD_AIR	(TT_STD_GROUND|TT_STD_SEA|TT_MOUNTAINS|TT_SWAMP|TT_TRENCHES|TT_BARRICADES|TT_RESTRICTED)

#define IMG(x)  ((x) * 12)

const unsigned short NUM_UNIT_TYPES = 24;

const struct UnitType UModels[] = {
  { TT_STD_GROUND|TT_SWAMP|TT_MOUNTAINS|TT_BARRICADES|TT_TRENCHES|TT_RESTRICTED, IMG(1), U_GROUND|U_CONQUER, 6, 2, 10, 10, 10, 8, 1, 1, 1, 1, 1, 1, 8, 255, 255, 0, 0, 0, 0, 0 }, /* Infantry */
  { TT_STD_GROUND|TT_TRENCHES, IMG(0), U_GROUND, 8, 3, 15, 15, 15, 0, 1, 1, 1, 1, 0, 0, 20, 255, 255, 0, 0, 0, 1, -1 }, /* Medium Tanks */
  { TT_STD_GROUND|TT_TRENCHES, IMG(3), U_GROUND, 7, 4, 20, 20, 20, 10, 1, 1, 1, 1, 1, 1, 30, 255, 255, 0, 0, 0, 2, -1 }, /* Heavy Tanks */
  { TT_STD_GROUND|TT_MOUNTAINS|TT_TRENCHES|TT_BARRICADES, IMG(4), U_GROUND, 9, 3, 15, 12, 12, 25, 1, 1, 1, 1, 1, 1, 16, 255, 255, 0, 0, 0, 3, -1 }, /* Anti-Aircraft Tanks */
  { TT_ROAD|TT_PLAINS|TT_ENTRANCE, IMG(13), U_GROUND|U_SLOW, 5, 3, 7, 0, 0, 30, 0, 0, 0, 0, 2, 6, 18, 255, 255, 0, 0, 0, 4, -1 }, /* Anti-Aircraft Guns */
  { TT_ROAD|TT_PLAINS|TT_ENTRANCE, IMG(2), U_GROUND|U_SLOW, 5, 4, 7, 25, 25, 0, 2, 6, 2, 6, 0, 0, 30, 255, 255, 0, 0, 0, 5, 1 }, /* Artillery */
  { TT_STD_SEA, IMG(16), U_MINE|U_GROUND|U_SHIP, 0, 1, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 255, 255, 0, 0, 0, 6, -1}, /* Mines */
  { TT_STD_SEA, IMG(5), U_SHIP|U_TRANSPORT|U_MINESWEEPER, 8, 7, 13, 12, 12, 8, 1, 1, 1, 1, 1, 1, 18, 255, 255, 5, 1, 1, 7, -1}, /* Patrol Boats */
  { TT_STD_AIR, IMG(8), U_AIR, 8, 6, 12, 15, 15, 15, 1, 1, 1, 1, 1, 1, 27, 255, 255, 0, 0, 0, 8, 2}, /* Fighter Squadron */
  { TT_ROAD|TT_PLAINS|TT_RAILS|TT_ENTRANCE, IMG(7), U_GROUND|U_TRANSPORT, 9, 3, 12, 8, 8, 6, 1, 1, 1, 1, 1, 1, 12, 255, 255, 8, 2, 2, 9, -1}, /* Personnel Carriers */
  { TT_WATER|TT_WATER_DEEP|TT_ENTRANCE, IMG(9), U_SHIP|U_TRANSPORT, 6, 7, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 255, 255, 30, 2, 5, 10, -1}, /* Troopships */
  { TT_STD_AIR, IMG(6), U_AIR|U_TRANSPORT, 7, 6, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 255, 255, 10, 2, 3, 11, -1}, /* Transport Planes */
  { TT_ROAD|TT_RAILS|TT_PLAINS|TT_TRENCHES|TT_ENTRANCE, IMG(17), U_GROUND, 10, 3, 10, 15, 12, 0, 1, 2, 1, 2, 0, 0, 16, 255, 255, 0, 0, 0, 12, -1}, /* Scouts */
  { TT_STD_AIR, IMG(12), U_AIR, 9, 6, 12, 0, 0, 35, 0, 0, 0, 0, 1, 1, 20, 255, 255, 0, 0, 0, 13, -1}, /* Interceptors */
  { TT_STD_GROUND, IMG(14), U_GROUND, 0, 8, 22, 18, 18, 15, 1, 2, 1, 2, 1, 1, 26, 255, 255, 0, 0, 0, 14, -1}, /* Bunkers */
  { TT_STD_SEA, IMG(15), U_SHIP, 8, 7, 15, 8, 12, 0, 1, 1, 1, 2, 0, 0, 20, 255, 255, 0, 0, 0, 15, -1}, /* Torpedo Boats */
  { TT_STD_AIR, IMG(18), U_AIR, 7, 6, 12, 25, 25, 10, 1, 1, 1, 1, 1, 1, 40, 255, 255, 0, 0, 0, 16, -1}, /* Bomber Wing */
  { TT_STD_GROUND|TT_TRENCHES|TT_SWAMP|TT_WATER_SHALLOW|TT_WATER, IMG(10), U_GROUND|U_TRANSPORT, 8, 5, 12, 12, 12, 8, 1, 1, 1, 1, 1, 1, 20, 255, 255, 12, 2, 4, 17, -1}, /* Hovercraft */
  { TT_STD_AIR, IMG(11), U_AIR, 6, 6, 15, 20, 18, 12, 1, 1, 1, 1, 1, 1, 32, 255, 255, 0, 0, 0, 18, -1}, /* Gunships */
  { TT_RAILS|TT_ENTRANCE, IMG(19), U_GROUND|U_TRANSPORT, 10, 5, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 255, 255, 20, 2, 4, 19, -1}, /* Troop Train */
  { TT_RAILS|TT_ENTRANCE, IMG(20), U_GROUND|U_SLOW, 8, 5, 22, 20, 20, 0, 2, 7, 2, 7, 0, 0, 32, 255, 255, 0, 0, 0, 20, 3}, /* Rail Guns */
  { TT_RAILS|TT_ENTRANCE, IMG(21), U_GROUND, 10, 5, 22, 20, 20, 12, 1, 2, 1, 2, 1, 2, 35, 255, 255, 0, 0, 0, 21, -1}, /* Armoured Train */
  { TT_WATER_DEEP|TT_ENTRANCE, IMG(22), U_SHIP, 6, 7, 18, 5, 25, 0, 1, 1, 1, 3, 0, 0, 35, 255, 255, 0, 0, 0, 22, -1}, /* Submarines */
  { TT_WATER_DEEP|TT_ENTRANCE, IMG(23), U_SHIP|U_MEDIC|U_TRANSPORT, 8, 7, 25, 0, 0, 20, 0, 0, 0, 0, 1, 3, 40, 255, 255, 42, 6, 6, 23, -1 } /* Aircraft Carriers */
};

const char *UNames_en[] = { "Infantry", "Medium Tanks", "Heavy Tanks", "Anti-Aircraft Tanks", "Anti-Aircraft Guns",
  "Artillery", "Mines", "Patrol Boats", "Fighter Squadron", "Personnel Carriers", "Troopships", "Transport Planes", "Scouts",
  "Interceptors", "Bunkers", "Torpedo Boats", "Bomber Wing", "Hovercraft", "Gunships", "Troop Train", "Rail Guns", "Armoured Train",
  "Submarines", "Aircraft Carriers" };

const char *UNames_de[] = { "Infanterie", "Schützenpanzer", "Schwere Panzer", "Flakpanzer", "Flakgeschütze",
  "Artillerie", "Minen", "Patrouillenboote", "Jagdgeschwader", "Truppentransporter", "Transportschiffe", "Transportflieger", "Aufklärer",
  "Abfangjäger", "Bunker", "Torpedoboote", "Bomberstaffel", "Luftkissenfahrzeuge", "Kampfhubschrauber", "Truppenzug", "Schienengeschütze", "Panzerzug",
  "U-Boote", "Flugzeugträger" };

const char *UNames_pl[] = { "Piechota", "Lekkie czołgi", "Ciężkie czołgi", "Czołgi przeciwlotnicze", "Działa przeciwlotnicze",
  "Artyleria", "Miny", "Łodzie patrolowe", "Eskadra myśliwców", "Transportery opancerzone", "Łodzie transportowe", "Samoloty transportowe",
  "Zwiadowcy", "Myśliwce przechwytujące", "Bunkry", "Torpedowce", "Myśliwce wspierające", "Poduszkowce", "Śmigłowce szturmowe",
  "Pociąg transportowy", "Działa kolejowe", "Opancerzony pociąg", "Łodzie podwodne", "Lotniskowce" };

const char *UNames_fr[] = { "Infanterie", "Tank Moyen", "Tank Lourd", "Tank Anti-Arien", "Canon Anti-Arien",
  "Artillerie", "Mine", "Navire de Patrouille", "Escadron de Chasseurs", "Vhicule pour transport de Troupes", "Navire de transport", "Avion de transport", "Eclaireur",
  "Intercepteurs", "Bunker", "Torpilleur", "Dtachement de Bombardiers", "Aroglisseur", "Hlicoptre de Combat", "Train pour transport de Troupes", "Canon  Rail", "Train Blind",
  "Sous-marin", "Porte-avions" };

