// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2004 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// ai.h
///////////////////////////////////////////////////////////////

/** Ad hoc documentation:
 * In order to add an additional player AI you must implement the following interface
 * and do the following:
 * 	1) Add a AI_[NAME], in this file to the defines, and increment AI_COUNT
 * 	2) Add a message MSG_AI_[NAME]_NAME into the msgs.h header: 
 * 		Make sure that it has the #define jives with the AI_[NAME].
 * 		i.e. if {ai.h} #define AI_[NAME] AI_STOCK+1 then
 * 			#define	[Name] MSG_AI_[NAME]_NAME MSG_AI_STOCK_NAME+1 
 * 		Basically the names must be together and in the same order
 * 			in both files
 * 	3) Make sure that your getName() function returns MSG_AI_[NAME]_NAME
 * 	4) add your initialization code to AI::AIHelper(pAI_NAME]); {ai.cpp}
 */

/* define viable AIs */
#define AI_STOCK	0
#define AI_TEST		1
#define AI_COUNT	AI_TEST+1

#ifndef _INCLUDE_AI_H
#define _INCLUDE_AI_H

//stub defined to avoid circular include (player.h, mission.h, ai.h)
class Mission;

class AI {
public:
  AI( Mission &mission ) {};
  virtual void Play( void );
  virtual const char* GetName();
  virtual unsigned short GetID();
  static AI *AIHelper(unsigned short id, Mission &mission);  
};

#endif	/* _INCLUDE_AI_H */

