#include "aiselector.h"
#include "msgs.h"
#include "ai.h"

#define AI_WIDGET_P1_CYCLE	0
#define AI_WIDGET_P2_CYCLE	1
#define AI_WIDGET_CANCEL	2
#define AI_WIDGET_START		3

////////////////////////////////////////////////////////////////////////
// NAME       : AISelector::AISelector
// DESCRIPTION: Create the AI Selection dialog, so the user can select the
// 		AI that will compete
// PARAMETERS : view  - view to attach the window to
// RETURNS    : -
////////////////////////////////////////////////////////////////////////

AISelector::AISelector( View *view, unsigned short sflags ) : Window( WIN_CENTER, view ) {
  done = false;
  playerOneWidget = NULL;
  playerTwoWidget = NULL;

  view->SetFGPen( Color( 0x00d87c00 ) );
  view->SetBGPen( Color( CF_COLOR_BLACK ) );
  unsigned short buttonheight = sfont->Height() + 8;
  unsigned short buttonwidth;
  
  /* Build AI Selection Widgets */
 
  const char *ailabels[AI_COUNT+1];
  int longest = 0;
  int longestlen = 0;
  for (int I=0; I<AI_COUNT; I++) {
  	  int length =strlen(MSG(MSG_AI_STOCK_NAME+I));
	  if (longestlen<=length)
		  longest=MSG_AI_STOCK_NAME+I;
	  ailabels[I] = MSG(MSG_AI_STOCK_NAME+I);
  }
  ailabels[AI_COUNT] = 0;
  buttonwidth = sfont->TextWidth(MSG(longest))+5;

  const char* selectlbl = MSG(MSG_AI_SELECT_LABEL);
  const char* p2lbl	= MSG(MSG_AI_VS_LABEL);
  unsigned short selectwidth = sfont->TextWidth(selectlbl);
  unsigned short p2width = sfont->TextWidth(p2lbl);
  
  int offset=0;
  if (sflags & SELECT_BOTH_AI) {
    playerOneWidget = new CycleWidget( AI_WIDGET_P1_CYCLE, 5+selectwidth, 5,
                buttonwidth+30, buttonheight, WIDGET_ALIGN_LEFT,
                selectlbl, 0, ailabels, this );
    playerOneWidget->SetHook( this );
    offset = playerOneWidget->LeftEdge()+playerOneWidget->Width();
  } else if (sflags & SELECT_P2_AI) {
    p2lbl = selectlbl;
    p2width= selectwidth;
  }  
  
  playerTwoWidget = new CycleWidget( AI_WIDGET_P2_CYCLE, 
		offset+p2width+5, 5, buttonwidth+30, buttonheight, 
		WIDGET_ALIGN_LEFT, p2lbl, 0, ailabels, this );
  playerTwoWidget->SetHook( this );
  
  SetSize(playerTwoWidget->LeftEdge()+playerTwoWidget->Width()+10,
		  buttonheight*2+15);

  // create Start and exit widgets
  Widget *wd;
 
  wd = new ButtonWidget( AI_WIDGET_START, 5, this->Height()-buttonheight-5, (this->Width()-15)/2, buttonheight,
                WIDGET_DEFAULT, MSG(MSG_B_START), this );
  wd->SetHook( this );

  wd = new ButtonWidget( AI_WIDGET_CANCEL, wd->LeftEdge()+wd->Width()+5, 
		  wd->TopEdge(), (this->Width()-15)/2, buttonheight,
                  WIDGET_DEFAULT, MSG(MSG_B_EXIT), this );
  wd->SetHook( this );

  Draw();
}

////////////////////////////////////////////////////////////////////////
// NAME       : AISelector::~AISelector
// DESCRIPTION: Destroy window.
// PARAMETERS : -
// RETURNS    : -
////////////////////////////////////////////////////////////////////////

AISelector::~AISelector( void ) {
}

////////////////////////////////////////////////////////////////////////
// NAME       : AISelector::Draw
// DESCRIPTION: Draw the main window.
// PARAMETERS : -
// RETURNS    : -
////////////////////////////////////////////////////////////////////////

void AISelector::Draw( void ) {
  Window::Draw();
}

////////////////////////////////////////////////////////////////////////
// NAME       : AISelector::WidgetActivated
// DESCRIPTION: Handle activation of widgets in the window.
// PARAMETERS : button - calling widget
//              win    - pointer to active window
// RETURNS    : GUI status
////////////////////////////////////////////////////////////////////////

GUI_Status AISelector::WidgetActivated( Widget *button, Window *win ) {
  GUI_Status rc = GUI_OK;

  switch ( button->ID() ) {
	  case AI_WIDGET_CANCEL:
		  done = false;
		  return GUI_CLOSE;
		  break;
	  case AI_WIDGET_START:
		  done = true;
  		  return GUI_CLOSE;
		  break;
  }
  return rc;
}

////////////////////////////////////////////////////////////////////////
// NAME       : AISelector::GetPlayerOneAIID
// DESCRIPTION: Returns the selected AI for player one, define value from ai.h
// RETURNS    : AI selected
////////////////////////////////////////////////////////////////////////

unsigned short AISelector::GetPlayerOneAIID()
{
	if (playerOneWidget!=NULL)
		return playerOneWidget->GetValue();
	else return AI_STOCK;
}

////////////////////////////////////////////////////////////////////////
// NAME       : AISelector::GetPlayerTwoAIID
// DESCRIPTION: Returns the selected AI for player one, define value from ai.h
// RETURNS    : AI selected
////////////////////////////////////////////////////////////////////////
unsigned short AISelector::GetPlayerTwoAIID()
{
	if (playerTwoWidget!=NULL)
		return playerTwoWidget->GetValue();
	else return AI_STOCK;
}
