// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2004 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// aiselector.h
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_AISELECTOR_H
#define _INCLUDE_AISELECTOR_H

#include "window.h"
#include "textbox.h"
#include "button.h"
#include "mapwindow.h"

#define SELECT_P2_AI 	0x01
#define SELECT_BOTH_AI  0x02

class AISelector : public Window, public WidgetHook {
public:
  AISelector( View *view, unsigned short sflags );
  ~AISelector( void );

  void Draw( void );
  void Close( void ) { Window::Close(); }
  GUI_Status WidgetActivated( Widget *button, Window *win );
  unsigned short GetPlayerOneAIID();
  unsigned short GetPlayerTwoAIID();
  bool IsDone() const { return done; }

private:
  CycleWidget *playerOneWidget;
  CycleWidget *playerTwoWidget;
  bool done;
};

#endif	/* _INCLUDE_INITWINDOW_H */

