*==============================================
*PNP Trans pinout: C,B,E
*Copyright (c) 1996 MicroCode Engineering, Inc.
*All Rights Reserved
*
*See other copyright notices at end of file.
*==============================================

*PNP
*Default PNP Bipolar transistor parameters pkg:TO-92 1,2,3
.MODEL QPNP~ PNP()

*2N2905A MCE 7/5/95
*Si 600mW  60V 600mA 300MHz pkg:TO-5 3,2,1
.MODEL Q2N2905A PNP(IS=6.09E-14 BF=130 VAF=139 IKF=0.36 ISE=4.68E-11 
+ NE=2 BR=4 VAR=20 IKR=0.54 RB=0.343 RE=0.0858 RC=0.0343 CJE=2.76E-11 
+ VJE=1.1 MJE=0.5 TF=5.3E-10 CJC=1.65E-11 VJC=0.3 MJC=0.3 TR=9.35E-8 
+ XTB=1.5 )

*2N2907A
*Si  1.8W  60V 600mA 200MHz pkg:TO-18 3,2,1
.MODEL Q2N2907A PNP(IS=3.81E-13 BF=154 VAF=139 IKF=0.14 ISE=1.53E-11 
+ NE=2 BR=4 VAR=20 IKR=0.21 RB=2.21 RE=0.552 RC=0.221 CJE=1.56E-11 VJE=0.75 
+ TF=6.36E-10 CJC=2.08E-11 VJC=0.75 TR=6.37E-8 VJS=0.75 XTB=1.5 )

*2N2955 [DM addition]
*Si  115W  70V   15A  20kHz pkg:TO-3 3,2,1
.MODEL Q2N2955 PNP(IS=4.66E-12 BF=360 VAF=100 IKF=0.25 ISE=3.339E-11 
+ BR=2 ISC=5E-9 RB=3 IRB=0.001 RBM=0.4 RC=0.04 CJE=5.802E-10 VJE=1.2 
+ MJE=0.45 TF=8E-8 XTF=1 ITF=3 PTF=120 CJC=2.121E-10 MJC=0.4 TR=2.55E-6 
+ XTB=1 )

*2N3251A MCE 7/5/95
*Si 360mW  60V 200mA 340MHz pkg:TO-18 3,2,1
.MODEL Q2N3251A PNP(IS=1.07E-15 BF=260 VAF=139 IKF=0.044 ISE=1.08E-12 
+ NE=2 BR=4 VAR=20 IKR=0.066 RB=8.52 RE=2.13 RC=0.852 CJE=5.8E-12 VJE=1.1 
+ MJE=0.5 TF=4.67E-10 CJC=9.94E-12 VJC=0.3 MJC=0.3 TR=2.04E-7 XTB=1.5 )

*2N3467 MCE 7/5/95
*Si    1W  40V    1A 200MHz pkg:TO-5 3,2,1
.MODEL Q2N3467 PNP(IS=1.01E-13 BF=54.6 VAF=113 IKF=0.8 ISE=2.14E-10 
+ NE=2 BR=4 VAR=20 IKR=1.2 RB=1.92 RE=0.481 RC=0.192 CJE=2.42E-10 VJE=1.1 
+ MJE=0.5 TF=7.95E-10 CJC=7.81E-11 VJC=0.3 MJC=0.3 TR=5.52E-7 XTB=1.5 )

*2N3468 MCE 7/5/95
*Si    1W  50V    1A 180MHz pkg:TO-5 3,2,1
.MODEL Q2N3468 PNP(IS=1.01E-13 BF=33.8 VAF=127 IKF=0.8 ISE=3.46E-10 
+ NE=2 BR=4 VAR=20 IKR=1.2 RB=2.32 RE=0.581 RC=0.232 CJE=2.42E-10 VJE=1.1 
+ MJE=0.5 TF=8.83E-10 CJC=7.81E-11 VJC=0.3 MJC=0.3 TR=6.14E-7 XTB=1.5 )

*2N3799 MCE 7/5/95
*Si 360mW  60V  50mA 300MHz pkg:TO-18 3,2,1
.MODEL Q2N3799 PNP(IS=5.07E-15 BF=598 VAF=139 IKF=0.03 ISE=8.48E-13 
+ NE=2 BR=4 VAR=20 IKR=0.045 RB=4.12 RE=1.03 RC=0.412 CJE=1.9E-11 VJE=1.1 
+ MJE=0.5 TF=5.3E-10 CJC=6.15E-12 VJC=0.3 MJC=0.3 TR=3.68E-7 XTB=1.5 )

*2N3905
*Si 310mW  40V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL Q2N3905 PNP(IS=1.05E-15 BF=220 VAF=240 IKF=0.1 ISE=1.003E-9 
+ NE=4 ISC=1.003E-9 NC=4 RB=3 RE=0.5 RC=0.2 CJE=5.7E-12 VJE=0.75 TF=3.35E-10 
+ CJC=4.32E-12 VJC=0.75 TR=1.7E-7 VJS=0.75 KF=4E-15 )

*2N3906
*Si 310mW  40V 200mA 250MHz pkg:TO-92 1,2,3
.MODEL Q2N3906 PNP(IS=4E-14 BF=400 VAF=50 IKF=0.02 ISE=7E-15 NE=1.16 
+ BR=7.5 RC=2.4 CJE=6.3E-12 VJE=0.75 TF=5E-10 CJC=5.8E-12 VJC=0.75 TR=2.3E-8 
+ VJS=0.75 XTB=1.5 KF=6E-16 )

*2N3964 MCE 7/5/95
*Si 360mW  45V 200mA 300MHz pkg:TO-18 3,2,1
.MODEL Q2N3964 PNP(IS=2.03E-14 BF=598 VAF=120 IKF=0.12 ISE=3.39E-12 
+ NE=2 BR=4 VAR=24 IKR=0.18 RB=1.03 RE=0.257 RC=0.103 CJE=5.43E-11 VJE=1.1 
+ MJE=0.5 TF=5.3E-10 CJC=1.75E-11 VJC=0.3 MJC=0.3 TR=3.68E-7 XTB=1.5 )

*2N4402
*Si 310mW  40V 600mA 150MHz pkg:TO-92 1,2,3
.MODEL Q2N4402 PNP(IS=1.59E-14 BF=150 VAF=114 IKF=250 ISE=8.41E-12 
+ NE=2 BR=4 VAR=20 RB=2.9 RE=0.71 RC=0.29 CJE=3E-11 VJE=0.379 MJE=0.259 
+ TF=7.9E-10 CJC=2E-11 VJC=0.3 MJC=0.301 TR=7.7E-8 VJS=0.75 XTB=1.5 )

*2N4403 MCE 7/5/95
*Si 625mW  40V 600mA 250MHz pkg:TO-92 1,2,3
.MODEL Q2N4403 PNP(IS=2.76E-15 BF=339 VAF=113 IKF=0.36 ISE=3.82E-12 
+ NE=2 BR=4 VAR=20 IKR=0.54 RB=1.17 RE=0.293 RC=0.117 CJE=2.48E-11 VJE=1.1 
+ MJE=0.5 TF=6.36E-10 CJC=1.58E-11 VJC=0.3 MJC=0.3 TR=2.55E-7 XTB=1.5 )

*2N5087 MCE 7/3/95
*Si 625mW  50V  50mA 400MHz pkg:TO-92 1,2,3
.MODEL Q2N5087 PNP(IS=5.07E-15 BF=715 VAF=127 IKF=0.08 ISE=1.15E-12 
+ NE=2 BR=4 VAR=12 IKR=0.12 RB=4.12 RE=1.03 RC=0.412 CJE=9.67E-12 VJE=1.1 
+ MJE=0.5 TF=3.97E-10 CJC=5.68E-12 VJC=0.3 MJC=0.3 TR=5.1E-7 XTB=1.5 )

*2N5401 MCE 7/3/95
*Si 625mW 150V 600mA 300MHz pkg:TO-92 1,2,3
.MODEL Q2N5401 PNP(IS=4.61E-13 BF=93 VAF=220 IKF=0.91 ISE=7.54E-11 
+ NE=2 BR=4 VAR=20 IKR=1.36 RB=3.86 RE=0.965 RC=0.386 CJE=5.66E-11 VJE=1.1 
+ MJE=0.5 TF=5.3E-10 CJC=2.36E-11 VJC=0.3 MJC=0.3 TR=3.68E-7 XTB=1.5 )

*2N6433 MCE 7/3/95
*Si 500mW 300V 500mA 300MHz pkg:TO-18 3,2,1
.MODEL Q2N6433 PNP(IS=5.07E-14 BF=130 VAF=311 IKF=0.3 ISE=3.9E-11 
+ NE=2 BR=4 VAR=2 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=1.24E-10 
+ VJE=1.1 MJE=0.5 TF=5.3E-10 CJC=4.02E-11 VJC=0.3 MJC=0.3 TR=3.68E-7 
+ XTB=1.5 )

*2N6520 MCE 7/3/95
*Si 625mW 350V 500mA  84MHz pkg:TO-92 1,2,3
.MODEL Q2N6520 PNP(IS=1.98E-14 BF=104 VAF=336 IKF=0.09 ISE=1.66E-11 
+ NE=2 BR=4 VAR=20 IKR=0.135 RB=3.66 RE=0.915 RC=0.366 CJE=9.81E-11 
+ VJE=1.1 MJE=0.5 TF=1.89E-9 CJC=3.07E-11 VJC=0.3 MJC=0.3 TR=1.31E-6 
+ XTB=1.5 )

*2N6727 ZETEX Spice model   Last revision  23/1/91   Medium Power
*ZTX Si    1W  40V    1A  50MHz pkg:TO-92 1,2,3
.MODEL Q2N6727 PNP(IS=2.72E-13 BF=170 NF=1.004 VAF=70 IKF=2.75 ISE=1E-13 
+ NE=1.535 BR=23 NR=1.005 VAR=40 IKR=0.55 ISC=5.15E-14 NC=1.13 RB=0.07 
+ RE=0.065 RC=0.085 CJE=3.6E-10 TF=9.4E-10 CJC=9E-11 VJC=0.705 MJC=0.46 
+ TR=6E-8 )

*2SA1213 ZETEX Spice model       Last revision  17/7/90   Medium Power
*ZTX Si    1W  50V    2A 120MHz pkg:SOT-89 2,1,3
.MODEL 2SA1213 PNP IS =2.6E-13 BF =210 VAF=27 IKF=7 ISE=1.2E-13 NE =1.43 BR =70
+VAR=14 IKR=.6 ISC=12.04E-13 NC =1.4474 NF =.999 NR =.982 RB =.3 RE =.065
+RC =.04 CJE=410E-12 TF =.65E-9 CJC=140E-12 TR =12E-9 MJC=.35 VJC=.305

*BC177AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX 300mW  45V 200mA 130MHz pkg:TO-18 3,2,1
.MODEL QBC177AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC178AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX 300mW  25V 200mA 130MHz pkg:TO-18 3,2,1
.MODEL QBC178AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC212AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 300mW  50V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QBC212AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC213AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 300mW  30V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QBC213AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC307AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX 300mW  45V 200mA 130MHz pkg:TO-92 1,2,3
.MODEL QBC307AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC308AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 300mW  25V 200mA 130MHz pkg:TO-92 1,2,3
.MODEL QBC308AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC415AP ZETEX Spice model    Last revision  4/90   Low Noise
*ZTX Si   2dB  30V 100mA 200MHz pkg:TO-92 1,2,3
.MODEL QBC415AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC416AP ZETEX Spice model    Last revision  4/90   Low Noise
*ZTX Si   2dB  45V 100mA 200MHz pkg:TO-92 1,2,3
.MODEL QBC416AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC556AP ZETEX  Spice model    Last revision  4/90   General Purpose
*ZTX Si 500mW  65V 200mA 150MHz pkg:TO-92 1,2,3
.MODEL QBC556AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC557AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 500mW  45V 200mA 150MHz pkg:TO-92 1,2,3
.MODEL QBC557AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC558AP ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si    5W  30V 200mA 150MHz pkg:TO-92 1,2,3
.MODEL QBC558AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC559AP ZETEX Spice model    Last revision  4/90   Low Noise
*ZTX Si   4dB  30V 200mA 300MHz pkg:TO-92 1,2,3
.MODEL QBC559AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC560AP ZETEX Spice model    Last revision  4/90   Low Noise
*ZTX Si   2dB  45V 200mA 300MHz pkg:TO-92 1,2,3
.MODEL QBC560AP PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC856A ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  65V 100mA 150MHz pkg:SOT-23 1,3,2
.MODEL QBC856A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC857A ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  45V 100mA 150MHz pkg:SOT-23 1,3,2
.MODEL QBC857A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC858A ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  30V 100mA 150MHz pkg:SOT-23 1,3,2
.MODEL QBC858A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BC859A ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  30V 100mA 300MHz pkg:SOT-23 1,3,2
.MODEL BC859A PNP IS =1.149E-14 ISE=5E-14 NF =.9872 NE =1.4 BF =330 BR =13
+IKF=.1 IKR=.012 ISC=1.43E-14 NC =1.1 NR =.996 RB =.2 RE =.4 RC =.95 VAR=8.15
+VAF=84.56 CJE=16E-12 TF =.493E-9 CJC=10.5E-12 TR =73.55E-9 MJC=.415 VJC=.565

*BC860A ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  45V 100mA 300MHz pkg:SOT-23 1,3,2
.MODEL QBC860A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BCW29 ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  20V 100mA 150MHz pkg:SOT-23 1,3,2
.MODEL QBCW29 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BCW61A ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  32V 200mA 180MHz pkg:SOT-23 1,3,2
.MODEL QBCW61A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BCW67A ZETEX Spice model    Last revision  10/1/90   Medium Power
*ZTX Si 425mW  30V 800mA 100MHz pkg:SOT-23 1,3,2
.MODEL QBCW67A PNP(IS=3.2E-14 BF=170 NF=0.977 VAF=45 IKF=1.25 ISE=7E-15 
+ NE=1.35 BR=50 NR=0.986 VAR=50 IKR=0.15 ISC=9E-15 NC=1.08 RB=0.16 RE=0.195 
+ RC=0.185 CJE=1.04E-10 TF=7E-10 CJC=30.5 VJC=0.395 MJC=0.415 TR=3E-9 )

*BCW68F ZETEX Spice model    Last revision  10/1/90   Medium Power
*ZTX Si 425mW  45V 800mA 100MHz pkg:SOT-23 1,3,2
.MODEL QBCW68F PNP(IS=3.2E-14 BF=170 NF=0.977 VAF=45 IKF=1.25 ISE=7E-15 
+ NE=1.35 BR=50 NR=0.986 VAR=50 IKR=0.15 ISC=9E-15 NC=1.08 RB=0.16 RE=0.195 
+ RC=0.185 CJE=1.04E-10 TF=7E-10 CJC=30.5 VJC=0.395 MJC=0.415 TR=3E-9 )

*BCW69 ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  45V 100mA 150MHz pkg:SOT-23 1,3,2
.MODEL QBCW69 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BCW89 ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  60V 100mA 150MHz pkg:SOT-23 1,3,2
.MODEL QBCW89 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BCX71G ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 350mW  45V 200mA 180MHz pkg:SOT-23 1,3,2
.MODEL QBCX71G PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*BF721 MCE 7/5/95
*Si  1.5W 300V 100mA 363MHz pkg:SOT-223 2,1,3
.MODEL QBF721 PNP(IS=1.01E-14 BF=314 VAF=311 IKF=0.06 ISE=3.22E-12 
+ NE=2 BR=4 VAR=20 IKR=0.09 RB=2.06 RE=0.515 RC=0.206 CJE=3.08E-11 VJE=1.1 
+ MJE=0.5 TF=4.37E-10 CJC=9.94E-12 VJC=0.3 MJC=0.3 TR=3.04E-7 XTB=1.5 )

*BSP16 MCE 7/5/95
*Si  1.5W 300V    1A  30MHz pkg:SOT-223 2,1,3
.MODEL QBSP16 PNP(IS=1.01E-13 BF=130 VAF=311 IKF=0.6 ISE=7.8E-11 
+ NE=2 BR=4 VAR=24 IKR=0.9 RB=3.92 RE=0.981 RC=0.392 CJE=1.34E-10 VJE=1.1 
+ MJE=0.5 TF=5.3E-9 CJC=4.33E-11 VJC=0.3 MJC=0.3 TR=3.68E-6 XTB=1.5 )

*EGC38 MCE 4/2/96
*Si 35W 350V 2A HV AF PwrAmp HiSpeedSw pkg:TO-66 3,1,2
.SUBCKT XECG38    1 2 3
Q1 1 2 3  QPWR .67
Q2 1 4 3  QPWR .33
RBS  2 4  5.64
.MODEL QPWR PNP (IS=147F NF=1 BF=65 VAF=336 IKF=.667 ISE=198P NE=2
+ BR=4 NR=1 VAR=24 IKR=1 RE=.165 RB=.663 RC=66.3M XTB=1.5
+ CJE=148P VJE=.6 MJE=.3 CJC=96.1P VJC=.22 MJC=.2 TF=7.95N TR=306N)
.ENDS XECG38

*EGC68 MCE 4/2/96
*Si 250W 250V 16A GenPurp HiPwrAmp pkg:TO-3 3,1,2
.SUBCKT XEGC68    1 2 3
Q1 1 2 3  QPWR .67
Q2 1 4 3  QPWR .33
RBS  2 4  7.7
.MODEL QPWR PNP (IS=1.17P NF=1 BF=39 VAF=284 IKF=5.33 ISE=2.64N NE=2
+ BR=4 NR=1 VAR=20 IKR=8 RE=20.7M RB=82.9M RC=8.29M XTB=1.5
+ CJE=1.16N VJE=.6 MJE=.3 CJC=755P VJC=.22 MJC=.2 TF=31.8N TR=1.22U)
.ENDS XEGC68

*EGC88 MCE 4/2/96
*Si 200W 250V 10A HiPwr LinearAmp pkg:TO-3 3,1,2
.SUBCKT XEGC88    1 2 3
Q1 1 2 3  QPWR .67
Q2 1 4 3  QPWR .33
RBS  2 4  7.7
.MODEL QPWR PNP (IS=737F NF=1 BF=39 VAF=284 IKF=3.33 ISE=1.65N NE=2
+ BR=4 NR=1 VAR=20 IKR=5 RE=33.1M RB=.132 RC=13.2M XTB=1.5
+ CJE=728P VJE=.6 MJE=.3 CJC=473P VJC=.22 MJC=.2 TF=53N TR=2.04U)
.ENDS XEGC88

*EGC189 MCE 4/2/96
*Si 10W 80V 2A AF Driver PwrAmp pkg:TO-202
.SUBCKT XEGC189   1 2 3
*    TERMINALS:  C B E
*  80 Volt  2 Amp  SiPNP  Power Transistor  04-02-1996
Q1 1 2 3  QPWR .67
Q2 1 4 3  QPWR .33
RBS  2 4  23
.MODEL QPWR PNP (IS=147F NF=1 BF=104 VAF=161 IKF=.667 ISE=123P NE=2
+ BR=4 NR=1 VAR=16 IKR=1 RE=.165 RB=.663 RC=66.3M XTB=1.5
+ CJE=148P VJE=.6 MJE=.3 CJC=96.1P VJC=.22 MJC=.2 TF=3.18N TR=122N)
.ENDS XEGC189

*EGC240 MCE 4/2/96
*Si 1W 300V 500mA HV AF Amp VideoOut pkg:TO-202
.SUBCKT XEGC240   1 2 3
Q1 1 2 3  QPWR .67
Q2 1 4 3  QPWR .33
RBS  2 4  6.5
.MODEL QPWR PNP (IS=36.8F NF=1 BF=52 VAF=311 IKF=.166 ISE=61.9P NE=2
+ BR=4 NR=1 VAR=20 IKR=.25 RE=.663 RB=2.65 RC=.265 XTB=1.5
+ CJE=39.1P VJE=.6 MJE=.3 CJC=25.4P VJC=.22 MJC=.2 TF=2.44N TR=94.2N)
.ENDS XEGC240

*EGC398 MCE 4/2/96
*Si 25W 150V 2A VertDefl AudioAmp pkg:TO-220 2,1,3
.SUBCKT XEGC398   1 2 3
Q1 1 2 3  QPWR .67
Q2 1 4 3  QPWR .33
RBS  2 4  12.5
.MODEL QPWR PNP (IS=147F NF=1 BF=130 VAF=220 IKF=.667 ISE=99.1P NE=2
+ BR=4 NR=1 VAR=20 IKR=1 RE=.165 RB=.663 RC=66.3M XTB=1.5
+ CJE=148P VJE=.6 MJE=.3 CJC=96.1P VJC=.22 MJC=.2 TF=31.8N TR=1.22U)
.ENDS XEGC398

*FCX558 ZETEX Spice model   Last revision 20/3/92   High Voltage
*ZTX Si    1W 400V 200mA 50MHz pkg:SOT-89 2,1,3
.MODEL QFCX558 PNP(IS=7.84E-14 BF=200 NF=0.9977 VAF=349 IKF=0.096 
+ ISE=3.35E-14 NE=1.689 BR=3.4 NR=0.9978 VAR=82 IKR=0.15 ISC=9.42E-12 
+ NC=1.05 RB=0.133 RE=0.5725 RC=0.748 CJE=1.1E-10 TF=1.13E-9 CJC=1.76E-11 
+ VJC=0.9135 MJC=0.5932 TR=7.5E-5 )

*FCX749 ZETEX Spice model       Last revision  17/7/90   Medium Power
*ZTX Si  1.5W  25V    2A 100MHz pkg:SOT-89 2,1,3
.MODEL QFCX749 PNP(IS=2.6E-13 BF=210 NF=0.999 VAF=27 IKF=7 ISE=1.2E-13 
+ NE=1.43 BR=70 NR=0.982 VAR=14 IKR=0.6 ISC=1.204E-12 NC=1.447 RB=0.3 
+ RE=0.065 RC=0.04 CJE=4.1E-10 TF=6.5E-10 CJC=1.4E-10 VJC=0.305 MJC=0.35 
+ TR=1.2E-8 )

*FMMT597 ZETEX Linear Operation Spice Model   Last revision 4/7/91   High Voltage
*ZTX Si 500mW 300V 500mA 75MHz pkg:SOT-23 1,3,2
.MODEL QFMMT597 PNP(IS=8.79E-14 BF=190 NF=1.003 VAF=647 IKF=0.145 
+ ISE=2.77E-14 NE=1.525 BR=2.6 NR=1.03 VAR=80 IKR=0.25 ISC=5E-13 NC=1.3 
+ RB=0.2 RE=0.5 RC=1 CJE=1.06E-10 TF=1.64E-9 CJC=2.08E-11 VJC=0.8 MJC=0.505 
+ TR=1.1E-6 )

*FMMTA70 ZETEX Spice model    Last revision  4/90   Small Signal
*ZTX Si 330mW  40V 100mA 125MHz pkg:SOT-23 1,3,2
.MODEL QFMMTA70 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*FZT749 ZETEX Spice model       Last revision  17/7/90   Medium Power
*ZTX Si    2W  25V    3A 100MHz pkg:SOT-223 2,1,3
.MODEL QFZT749 PNP(IS=2.6E-13 BF=210 NF=0.999 VAF=27 IKF=7 ISE=1.2E-13 
+ NE=1.43 BR=70 NR=0.982 VAR=14 IKR=0.6 ISC=1.204E-12 NC=1.447 RB=0.3 
+ RE=0.065 RC=0.04 CJE=4.1E-10 TF=6.5E-10 CJC=1.4E-10 VJC=0.305 MJC=0.35 
+ TR=1.2E-8 )

*FZT751 ZETEX Spice model   Last revision  23/1/91   Medium Power
*ZTX Si    2W  60V    3A 100MHz pkg:SOT-223 2,1,3
.MODEL QFZT751 PNP(IS=2.72E-13 BF=170 NF=1.004 VAF=70 IKF=2.75 ISE=1E-13 
+ NE=1.535 BR=23 NR=1.005 VAR=40 IKR=0.55 ISC=5.15E-14 NC=1.13 RB=0.07 
+ RE=0.065 RC=0.085 CJE=3.6E-10 TF=9.4E-10 CJC=9E-11 VJC=0.705 MJC=0.46 
+ TR=6E-8 )

*FZT757 ZETEX Spice model   Last revision  30/11/90   High Voltage
*ZTX Si    2W 300V 500mA  30MHz pkg:SOT-223 2,1,3
.MODEL QFZT757 PNP(IS=1.31E-13 BF=97 VAF=1060 IKF=0.25 ISE=7.5E-14 
+ BR=3.2 VAR=50 IKR=0.5 ISC=2E-13 NC=1.8 RB=0.1 RE=0.19 RC=0.2 CJE=4.45E-10 
+ TF=3.03E-9 CJC=4.8E-11 VJC=0.775 MJC=0.56 TR=1.5E-6 )

*FZT758 ZETEX Spice model   Last revision 15/4/92   High Voltage
*ZTX Si    2W 400V 500mA  50MHz pkg:SOT-223 2,1,3
.MODEL QFZT758 PNP(IS=2.72E-13 BF=175 NF=1.003 VAF=450 IKF=0.205 
+ ISE=8.24E-14 NE=1.48 BR=5.5 NR=1.004 VAR=78 IKR=0.6 ISC=1E-14 NC=1.03 
+ RB=0.1 RE=0.278 RC=0.333 CJE=3.65E-10 TF=1.3E-9 CJC=4E-11 VJC=0.715 
+ MJC=0.545 TR=3.09E-7 )

*FZT788A ZETEX Spice model   Last revision 3/6/92
*ZTX Si pkg:SOT-223 2,1,3
.MODEL QFZT788A PNP(IS=1.202E-12 BF=490 NF=1.019 VAF=10.8 IKF=3.8 
+ ISE=2.2E-13 NE=1.57 BR=190 NR=1.011 VAR=13.6 IKR=0.35 ISC=2.38E-12 
+ NC=1.693 RB=0.05 RE=0.028 RC=0.042 CJE=3.35E-10 TF=7.8E-10 CJC=1.56E-10 
+ VJC=0.9718 MJC=0.4266 TR=4.6E-9 )

*FZT788B ZETEX Spice model   Last revision 2/1/92   High Gain
*ZTX Si    2W  15V    3A 100MHz pkg:SOT-223 2,1,3
.MODEL QFZT788B PNP(IS=1.252E-12 BF=770 NF=1.012 VAF=11 IKF=2.6 ISE=1.32E-13 
+ NE=1.483 BR=350 NR=1.005 VAR=10.5 IKR=0.32 ISC=5.26E-14 NC=1.186 RB=0.053 
+ RE=0.031 RC=0.044 CJE=2.8E-10 TF=7.5E-10 CJC=1.37E-10 VJC=0.275 MJC=0.34 
+ TR=2.3E-9 )

*FZT789A ZETEX Spice model   Last revision 3/1/92   Medium Power
*ZTX Si    2W  25V    3A 100MHz pkg:SOT-223 2,1,3
.MODEL QFZT789A PNP(IS=8.51E-13 BF=540 NF=1.007 VAF=15.5 IKF=3.4 
+ ISE=1.61E-13 NE=1.506 BR=180 NR=1.003 VAR=9 IKR=0.3 ISC=7.38E-14 NC=1.227 
+ RB=0.05 RE=0.32 RC=0.052 CJE=3E-10 TF=7.3E-10 CJC=1.4E-10 VJC=0.26 
+ MJC=0.335 TR=4.2E-9 )

*FZT790A ZETEX Spice model   Last revision 3/1/92   High Gain
*Note, The model may be inaccurate for collector currents above 1.5A.
*ZTX Si    2W  40V    2A 100MHz pkg:SOT-223 2,1,3
.MODEL QFZT790A PNP(IS=1.097E-12 BF=650 NF=1.01 VAF=23.5 IKF=1.7 
+ ISE=9.89E-14 NE=1.473 BR=270 NR=1.004 VAR=30 IKR=0.2 ISC=5.49E-14 
+ NC=1.074 RB=0.055 RE=0.049 RC=0.078 CJE=2.75E-10 TF=7.5E-10 CJC=9.6E-11 
+ VJC=0.67 MJC=0.495 TR=1.08E-8 )

*FZT792A ZETEX Spice model   Last revision 7/1/92   High Gain/Medium Power
*Note, The model may be inaccurate for collector currents above 1.2A.
*ZTX Si    2W  70V    3A 100MHz pkg:SOT-223 2,1,3
.MODEL QFZT792A PNP(IS=5.98E-13 BF=525 NF=1.002 VAF=30 IKF=1.25 ISE=1.45E-13 
+ NE=1.54 BR=75 NR=0.995 VAR=34 IKR=0.4 ISC=1.59E-13 NC=1.039 RB=0.06 
+ RE=0.059 RC=0.08 CJE=2.86E-10 TF=7.5E-10 CJC=9E-11 VJC=0.71 MJC=0.5 
+ TR=9.375E-8 )

*MMBT404A MCE 7/5/95
*Si 225mW  35V 150mA 300MHz pkg:SOT-23 1,3,2
.MODEL QMMBT404A PNP(IS=1.52E-14 BF=325 VAF=106 IKF=0.09 ISE=4.68E-12 
+ NE=2 BR=4 VAR=100 IKR=0.135 RB=1.37 RE=0.343 RC=0.137 CJE=4.25E-11 
+ VJE=1.1 MJE=0.5 TF=5.35E-10 CJC=1.37E-11 VJC=0.3 MJC=0.3 TR=3.72E-7 
+ XTB=1.5 )

*MMBT2907A MCE 7/5/95
*Si 300mW  60V 600mA 300MHz pkg:SOT-23 1,3,2
.MODEL QMBT2907A PNP(IS=6.09E-14 BF=296 VAF=139 IKF=0.36 ISE=2.05E-11 
+ NE=2 BR=4 VAR=20 IKR=0.54 RB=0.343 RE=0.0858 RC=0.0343 CJE=5.03E-11 
+ VJE=1.1 MJE=0.5 TF=5.3E-10 CJC=2.31E-11 VJC=0.3 MJC=0.3 TR=3.68E-7 
+ XTB=1.5 )

*MMBT3640 MCE 7/5/95
*Si 300mW  12V  80mA 600MHz pkg:SOT-23 1,3,2
.MODEL QMMBT3640 PNP(IS=8.12E-15 BF=130 VAF=62.3 IKF=0.048 ISE=6.24E-12 
+ NE=2 BR=4 VAR=16 IKR=0.072 RB=2.57 RE=0.644 RC=0.257 CJE=8.24E-12 
+ VJE=1.1 MJE=0.5 TF=2.65E-10 CJC=8.42E-12 VJC=0.3 MJC=0.3 TR=1.84E-7 
+ XTB=1.5 )

*MMBT3906 MCE 7/5/95
*Si 300mW  40V 200mA 300MHz pkg:SOT-23 1,3,2
.MODEL QMMBT3906 PNP(IS=2.03E-14 BF=260 VAF=113 IKF=0.12 ISE=7.8E-12 
+ NE=2 BR=4 VAR=20 IKR=0.18 RB=1.03 RE=0.257 RC=0.103 CJE=2.35E-11 VJE=1.1 
+ MJE=0.5 TF=5.3E-10 CJC=1.06E-11 VJC=0.3 MJC=0.3 TR=3.68E-7 XTB=1.5 )

*MMBT4403 MCE 7/5/95
*Si 300mW  40V 600mA 250MHz pkg:SOT-23 1,3,2
.MODEL QMMBT4403 PNP(IS=2.76E-15 BF=339 VAF=113 IKF=0.36 ISE=3.82E-12 
+ NE=2 BR=4 VAR=20 IKR=0.54 RB=1.17 RE=0.293 RC=0.117 CJE=2.48E-11 VJE=1.1 
+ MJE=0.5 TF=6.36E-10 CJC=1.58E-11 VJC=0.3 MJC=0.3 TR=4.42E-7 XTB=1.5 )

*MMBT5087 MCE 7/5/95
*Si 225mW  50V  50mA 100MHz pkg:SOT-23 1,3,2
.MODEL QMMBT5087 PNP(IS=5.07E-15 BF=715 VAF=127 IKF=0.03 ISE=7.1E-13 
+ NE=2 BR=4 VAR=12 IKR=0.045 RB=4.12 RE=1.03 RC=0.412 CJE=2.93E-11 VJE=1.1 
+ MJE=0.5 TF=1.59E-9 CJC=9.47E-12 VJC=0.3 MJC=0.3 TR=1.1E-6 XTB=1.5 )

*MMBT5401 MCE 7/5/95
*Si 225mW 150V 500mA 160MHz pkg:SOT-23 1,3,2
.MODEL QMMBT5401 PNP(IS=5.07E-14 BF=232 VAF=220 IKF=0.3 ISE=2.18E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=4.47E-11 
+ VJE=1.1 MJE=0.5 TF=9.78E-10 CJC=1.44E-11 VJC=0.3 MJC=0.3 TR=6.79E-7 
+ XTB=1.5 )

*MMBT6520 MCE 7/5/95
*Si 225mW 350V 500mA 160MHz pkg:SOT-23 1,3,2
.MODEL QMMBT6520 PNP(IS=5.07E-14 BF=176 VAF=336 IKF=0.3 ISE=2.88E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=1.08E-10 
+ VJE=1.1 MJE=0.5 TF=9.78E-10 CJC=1.77E-11 VJC=0.3 MJC=0.3 TR=6.79E-7 
+ XTB=1.5 )

*MMBT8599 MCE 7/5/95
*Si 225mW  80V 500mA 160MHz pkg:SOT-23 1,3,2
.MODEL QMMBT8599 PNP(IS=5.07E-14 BF=286 VAF=161 IKF=0.3 ISE=1.77E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=2.93E-11 
+ VJE=1.1 MJE=0.5 TF=9.78E-10 CJC=9.47E-12 VJC=0.3 MJC=0.3 TR=6.79E-7 
+ XTB=1.5 )

*MMBTA56 MCE 7/5/95
*Si 225mW  80V 500mA 160MHz pkg:SOT-23 1,3,2
.MODEL QMMBTA56 PNP(IS=5.07E-14 BF=286 VAF=161 IKF=0.3 ISE=1.77E-11 
+ NE=2 BR=4 VAR=16 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=1.24E-10 
+ VJE=1.1 MJE=0.5 TF=9.78E-10 CJC=4.02E-11 VJC=0.3 MJC=0.3 TR=6.79E-7 
+ XTB=1.5 )

*MMBTA92 MCE 7/5/95
*Si 225mW 300V 500mA  80MHz pkg:SOT-23 1,3,2
.MODEL QMMBTA92 PNP(IS=5.07E-14 BF=65 VAF=311 IKF=0.3 ISE=7.8E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=1.85 RE=0.463 RC=0.185 CJE=6.58E-11 VJE=1.1 
+ MJE=0.5 TF=1.98E-9 CJC=2.12E-11 VJC=0.3 MJC=0.3 TR=1.38E-6 XTB=1.5 )

*MPS404A MCE 7/5/95
*Si 625mW  35V 150mA  10MHz pkg:TO-92 1,2,3
.MODEL QMPS404A PNP(IS=1.52E-14 BF=260 VAF=106 IKF=0.032 ISE=3.49E-12 
+ NE=2 BR=4 VAR=100 IKR=0.048 RB=1.37 RE=0.343 RC=0.137 CJE=5.94E-12 
+ VJE=1.1 MJE=0.5 TF=1.59E-8 CJC=1.7E-11 VJC=0.3 MJC=0.3 TR=1.02E-6 
+ XTB=1.5 )

*MPS536 MCE 7/5/95
*Si 625mW  10V  30mA 4.5GHz pkg:TO-92 1,2,3
.MODEL QMPS536 PNP(IS=3.04E-15 BF=156 VAF=56.9 IKF=0.018 ISE=1.95E-12 
+ NE=2 BR=4 VAR=18 IKR=0.027 RB=6.87 RE=1.71 RC=0.687 CJE=1.65E-12 VJE=1.1 
+ MJE=0.5 TF=3.53E-11 CJC=1.89E-12 VJC=0.3 MJC=0.3 TR=2.45E-8 XTB=1.5 )

*MPS751 MCE 7/5/95
*Si 625mW  60V    2A  80MHz pkg:TO-92 1,2,3
.MODEL QMPS751 PNP(IS=3.63E-14 BF=260 VAF=139 IKF=2.5 ISE=4.76E-11 
+ NE=2 BR=4 VAR=20 IKR=3.75 RB=0.193 RE=0.0482 RC=0.0193 CJE=4.77E-10 
+ VJE=1.1 MJE=0.5 TF=1.95E-9 CJC=1.53E-10 VJC=0.3 MJC=0.3 TR=1.35E-6 
+ XTB=1.5 )

*MPS2907A MCE 7/5/95
*Si 625mW  60V 600mA 330MHz pkg:TO-92 1,2,3
.MODEL QMPS2907A PNP(IS=4.06E-15 BF=296 VAF=139 IKF=0.36 ISE=5.3E-12 
+ NE=2 BR=4 VAR=20 IKR=0.54 RB=1.17 RE=0.293 RC=0.117 CJE=2.48E-11 VJE=1.1 
+ MJE=0.5 TF=4.82E-10 CJC=1.56E-11 VJC=0.3 MJC=0.3 TR=3.35E-7 XTB=1.5 )

*MPS6652 MCE 7/5/95
*Si 625mW  40V    1A 200MHz pkg:TO-92 1,2,3
.MODEL QMPS6652 PNP(IS=3.97E-14 BF=208 VAF=113 IKF=1 ISE=3.94E-11 
+ NE=2 BR=4 VAR=16 IKR=1.5 RB=0.406 RE=0.101 RC=0.0406 CJE=1.27E-10 
+ VJE=1.1 MJE=0.5 TF=7.95E-10 CJC=5.44E-11 VJC=0.3 MJC=0.3 TR=5.52E-7 
+ XTB=1.5 )

*MPS8599 MCE 7/5/95
*Si 625mW  80V 500mA 240MHz pkg:TO-92 1,2,3
.MODEL QMPS8599 PNP(IS=1.82E-14 BF=208 VAF=161 IKF=0.155 ISE=1.05E-11 
+ NE=2 BR=4 VAR=20 IKR=0.232 RB=1.93 RE=0.482 RC=0.193 CJE=2.48E-11 
+ VJE=1.1 MJE=0.5 TF=6.62E-10 CJC=9.47E-12 VJC=0.3 MJC=0.3 TR=8.5E-7 
+ XTB=1.5 )

*MPSA56 MCE 7/5/95
*Si 625mW  80V 500mA 155MHz pkg:TO-92 1,2,3
.MODEL QMPSA56 PNP(IS=5.07E-14 BF=208 VAF=161 IKF=0.4 ISE=2.81E-11 
+ NE=2 BR=4 VAR=16 IKR=0.6 RB=0.412 RE=0.103 RC=0.0412 CJE=9.67E-11 
+ VJE=1.1 MJE=0.5 TF=1.02E-9 CJC=3.55E-11 VJC=0.3 MJC=0.3 TR=1.3E-6 
+ XTB=1.5 )

*MPSA92 MCE 7/5/95
*Si 625mW 300V 500mA  95MHz pkg:TO-92 1,2,3
.MODEL QMPSA92 PNP(IS=9.12E-13 BF=104 VAF=311 IKF=0.073 ISE=1.02E-10 
+ NE=2 BR=4 VAR=20 IKR=0.109 RB=19.2 RE=4.81 RC=1.92 CJE=8.57E-11 VJE=1.1 
+ MJE=0.5 TF=1.67E-9 CJC=1.82E-11 VJC=0.3 MJC=0.3 TR=1.16E-6 XTB=1.5 )

*MPSW51A MCE 7/5/95
*Si    1W  40V    1A 200MHz pkg:TO-92 1,2,3
.MODEL QMPSW51A PNP(IS=1.83E-14 BF=208 VAF=113 IKF=1 ISE=2.67E-11 
+ NE=2 BR=4 VAR=20 IKR=1.5 RB=0.406 RE=0.101 RC=0.0406 CJE=1.28E-10 
+ VJE=1.1 MJE=0.5 TF=7.95E-10 CJC=5.2E-11 VJC=0.3 MJC=0.3 TR=5.52E-7 
+ XTB=1.5 )

*MPSW56 MCE 7/5/95
*Si    1W  80V 500mA 155MHz pkg:TO-92 1,2,3
.MODEL QMPSW56 PNP(IS=5.07E-14 BF=208 VAF=161 IKF=0.4 ISE=2.81E-11 
+ NE=2 BR=4 VAR=16 IKR=0.6 RB=0.572 RE=0.143 RC=0.0572 CJE=9.67E-11 
+ VJE=1.1 MJE=0.5 TF=1.02E-9 CJC=3.55E-11 VJC=0.3 MJC=0.3 TR=7.13E-7 
+ XTB=1.5 )

*MPSW92 MCE 7/5/95
*Si    1W 300V 500mA  85MHz pkg:TO-92 1,2,3
.MODEL QMPSW92 PNP(IS=5.07E-14 BF=127 VAF=311 IKF=0.3 ISE=3.98E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=7.26 RE=1.81 RC=0.726 CJE=9.95E-11 VJE=1.1 
+ MJE=0.5 TF=1.89E-9 CJC=3.07E-11 VJC=0.3 MJC=0.3 TR=1.31E-6 XTB=1.5 )

*MSA1022B MCE 7/5/95
*Si 200mW  30V  30mA 600MHz pkg:SC-59 1,3,2
.MODEL QMSA1022B PNP(IS=3.04E-15 BF=143 VAF=98.6 IKF=0.018 ISE=2.12E-12 
+ NE=2 BR=4 VAR=20 IKR=0.027 RB=6.87 RE=1.71 RC=0.687 CJE=1.43E-11 VJE=1.1 
+ MJE=0.5 TF=2.39E-10 CJC=4.64E-12 VJC=0.3 MJC=0.3 TR=1.66E-7 XTB=1.5 )

*MSA1022C MCE 7/5/95
*Si 200mW  30V  30mA 600MHz pkg:SC-59 1,3,2
.MODEL QMSA1022C PNP(IS=3.04E-15 BF=234 VAF=98.6 IKF=0.018 ISE=1.3E-12 
+ NE=2 BR=4 VAR=20 IKR=0.027 RB=6.87 RE=1.71 RC=0.687 CJE=1.43E-11 VJE=1.1 
+ MJE=0.5 TF=2.39E-10 CJC=4.64E-12 VJC=0.3 MJC=0.3 TR=1.66E-7 XTB=1.5 )

*MSB709R MCE 7/5/95
*Si 200mW  25V 100mA 360MHz pkg:SC-59 1,3,2
.MODEL QMSB709R PNP(IS=1.01E-14 BF=377 VAF=90 IKF=0.06 ISE=2.69E-12 
+ NE=2 BR=4 VAR=28 IKR=0.09 RB=7.26 RE=1.81 RC=0.726 CJE=3.08E-11 VJE=1.1 
+ MJE=0.5 TF=4.37E-10 CJC=9.94E-12 VJC=0.3 MJC=0.3 TR=3.04E-7 XTB=1.5 )

*MSB710R MCE 7/5/95
*Si 200mW  30V 500mA 160MHz pkg:SC-59 1,3,2
.MODEL QMSB710R PNP(IS=5.07E-14 BF=247 VAF=98.6 IKF=0.3 ISE=2.05E-11 
+ NE=2 BR=4 VAR=28 IKR=0.45 RB=3.08 RE=0.772 RC=0.308 CJE=1.07E-10 VJE=1.1 
+ MJE=0.5 TF=9.78E-10 CJC=3.46E-11 VJC=0.3 MJC=0.3 TR=6.79E-7 XTB=1.5 )

*PZTA92 MCE 7/5/95
*Si  1.5W 300V 500mA  80MHz pkg:SOT-223 2,1,3
.MODEL QPZTA92 PNP(IS=5.07E-14 BF=65 VAF=311 IKF=0.3 ISE=7.8E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=1.24E-10 
+ VJE=1.1 MJE=0.5 TF=1.98E-9 CJC=4.02E-11 VJC=0.3 MJC=0.3 TR=1.38E-6 
+ XTB=1.5 )

*PZTA96 MCE 7/5/95
*Si  1.5W 450V 500mA 160MHz pkg:SOT-223 2,1,3
.MODEL QPZTA96 PNP(IS=5.07E-14 BF=130 VAF=382 IKF=0.3 ISE=3.9E-11 
+ NE=2 BR=4 VAR=20 IKR=0.45 RB=0.412 RE=0.103 RC=0.0412 CJE=1.24E-10 
+ VJE=1.1 MJE=0.5 TF=9.78E-10 CJC=4.02E-11 VJC=0.3 MJC=0.3 TR=6.79E-7 
+ XTB=1.5 )

*ZTX212 ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 500mW  50V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QZTX212 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*ZTX212A ZETEX Spice model    Last revision  4/90
*ZTX Si 500mW  50V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QZTX212A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*ZTX213 ZETEX Spice model    Last revision  4/90   General Purpose
*ZTX Si 500mW  30V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QZTX213 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*ZTX214 ZETEX Spice model    Last revision  4/90   Low Noise
*ZTX Si   2dB  30V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QZTX214 PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*ZTX214A ZETEX Spice model    Last revision  4/90   Low Noise
*ZTX Si   2dB  30V 200mA 200MHz pkg:TO-92 1,2,3
.MODEL QZTX214A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*ZTX231A ZETEX Spice model    Last revision  4/90
*ZTX Si   pkg:TO-92 1,2,3
.MODEL QZTX231A PNP(IS=1.15E-14 BF=330 NF=0.9872 VAF=84.56 IKF=0.1 
+ ISE=5E-14 NE=1.4 BR=13 NR=0.996 VAR=8.15 IKR=0.012 ISC=1.43E-14 NC=1.1 
+ RB=0.2 RE=0.4 RC=0.95 CJE=1.6E-11 TF=4.93E-10 CJC=1.05E-11 VJC=0.565 
+ MJC=0.415 TR=7.355E-8 )

*ZTX550 ZETEX Spice model    Last revision  10/1/90   General Purpose/Medium Power
*ZTX Si    1W  45V    1A 150MHz pkg:TO-92 1,2,3
.MODEL QZTX550 PNP(IS=3.2E-14 BF=170 NF=0.977 VAF=45 IKF=1.25 ISE=7E-15 
+ NE=1.35 BR=50 NR=0.986 VAR=50 IKR=0.15 ISC=9E-15 NC=1.08 RB=0.16 RE=0.195 
+ RC=0.185 CJE=1.04E-10 TF=7E-10 CJC=30.5 VJC=0.395 MJC=0.415 TR=3E-9 )

*ZTX558 ZETEX Spice model   Last revision 20/3/92   High Voltage
*ZTX Si    1W 400V 500mA pkg:TO-92 1,2,3
.MODEL QZTX558 PNP(IS=7.84E-14 BF=200 NF=0.9977 VAF=349 IKF=0.096 
+ ISE=3.35E-14 NE=1.689 BR=3.4 NR=0.9978 VAR=82 IKR=0.15 ISC=9.42E-12 
+ NC=1.05 RB=0.133 RE=0.5725 RC=0.748 CJE=1.1E-10 TF=1.13E-9 CJC=1.76E-11 
+ VJC=0.9135 MJC=0.5932 TR=7.5E-5 )

*ZTX749 ZETEX Spice model       Last revision  17/7/90   Medium Power
*ZTX Si    1W  25V    2A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX749 PNP(IS=2.6E-13 BF=210 NF=0.999 VAF=27 IKF=7 ISE=1.2E-13 
+ NE=1.43 BR=70 NR=0.982 VAR=14 IKR=0.6 ISC=1.204E-12 NC=1.447 RB=0.3 
+ RE=0.065 RC=0.04 CJE=4.1E-10 TF=6.5E-10 CJC=1.4E-10 VJC=0.305 MJC=0.35 
+ TR=1.2E-8 )

*ZTX750 ZETEX Spice model   Last revision  23/1/91   Medium Power
*ZTX Si    1W  45V    2A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX750 PNP(IS=2.72E-13 BF=170 NF=1.004 VAF=70 IKF=2.75 ISE=1E-13 
+ NE=1.535 BR=23 NR=1.005 VAR=40 IKR=0.55 ISC=5.15E-14 NC=1.13 RB=0.07 
+ RE=0.065 RC=0.085 CJE=3.6E-10 TF=9.4E-10 CJC=9E-11 VJC=0.705 MJC=0.46 
+ TR=6E-8 )

*ZTX751 ZETEX Spice model   Last revision  23/1/91   Medium Power
*ZTX Si    1W  60V    2A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX751 PNP(IS=2.72E-13 BF=170 NF=1.004 VAF=70 IKF=2.75 ISE=1E-13 
+ NE=1.535 BR=23 NR=1.005 VAR=40 IKR=0.55 ISC=5.15E-14 NC=1.13 RB=0.07 
+ RE=0.065 RC=0.085 CJE=3.6E-10 TF=9.4E-10 CJC=9E-11 VJC=0.705 MJC=0.46 
+ TR=6E-8 )

*ZTX757 ZETEX Spice model   Last revision  30/11/90   Medium Power/High Voltage
*ZTX Si    1W 300V 500mA  30MHz pkg:TO-92 1,2,3
.MODEL QZTX757 PNP(IS=1.31E-13 BF=97 VAF=1060 IKF=0.25 ISE=7.5E-14 
+ BR=3.2 VAR=50 IKR=0.5 ISC=2E-13 NC=1.8 RB=0.1 RE=0.19 RC=0.2 CJE=4.45E-10 
+ TF=3.03E-9 CJC=4.8E-11 VJC=0.775 MJC=0.56 TR=1.5E-6 )

*ZTX758 ZETEX Spice model   Last revision 15/4/92   High Voltage
*ZTX Si    1W 400V 500mA pkg:TO-92 1,2,3
.MODEL QZTX758 PNP(IS=2.72E-13 BF=175 NF=1.003 VAF=450 IKF=0.205 
+ ISE=8.24E-14 NE=1.48 BR=5.5 NR=1.004 VAR=78 IKR=0.6 ISC=1E-14 NC=1.03 
+ RB=0.1 RE=0.278 RC=0.333 CJE=3.65E-10 TF=1.3E-9 CJC=4E-11 VJC=0.715 
+ MJC=0.545 TR=3.09E-7 )

*ZTX788A ZETEX Spice model   Last revision 3/6/92
*ZTX Si   pkg:TO-92 1,2,3
.MODEL QZTX788A PNP(IS=1.202E-12 BF=490 NF=1.019 VAF=10.8 IKF=3.8 
+ ISE=2.2E-13 NE=1.57 BR=190 NR=1.011 VAR=13.6 IKR=0.35 ISC=2.38E-12 
+ NC=1.693 RB=0.05 RE=0.028 RC=0.042 CJE=3.35E-10 TF=7.8E-10 CJC=1.56E-10 
+ VJC=0.9718 MJC=0.4266 TR=4.6E-9 )

*ZTX788B ZETEX Spice model   Last revision 2/1/92
*ZTX Si    1W  15V    3A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX788B PNP(IS=1.252E-12 BF=770 NF=1.012 VAF=11 IKF=2.6 ISE=1.32E-13 
+ NE=1.483 BR=350 NR=1.005 VAR=10.5 IKR=0.32 ISC=5.26E-14 NC=1.186 RB=0.053 
+ RE=0.031 RC=0.044 CJE=2.8E-10 TF=7.5E-10 CJC=1.37E-10 VJC=0.275 MJC=0.34 
+ TR=2.3E-9 )

*ZTX789A ZETEX Spice model   Last revision 3/1/92
*ZTX Si    1W  25V    3A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX789A PNP(IS=8.51E-13 BF=540 NF=1.007 VAF=15.5 IKF=3.4 
+ ISE=1.61E-13 NE=1.506 BR=180 NR=1.003 VAR=9 IKR=0.3 ISC=7.38E-14 NC=1.227 
+ RB=0.05 RE=0.32 RC=0.052 CJE=3E-10 TF=7.3E-10 CJC=1.4E-10 VJC=0.26 
+ MJC=0.335 TR=4.2E-9 )

*ZTX790A ZETEX Spice model   Last revision 3/1/92
*Note, The model may be inaccurate for collector currents above 1.5A.
*ZTX Si    1W  40V    2A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX790A PNP(IS=1.097E-12 BF=650 NF=1.01 VAF=23.5 IKF=1.7 
+ ISE=9.89E-14 NE=1.473 BR=270 NR=1.004 VAR=30 IKR=0.2 ISC=5.49E-14 
+ NC=1.074 RB=0.055 RE=0.049 RC=0.078 CJE=2.75E-10 TF=7.5E-10 CJC=9.6E-11 
+ VJC=0.67 MJC=0.495 TR=1.08E-8 )

*ZTX792A ZETEX Spice model   Last revision 7/1/92
*Note, The model may be inaccurate for collector currents above 1.2A.
*ZTX Si    1W  70V    2A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX792A PNP(IS=5.98E-13 BF=525 NF=1.002 VAF=30 IKF=1.25 ISE=1.45E-13 
+ NE=1.54 BR=75 NR=0.995 VAR=34 IKR=0.4 ISC=1.59E-13 NC=1.039 RB=0.06 
+ RE=0.059 RC=0.08 CJE=2.86E-10 TF=7.5E-10 CJC=9E-11 VJC=0.71 MJC=0.5 
+ TR=9.375E-8 )

*ZTX795A ZETEX Spice model   Last revision 8/1/92
*Note, Model may be inaccurate for collector currents above 0.45A.
*ZTX Si    1W 140V 500mA 100MHz pkg:TO-92 1,2,3
.MODEL QZTX795A PNP(IS=7.29E-13 BF=595 NF=1.003 VAF=45 IKF=0.4 ISE=8.77E-14 
+ NE=1.448 BR=65 NR=0.996 VAR=41 IKR=0.42 ISC=1.53E-13 NC=1.02 RB=0.056 
+ RE=0.093 RC=0.143 CJE=2.75E-10 TF=8.3E-10 CJC=6.55E-11 VJC=0.74 MJC=0.52 
+ TR=3.07E-7 )

*ZTX796A ZETEX Spice model   Last revision 9/1/92
*Note, Model may be inaccurate for collector currents above 0.2A.
*ZTX Si    1W 200V 500mA 100MHz pkg:TO-92 1,2,3
.MODEL QZTX796A PNP(IS=7.01E-13 BF=500 NF=1.005 VAF=450 IKF=0.43 
+ ISE=1.14E-13 NE=1.471 BR=6.5 NR=1.025 VAR=48 IKR=0.37 ISC=4.11E-13 
+ NC=1.007 RB=0.07 RE=0.2 RC=0.139 CJE=2.8E-10 TF=8.3E-10 CJC=5.2E-11 
+ VJC=0.65 MJC=0.515 TR=4.5E-6 )

*ZTX948 ZETEX Spice model   Last revision 26/5/92
*ZTX Si  1.2W  20V  4.5A  80MHz pkg:TO-92 1,2,3
.MODEL QZTX948 PNP(IS=1.555E-12 BF=208 NF=1.013 VAF=22.4 IKF=14.7 
+ ISE=1.48E-13 NE=1.485 BR=140 NR=1.004 VAR=15.4 IKR=1.34 ISC=1.395E-11 
+ NC=1.702 RB=0.02 RE=0.0177 RC=0.015 CJE=1.23E-9 TF=1.38E-9 CJC=4.4E-10 
+ VJC=0.685 MJC=0.3604 TR=4.8E-9 )

*ZTX949 ZETEX Spice model   Last revision 27/5/92
*ZTX Si  1.2W  30V  4.5A 100MHz pkg:TO-92 1,2,3
.MODEL QZTX949 PNP(IS=1.511E-12 BF=208 NF=1.013 VAF=32.7 IKF=12.4 
+ ISE=1.34E-13 NE=1.42 BR=145 NR=1.009 VAR=26.5 IKR=1.25 ISC=1.39E-13 
+ NC=1.14 RB=0.026 RE=0.019 RC=0.0175 CJE=1.17E-9 TF=1.01E-9 CJC=3.62E-10 
+ VJC=0.4294 MJC=0.338 TR=7.5E-9 )

*ZTX951 ZETEX Spice model   Last revision 27/5/92
*ZTX Si  1.2W  60V    4A 120MHz pkg:TO-92 1,2,3
.MODEL QZTX951 PNP(IS=1.377E-12 BF=187 NF=1.013 VAF=66.3 IKF=5 ISE=1.4E-13 
+ NE=1.41 BR=56 NR=1.01 VAR=33 IKR=0.9 ISC=1.7E-12 NC=1.4 RB=0.029 RE=0.02 
+ RC=0.0255 CJE=1.15E-9 TF=8.3E-10 CJC=2.87E-10 VJC=0.4956 MJC=0.4522 
+ TR=2E-8 )

*ZTX953 ZETEX Spice model   Last revision 27/5/92
*ZTX Si  1.2W 100V  3.5A 125MHz pkg:TO-92 1,2,3
.MODEL QZTX953 PNP(IS=1.665E-12 BF=220 NF=1.014 VAF=55 IKF=3.4 ISE=6.2E-13 
+ NE=1.62 BR=40 NR=1.011 VAR=43 IKR=0.95 ISC=3E-12 NC=1.4 RB=0.032 RE=0.0295 
+ RC=0.034 CJE=1.1E-9 TF=7.95E-10 CJC=2.65E-10 VJC=0.76 MJC=0.5286 TR=3.75E-8 )

*ZTX955 ZETEX Spice model   Last revision 28/5/92
*ZTX Si  1.2W 140V    3A 110MHz pkg:TO-92 1,2,3
.MODEL QZTX955 PNP(IS=1.103E-12 BF=195 NF=1.007 VAF=70 IKF=4.2 ISE=2.72E-13 
+ NE=1.46 BR=30 NR=1.005 VAR=54 IKR=0.55 ISC=3E-12 NC=1.4 RB=0.033 RE=0.0325 
+ RC=0.0525 CJE=1.1E-9 TF=8.95E-10 CJC=2.26E-10 VJC=0.7572 MJC=0.5325 
+ TR=6.78E-8 )

*ZTX956 ZETEX Spice model   Last revision 28/5/92
*ZTX Si  1.2W 200V    2A 110MHz pkg:TO-92 1,2,3
.MODEL QZTX956 PNP(IS=1.371E-12 BF=215 NF=1.009 VAF=86 IKF=2.5 ISE=6.55E-13 
+ NE=1.584 BR=18 NR=1.008 VAR=59 IKR=0.9 ISC=6E-12 NC=1.6 RB=0.035 RE=0.0455 
+ RC=0.0745 CJE=1.08E-9 TF=8.95E-10 CJC=1.91E-10 VJC=0.8577 MJC=0.5535 
+ TR=1.18E-7 )

*ZTX957 ZETEX Spice model   Last revision 2/6/92
*ZTX Si  1.2W 300V    1A  85MHz pkg:TO-92 1,2,3
.MODEL QZTX957 PNP(IS=1.315E-12 BF=215 NF=1.011 VAF=325 IKF=1.05 
+ ISE=5.5E-13 NE=1.524 BR=8 NR=1.01 VAR=110 IKR=0.63 ISC=6E-12 NC=1.8 
+ RB=0.037 RE=0.098 RC=0.177 CJE=1.1E-9 TF=1.23E-9 CJC=1.4E-10 VJC=0.7592 
+ MJC=0.5432 TR=5.9E-7 )

*ZTX958 ZETEX Spice model   Last revision 2/6/92
*ZTX Si  1.2W 400V 500mA  85MHz pkg:TO-92 1,2,3
.MODEL QZTX958 PNP(IS=1.607E-12 BF=215 NF=1.013 VAF=326 IKF=0.7 ISE=1.75E-13 
+ NE=1.46 BR=3.5 NR=1.05 VAR=78 IKR=0.85 ISC=5E-11 NC=1.7 RB=0.05 RE=0.126 
+ RC=0.123 CJE=1.05E-9 TF=1.26E-9 CJC=1.13E-10 VJC=0.5949 MJC=0.5069 
+ TR=1.28E-6 )

*ZTX968 ZETEX Spice model   Last revision 25/5/92
*ZTX Si  1.2W  12V  4.5A  85MHz pkg:TO-92 1,2,3
.MODEL QZTX968 PNP(IS=3.58E-12 BF=500 NF=1.015 VAF=11.4 IKF=11 ISE=1.58E-13 
+ NE=1.42 BR=245 NR=1.01 VAR=8.4 IKR=1.4 ISC=1.48E-11 NC=1.637 RB=0.024 
+ RE=0.0164 RC=0.0235 CJE=1.05E-9 TF=1.38E-9 CJC=4.38E-10 VJC=0.673 
+ MJC=0.361 TR=2.3E-9 )

*MMBR521 Motorola
********************
* Version 1.1.0a
*MOT Si 333mW  10V  70mA 3.5GHz pkg:SOT-23 1,3,2
.SUBCKT XMMBR521 100 200 300 
LCL 100 199 2.8E-10 
LBL 200 201 3.2E-10 
LBB 201 299 8.4E-10 
LEL 300 301 3.2E-10 
LEB 301 399 8.4E-10 
CCB 201 199 6E-14 
CCE 199 301 2.4E-13 
CBE 201 301 1.2E-13 
CCG 199 0 1E-13 
CBG 201 0 1E-13 
CEG 301 0 1E-13 
X1 199 299 399 MMBR521
.ENDS XMMBR521
*
.SUBCKT MMBR521 100 200 300 
CEPAD 300 100 2.4E-13 
CBPAD 200 100 2.4E-13 
Q1 100 200 300 DMMBR521 
*
.MODEL DMMBR521 PNP 
+ IS = 1.755E-15 
+ BF = 107 
+ NF = 1.004 
+ VAF = 15 
+ IKF = 0.13 
+ ISE = 2.178E-13 
+ NE = 1.51 
+ BR = 47 
+ NR = 0.9993 
+ VAR = 3 
+ IKR = 0.0038 
+ ISC = 4.18E-15 
+ NC = 1.283 
+ RB = 1 
+ IRB = 1.2E-05 
+ RBM = 0.3 
+ RE = 1 
+ RC = 8 
+ XTB = 0 
+ EG = 1.11 
+ XTI = 3 
+ CJE = 2.9E-12 
+ VJE = 0.83 
+ MJE = 0.38 
+ CJC = 1.7E-12 
+ VJC = 0.712 
+ MJC = 0.425 
+ XCJC = 0.5 
+ TF = 4.8E-11 
+ XTF = 9.936 
+ VTF = 0.8 
+ ITF = 0.2 
+ PTF = 10 
+ TR = 8.2E-09 
+ FC = 0.9 
.ENDS MMBR521

*=======================================
*HFA3128
*COPYRIGHT (C) 1993 HARRIS CORPORATION
*ALL RIGHTS RESERVED
*
*HFA3046/3096/3127/3128 PSpice MODEL
*REV: 12-2-93 Added updated PNP model
*
*      -----  BJT MODELS  -----
*
***** UHFP - LE=3 WE=50  *****
*
.SUBCKT PUHF 1 2 3
Q1 1 2 3 PUHFARRY
.model PUHFARRY PNP 
+     ( IS= 1.027E-16    XTI= 3.000E+00     EG= 1.110E+00    VAF= 3.000E+01
+      VAR= 4.500E+00     BF= 5.228E+01    ISE= 9.398E-20     NE= 1.400E+00
+      IKF= 5.412E-02    XTB= 0.000E+00     BR= 7.000E+00    ISC= 1.027E-14
+       NC= 1.800E+00    IKR= 5.412E-02     RC= 3.420E+01    CJC= 4.951E-13
+      MJC= 3.000E-01    VJC= 1.230E+00     FC= 5.000E-01    CJE= 2.927E-13
+      MJE= 5.700E-01    VJE= 8.800E-01     TR= 4.000E-09     TF= 20.05E-12    
+      ITF= 2.001E-02    XTF= 1.534E+00    VTF= 1.800E+00    PTF= 0.000E+00
+     XCJC= 9.000E-01    CJS= 1.150E-13    VJS= 7.500E-01    MJS= 0.000E+00  
+       RE= 1.848E+00     RB= 3.271E+01    RBM= 9.902E-01     KF= 0.000E+00
+       AF= 1.000E+00  )       
.ENDS PUHF
*
*=======================================
*HAR Si 600mW  12V  40mA   8GHz pkg:SO-16 (A:2,4,3)(B:6,8,7)(C:11,9,10)(D:12,14,13)(E:1,15,16) 
.SUBCKT XHFA3128 1 2 3
X1 1 2 3 PUHF
.ENDS XHFA3128

*=========================================================================
* Copyright notice for all models labeled "Motorola":
*
* Copyright (c) Motorola, Inc. 1996
*
* The values contained in these parameter sets may not be modified in any 
* way.
*
* No additional parameters may be added to these parameter sets without 
* prior written permission from Motorola.
*
* Macromodels, simulation models, or other models provided by Motorola, 
* directly or indirectly, are not warranted by Motorola as fully 
* representing all of the specifications and operating characteristics of 
* the semiconductor product to which the model relates. Moreover, these 
* models are furnished on an "as is" basis without support or warranty of 
* any kind, either expressed or implied, regarding the use thereof and 
* Motorola specifically disclaims all implied warranties of 
* merchantability and fitness of the models for any purpose.  Motorola 
* does not assume any liability arising out of the application or use of 
* the models including infringement of patents and copyrights nor does 
* Motorola convey any license under its patents and copyrights or the 
* rights of others. Motorola reserves the right to make changes without 
* notice to any model. Although macromodels can be a useful tool in 
* evaluating device performance in various applications, they cannot model 
* exact device performance under all conditions, nor are they intended to 
* replace breadboarding for final verification. 
*
* Motorola SPICE parameter sets are also available on the Motorola SPS 
* World Wide Web server <URL:http://motserv.indirect.com/>


*   Copyright notice for all models labeled "ZETEX":
*
*                          (C)  1992 ZETEX PLC
*
*   The copyright in these models  and  the designs embodied belong
*   to Zetex PLC ("Zetex").  They  are  supplied  free of charge by
*   Zetex for the purpose of research and design and may be used or
*   copied intact  (including this notice)  for  that purpose only.
*   All other rights are reserved. The models are believed accurate
*   but  no condition  or warranty  as to their  merchantability or
*   fitness for purpose is given and no liability in respect of any
*   use is accepted by Zetex PLC, its distributors or agents.
*
*
*   Zetex PLC, Fields New Road, Chadderton, Oldham  OL9 8NP  U.K.



