#!/bin/bash

perm() {
  local items="$1"
  local out="$2"
  local i
  [[ "$items" == "" ]] && echo "$out" && return
  for (( i=0; i<${#items}; i++ )) ; do
    perm "${items:0:i}${items:i+1}" "$out${items:i:1}"
    done
  }

pushd .
cd work2
footprintlist=`ls *.fp`

for type in EBC SGD IOG AAK AKK AKG; do
	for pinout in `perm $type`; do
		pin1=${pinout:0:1}
		pin2=${pinout:1:1}
		pin3=${pinout:2:1}
		echo $pin1$pin2$pin3
		for footprint in $footprintlist ; do
			fp=`basename $footprint .fp`"-"$pinout".fp"
			echo $fp
			echo "# Pinout:  123 = "$pinout >out/$fp
			cat $footprint |\
			sed "s/\"\" \"1\"/\"$pin1\" \"1\"/g
			     s/\"\" \"2\"/\"$pin2\" \"2\"/g
			     s/\"\" \"3\"/\"$pin3\" \"3\"/g
			     s/\"1\" \"1\"/\"$pin1\" \"1\"/g
			     s/\"2\" \"2\"/\"$pin2\" \"2\"/g
			     s/\"3\" \"3\"/\"$pin3\" \"3\"/g" \
			>> out/$fp
		done
	done
done
popd
