
(use-modules (ice-9 regex))

(define prefix-list '())

(define (get-next-uref prefix)
  (let ((available-prefix (assoc prefix prefix-list)))
    (cond (available-prefix
	   (set-cdr! available-prefix 
		     (+ (cdr available-prefix) 1))
	   (cdr available-prefix))
	  (else
	   (set! prefix-list (cons (cons prefix 1) prefix-list))
	   1))))


;; Total Guile
(define (get-prefix value)
  (let ((prefix (string-match "^[A-Z]*" value)))
    (if (= 0 (match:end prefix))
	#f
	(match:substring prefix))))
	   
(define (auto-uref attribs)
  (for-each 
   (lambda (attrib) 
     (let* ((name-value (get-attribute-name-value attrib))
	    (name (car name-value))
	    (value (cdr name-value))
	    (prefix (get-prefix value)))
       (if (string=? name "uref")
	   (set-attribute-value! attrib (string-append 
					 prefix 
					 (number->string (get-next-uref prefix)))))))
   attribs))
