using namespace std;

#include <iostream>
#include <cstdio>
#include <cerrno>
#include <pcap.h>
#include <event.h>
#include <cstring>
#include <cstdlib>
#include <sys/socket.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include "network.h"
#include "capture.h"
#include "global.h"
#include "packet.h"



void on_recv(int connfd, short op, void *arg)
{

#ifdef DEBUG
	printf("on recv \n");
#endif

	int n;
	char buf[2000];
	socklen_t socklen;
	struct sockaddr_in client_addr;

	getpeername(connfd, (struct sockaddr *)&client_addr, &socklen);

	do{
	    n = recv(connfd, buf, 2000, 0);
	    if( 0 == n){
		    fprintf(stderr, "The client closes the connection\n");
		    close(connfd);
	    	return;
	    }

	    if(n == -1) {
		    if(errno == EAGAIN) return;
		    else {
			    perror("on_recv() error!\n");
			    close(connfd);
			    return;
		    }
	    }

	}while(n == 2000);

}


void on_accept(int listenfd, short op, void *arg)
{

#ifdef DEBUG
	printf("on accept \n");
#endif

	struct event *conn_ev = NULL;
	struct sockaddr_in client_addr;
	socklen_t addrlen = sizeof(client_addr);
	int connfd;

	connfd = accept(listenfd, (struct sockaddr *)&client_addr, &addrlen);
	if(connfd == -1){
		perror("accept() error!\n");
		return;
	}


	if(Network::setnonblock(connfd) == -1){
	    	perror("set connfd NONBLOCKING failed\n");
	    	close(connfd);
	    	return;
	}

	/* add an event for this connfd */
	conn_ev = (struct event *)malloc(sizeof(struct event));
	if(!conn_ev) {
		perror("in on_accept(), malloc(conn_ev) failed!\n");
		exit(1);
	}
	event_set(conn_ev, connfd, EV_READ|EV_PERSIST, on_recv, conn_ev);
	event_base_set(base, conn_ev);
	if(event_add(conn_ev, NULL) == -1){
	    	fprintf(stderr, "event_add() error!\n");
	    	close(connfd);
	    	return;
	}

}

void process_pkt(u_char *user, const struct pcap_pkthdr *pkthdr, const u_char *packet)
{
#ifdef DEBUG
	printf("process_pkt() is invoked\n");
#endif
	u_char *pkt;
	u_int len;

	/* strip the Ethernet header */
	len = pkthdr->len - ETHERNET_HDR_LEN;
	packet += ETHERNET_HDR_LEN;

    if(pkthdr->caplen != pkthdr->len){
    	fprintf(stderr, "captured length is smaller than real packet length!\n");
        return;
    }

    pkt = (u_char *)malloc(len);
    memcpy(pkt, packet, len);

    Packet::validate_ip(pkt, len);
}


void on_capture(int pcapfd, short op, void *arg)
{
    int res;
#ifdef DEBUG
	printf("on capture \n");
#endif
	pcap_t *handle;
	handle = (pcap_t *)arg;

	res = pcap_dispatch(handle, 1, process_pkt, NULL);

#ifdef DEBUG
	printf("pcap_dispatch() returns %d\n", res);
#endif
}


int main (int argc, char *argv[]){

	int listenfd, pcapfd;
	char interface[20];
	int res;
	pcap_t *pcap_handle;

	struct sockaddr_in local_addr;
	struct event listen_ev, pcap_ev;


	strcpy(interface, "eth0");
	Network::get_ip_dev(local_ip, interface);


	memset(&local_addr, 0, sizeof(local_addr));
	local_addr.sin_family = AF_INET;
	local_addr.sin_addr.s_addr = inet_addr(local_ip);
	local_addr.sin_port = htons(RELAY_PORT);

	pcap_handle = Capture::create_pcap(interface, NONBLOCKING);
	pcapfd = pcap_get_selectable_fd(pcap_handle);
	if(pcapfd<0){
		perror("pcap_get_selectable_fd() failed!\n");
		exit(1);
	}



	listenfd = socket(AF_INET, SOCK_STREAM, 0);
	if(listenfd<0){
	    perror("Create socket listenfd failed!\n");
	    exit(EXIT_FAILURE);
	}

	res = bind(listenfd, (struct sockaddr *)&local_addr, sizeof(local_addr));
	if(0 != res)
	{
	    perror("bind(listenfd) failed!\n");
	    exit(EXIT_FAILURE);
	}

	res = listen(listenfd, 32);
	if(0 != res){
	    perror("listen() failed!\n");
	    exit(EXIT_FAILURE);
	}

    if (Network::setnonblock(pcapfd) == -1) return -1;

	if (Network::setnonblock(listenfd) == -1) return -1;

	base = event_init();

	event_set(&listen_ev, listenfd, EV_READ|EV_PERSIST, on_accept, NULL );
	event_base_set(base, &listen_ev);
	if(event_add(&listen_ev, NULL) == -1){
	    perror("event_add() failed for listen_ev!\n");
	    exit(1);
	}

	event_set(&pcap_ev, pcapfd, EV_READ|EV_PERSIST, on_capture, pcap_handle);
	event_base_set(base, &pcap_ev);
	if(event_add(&pcap_ev, NULL) == -1){
	    perror("event_add() failed for pcap_ev!\n");
	    exit(-1);
	}

	event_base_dispatch(base);
}
