using namespace std;

#ifndef __NETWORK_H
#define __NETWORK_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pcap.h>

class Network{

	static char errbuf[PCAP_ERRBUF_SIZE];

public:

	/* get default network interface */
	static void get_dev(char* dev);

	/* get IP address on a specific network interface */
	static void get_ip_dev(char* ipaddr, char* interface);

	/* convert an IP string to unsigned integer in network order */
	static inline void get_ip_port_from_sockaddr(struct sockaddr_in *addr, u_int32_t *ip, u_int16_t *port);


	/* convert an IP string to unsigned integer */
	static inline u_int32_t ip_atoi(const char* addr);


	/* make a sockaddr_in structure
	 *  * ip_int and port_int are in network order
	 *   * */
	static struct sockaddr_in *make_sockaddr(u_int32_t ip_int, u_int16_t port_int);


	static int setnonblock(int fd);


	/* improved connect() function
	 *  * return 0 if success
	 *   * return -1 if connection refused, timeout, or network problem
	 *    * otherwise, exit the program
	 *     * */
	static int Connect(int sockfd, const struct sockaddr *addr, socklen_t addrlen);


	/* improved send() function
	 *  * return -1 if EPIPE or EAGAIN
	 *   * or exit if other errors
	 *    * or return number of bytes
	 *     * */
	static ssize_t Send(int sockfd, const void *buf, size_t len);


};

#endif
