
#include "packet.h"
#include "global.h"
#include <assert.h>


/* validate an IP packet
 * if len>0, check whether the length is consistent
 * if no need to validate length, put len = 0
 * */
void Packet:: validate_ip(u_char *pkt, unsigned short len)
{
        struct ip *iphdr;
        struct tcphdr *tcphdr;


        iphdr = (struct ip *)pkt;
        assert(iphdr->ip_v == 4);
        assert(iphdr->ip_hl == 5);
        assert(iphdr->ip_p == 6);
#ifdef DEBUG
        printf("iphdr->ip_len=%d, len=%d\n",ntohs(iphdr->ip_len),len);
#endif
	    if(len) assert(ntohs(iphdr->ip_len) == len);

#ifdef DEBUG
	    tcphdr = (struct tcphdr *)(pkt+4*iphdr->ip_hl);
	    printf("SYN:%d, ACK:%d, RST:%d, PSH:%d, FIN:%d, checksum:%X\n", tcphdr->syn, tcphdr->ack, tcphdr->rst, tcphdr->psh, tcphdr->fin, tcphdr->check );
#endif


}
