// Cannibalized from...
// http://www.cs.cmu.edu/~srini/15-441/F02/Projects/lab01/ssl_echo/
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>

#include <netinet/in.h>
#include <netdb.h>

#include <openssl/ssl.h>
#include <openssl/err.h>

#define SERVER_PORT 12000
#define SERVER_KEYFILE "ssl_server.pem"
#define SERVER_BUFFER_SIZE 1024
#define MAX_REQUEST_QUEUE 5

static BIO*    bio_err;

void ssl_sigpipe_handle( int x ) 
{
    /* Ignore broken pipes */
}

int ssl_password_cb( char* buf, int num, int rwflag, void* userdata ) 
{
    return 0;
}

void SSL_Error( SSL* ssl, int ssl_error_code ) 
{
    switch (SSL_get_error(ssl, ssl_error_code)) {
    case SSL_ERROR_NONE:
        fprintf(stderr, "SSL_ERROR_NONE\n");
        break;
    case SSL_ERROR_ZERO_RETURN:
        fprintf(stderr, "SSL_ERROR_ZERO_RETURN\n");
        break;
    case  SSL_ERROR_WANT_READ:
        fprintf(stderr, "SSL_ERROR_WANT_READ\n");
        break;
    case SSL_ERROR_WANT_WRITE:
        fprintf(stderr, "SSL_ERROR_WANT_WRITE\n");
        break;
    case SSL_ERROR_SYSCALL:
        fprintf(stderr, "SSL_ERROR_SYSCALL: %d\n", ssl_error_code);
        break;
    case SSL_ERROR_SSL:
        fprintf(stderr, "SSL_ERROR_SSL\n");
        break;
    default:
        fprintf(stderr, "Unknown!\n");
        break;
    }
    
    fprintf(stderr, "SSL error queue:\n");
    ERR_print_errors(bio_err);
}

void FatalError( char* str ) 
{
    /* Print out the error message, flush the SSL error buffer, and exit */
    BIO_printf(bio_err, "%s\n", str);
    ERR_print_errors(bio_err);
    exit(1);
}

SSL_CTX* ssl_initialize_context( char* keyfile, char* ca ) 
{
    SSL_CTX*    context;
    
    /* bio_err is a buffered I/O object which we will use for writing error 
       messages to stderr */
    if ( !bio_err ) 
    {
        bio_err = BIO_new_fp(stderr, BIO_NOCLOSE);
    }
    
    /* Ignore broken pipes which would cause our program to terminate 
       prematurely */
    signal(SIGPIPE, ssl_sigpipe_handle);
    
    context = SSL_CTX_new(TLSv1_server_method());
    
    if ( keyfile != NULL ) 
    {
        if ( !(SSL_CTX_use_certificate_chain_file(context, keyfile)) )
            FatalError("Can't read certificate file");
        
        /* If our private key is encrypted, then the password callback is used to
        get the password to decrypt the file.  Our private key is not encrypted,
        so this is not used. */
        SSL_CTX_set_default_passwd_cb(context, ssl_password_cb);
        if ( !(SSL_CTX_use_PrivateKey_file(context, keyfile, SSL_FILETYPE_PEM)) )
            FatalError("Can't read key file");
    }
    
    /* Load the Certificate Authorities we trust.  In this case, we are going 
    to trust that ``server.pem" is the CA.  Otherwise, we wouldn't be able to
    establish a connection, since we don't explicitly trust anyone!  */
    if ( !(SSL_CTX_load_verify_locations(context, ca, 0)) )
        FatalError("Can't read CA list");
            
    return context;
}

void ssl_close_connection( int socket, SSL* ssl, BIO* bio ) 
{
    int ssl_error_code;
    
    /* If we were the first party to call SSL_shutdown(), then we will get a
    return value of '0'.  So, we try again, but first we send a TCP FIN to
    trigger the other side's close_notify state. */
    
    ssl_error_code = SSL_shutdown(ssl);
    
    if ( !ssl_error_code ) 
    {
        fprintf(stderr, "Forcing shutdown of socket\n");
        shutdown( socket, 1 );
        ssl_error_code = SSL_shutdown(ssl);
    }
    
    switch (ssl_error_code) 
    {
    case 1:
        fprintf(stderr, "Shutdown successful\n");
        break;
        
    case 0:
    case -1:
    default:
        fprintf(stderr, "Error shutting down SSL connection:\n");
        SSL_Error(ssl, ssl_error_code);
        break;
    }
    
    // free memory
    SSL_free(ssl);
}



int main( int argc, char *argv[] ) 
{

    int                 listenSocket;
    int                 portNumber = SERVER_PORT;
    int                 optVal;
    struct sockaddr_in  serverAddress;

    int                 clientSocket;
    socklen_t           clientLength;
    struct sockaddr_in  clientAddress;
    
    SSL*                ssl_connection;
    SSL_CTX*            ssl_context;
    BIO*                ssl_client_bio;
    int                 ssl_error_code;
    
    char                buf[SERVER_BUFFER_SIZE];
    int                 dataTransmitted;
    
    
    SSL_load_error_strings();
    SSL_library_init();
    
    // make the SSL context
    // we specify our keyfile twice here, the first is so we actually load our
    // private key, and the second is so we trust ourselves explicitly as a
    // certificate authority
    ssl_context = ssl_initialize_context( SERVER_KEYFILE, SERVER_KEYFILE );
    
    
    // set up the socket for listening
    listenSocket = socket( AF_INET, SOCK_STREAM, 0 );
    if ( listenSocket < 0 )
        FatalError( "ERROR opening socket, terminating\n" );
    
    optVal = 1;
    setsockopt( listenSocket, SOL_SOCKET, SO_REUSEADDR, (const void *)&optVal, sizeof(int) );
    
    
    bzero( (char *)&serverAddress, sizeof(serverAddress) );
    
    serverAddress.sin_family = AF_INET;
    serverAddress.sin_addr.s_addr = htonl( INADDR_ANY );
    serverAddress.sin_port = htons( portNumber );
        
    if ( bind(listenSocket, (struct sockaddr *)&serverAddress, sizeof(serverAddress)) < 0 )
        FatalError( "ERROR on binding, terminating\n" );

    if ( listen( listenSocket, MAX_REQUEST_QUEUE ) < 0 )
        FatalError( "ERROR on listen, terminating\n" );

    clientLength = sizeof(struct sockaddr_in);

    printf( "SSL Echo server started on port %d\n", portNumber );
    printf( "Awaiting connections...\n" );
    
    while (1) 
    {

        clientSocket = accept( listenSocket, (struct sockaddr *)&clientAddress, &clientLength );
        if (clientSocket < 0) 
        {
            FatalError( "ERROR on accept, terminating\n" );
        }
        
        ssl_client_bio = BIO_new_socket( clientSocket, BIO_NOCLOSE );
        ssl_connection = SSL_new( ssl_context );
        SSL_set_bio( ssl_connection, ssl_client_bio, ssl_client_bio );
        printf("SSL connection accepted!\n");
        
        if ( (ssl_error_code = SSL_accept(ssl_connection)) <= 0) {
            fprintf(stderr, "CODE %d\n", ssl_error_code);
            SSL_Error(ssl_connection, ssl_error_code);
            FatalError("ERROR in SSL_accept\n");
        }
        
        
        /* Now that our communications are secure, we begin the echo process.
        We read in data from the ssl_client_bio object, and send it back to the
        client.  We terminate when the client sends a control-d character
        (hex 0xFF). */
        do {
            bzero(buf, SERVER_BUFFER_SIZE);

            dataTransmitted = BIO_read( ssl_client_bio, buf, SERVER_BUFFER_SIZE );
            
            printf("recieved data: %s", buf);
            
            if ( buf[0] != (char)0xFF ) {
                dataTransmitted = BIO_write( ssl_client_bio, buf, strlen(buf));
                BIO_flush(ssl_client_bio);
            }
        } while ( (buf[0] != (char)0xFF) && (dataTransmitted > 0) );
        
        
        ssl_close_connection( clientSocket, ssl_connection, ssl_client_bio );
        
        close(clientSocket);
    }

    SSL_CTX_free(ssl_context);    
        
    return 0;
}
