#include <stdio.h>
#include <event2/event.h>
#include <event2/thread.h>
#include <event2/bufferevent_ssl.h>
#include <event2/dns.h>
#include <event2/buffer.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/tcp.h>
#include <unistd.h>
#include <netinet/in.h>
#include <openssl/ssl.h>

static int sock;
struct event_base *base;
struct bufferevent *bufferevent;
struct bufferevent *bufferevent_underlying;
struct evbuffer *input;
static int options = 0;
static char *host;
static unsigned short port;
static int err = 0;
static const char *errstr;
static SSL *ssl = NULL;
static SSL_CTX *ssl_ctx = NULL;
static int connected = 0;
static int failed;

static int _openssl_certificate_verifier_cert_callback(X509_STORE_CTX *ctx, void *p)
{
    fprintf(stdout, "Verify cert\n");
    return 1;
}

static int _init()
{
    int err = 0;

    // ssl init stuff

    SSL_library_init();
    SSL_load_error_strings();
    ERR_load_BIO_strings();
    OpenSSL_add_all_algorithms();

    event_enable_debug_logging(EVENT_DBG_ALL);

    err = evthread_use_pthreads();
    if (err) return err;

    if ((base = event_base_new()) == NULL)
        return -1;

    return 0;
}

static void _read_callback(struct bufferevent *bev, void *ctx)
{
    struct evbuffer *input = NULL;
    input = bufferevent_get_input(bufferevent);
    evbuffer_drain(input, evbuffer_get_length(input));
}

static void _event_callback(struct bufferevent *bev, short events, void *ctx)
{
    if (events & BEV_EVENT_ERROR)
    {
        err    = evutil_socket_geterror(bufferevent_getfd(bev));
        errstr = evutil_socket_error_to_string(err);
        fprintf(stdout, "_event_callback: BEV_EVENT_ERROR %s\n", errstr);
    }
    
    if (events & BEV_EVENT_CONNECTED)
    {
        fprintf(stdout, "_event_callback: BEV_EVENT_CONNECTED\n");
        connected = 1;
    }
    
    if (events & BEV_EVENT_EOF)
    {
        fprintf(stdout, "_event_callback: BEV_EVENT_EOF\n");
    }
    
    if (events & BEV_EVENT_TIMEOUT)
    {
        fprintf(stdout, "_event_callback: BEV_EVENT_TIMEOUT\n");
    }
}

static int _open()
{
    int options = 0;
    int descriptor = -1;
    int on = 0;

    fprintf(stdout, "Creating socket\n");

    sock =  socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sock < 0)
        return -1;

    if (evutil_make_socket_nonblocking(sock))
        return -1;

    on = 1;
    setsockopt(descriptor, IPPROTO_TCP, TCP_NODELAY, &on, sizeof(on));

    // setup ssl

    fprintf(stdout, "Creating SSL context\n");
    ssl_ctx = SSL_CTX_new(TLSv1_client_method());
    
    if (ssl_ctx == NULL)
    {
        return -1;
    }
    
    SSL_CTX_set_read_ahead(ssl_ctx, 0);
    
    SSL_CTX_set_cert_verify_callback(ssl_ctx, _openssl_certificate_verifier_cert_callback, NULL);

    ssl = SSL_new(ssl_ctx);

    if (ssl == NULL)
    {
        return -1;
    }

    // setup bufferevents

    fprintf(stdout, "Creating buffer events\n");

    bufferevent_underlying = bufferevent_socket_new(base, descriptor, options);
    if (bufferevent_underlying == NULL)
    {
        return -1;
    }
    
    bufferevent_set_timeouts(bufferevent_underlying, NULL, 0);

    if (bufferevent_socket_connect_hostname(bufferevent_underlying, NULL, AF_INET, host, port) < 0)
    {
        fprintf(stderr, "Failed bufferevent_socket_connect_hostname - %s\n", host);
        return -1;
    }

    // wrap with ssl filter
    bufferevent = bufferevent_openssl_filter_new(base, bufferevent_underlying, ssl, BUFFEREVENT_SSL_CONNECTING, options);

    if (bufferevent_enable(bufferevent, EV_READ|EV_WRITE) < 0)
    {
        fprintf(stderr, "Failed to enable bufferevent\n");
        return -1;
    }

    bufferevent_setcb(bufferevent, _read_callback, NULL, _event_callback, NULL);

    return 0;
}

static int _close()
{

    if (sock)
    {
        close(sock);
        sock = 0;
    }

    if (bufferevent)
    {
        bufferevent_free(bufferevent);
        bufferevent = NULL;
    }

    if (bufferevent_underlying)
    {
        bufferevent_free(bufferevent_underlying);
        bufferevent_underlying = NULL;
    }
    
    if (base)
    {
        event_base_free(base);
        base = NULL;
    }

    if (ssl_ctx)
    {
        SSL_CTX_free(ssl_ctx);
        ssl_ctx = NULL;
    }

    if (ssl)
    {
        SSL_free(ssl);
        ssl = NULL;
    }
    
    return 0;
}


int main(int argc, char** argv)
{
    int err = 0;

    host  = argv[1];

    fprintf(stdout, "host is %s\n", host);

    port  = atoi(argv[2]);
   
    fprintf(stdout, "port is %d\n", port);

    err = _init();
    if (err) goto ERR;

    err = _open();
    if (err) goto ERR;

    while (!connected)
    {
        event_base_loop(base, EVLOOP_ONCE);
    }

    fprintf(stdout, "connected OK\n");

    _close();

    return 0;

 ERR:
    fprintf(stderr, "evconnect failed.");
    return -1;
}
