import datetime

NUM_PROCESSES = 4

# "If the contained statistics end time is more than 1 week older than the
# descriptor publication time in the "published" line, skip this line..."
END_THRESHOLD = datetime.timedelta(days = 7)

# "Also skip statistics with an interval length other than 1 day."
# We set the threshold higher, because some descriptors have an interval a few
# seconds larger than 86400.
INTERVAL_THRESHOLD = datetime.timedelta(seconds = 90000)

def datetime_floor(d):
    return d.replace(hour = 0, minute = 0, second = 0, microsecond = 0)

TIMEDELTA_1DAY = datetime.timedelta(seconds = 86400)
def segment_datetime_interval(begin, end):
    cur = begin
    while cur < end:
        next = min(datetime_floor(cur + TIMEDELTA_1DAY), end)
        delta = next - cur
        yield (cur.date(), delta / (end - begin), delta / TIMEDELTA_1DAY)
        cur = next
