#!/usr/bin/env python3

import getopt
import sys

import numpy as np
import pandas as pd

if __name__ == "__main__":
    _, (relay_uptime_csv_filename, relay_dir_csv_filename) = getopt.gnu_getopt(sys.argv[1:], "")
    relay_uptime = pd.read_csv(relay_uptime_csv_filename)
    relay_dir = pd.read_csv(relay_dir_csv_filename)
    j = (
        relay_dir
            .groupby("date").apply(lambda g:
                pd.DataFrame({
                    "date": g["date"],
                    "h(H)": g["relay_dir_write_bytes"],
                    "n(H)": g["relay_dir_write_hours"],
                    "n(R\\H)": np.maximum(0, g["relay_dir_stats_hours"] - g["relay_dir_write_hours"]),
                })
            ).groupby("date").sum()
    )
    j["h(R∧H)"] = relay_dir.loc[relay_dir["relay_dir_write_hours"] > 0].groupby("date").apply(lambda g:
        np.minimum(g["relay_dir_write_hours"], g["relay_dir_stats_hours"]) * g["relay_dir_write_bytes"] / g["relay_dir_write_hours"]
    ).groupby("date").sum()
    j = pd.merge(j, relay_uptime.rename(columns = {"relay_uptime_hours": "n(N)"}), on = "date", how = "inner")
    j["frac"] = (j["h(R∧H)"] * j["n(H)"] + j["h(H)"] * j["n(R\\H)"]) / (j["h(H)"] * j["n(N)"])
    pd.options.display.width = 1000
    pd.options.display.max_columns = 1000
    pd.options.display.precision = 3
    print(j[[
        "date",
        "n(N)",
        "n(H)",
        "h(H)",
        "h(R∧H)",
        "n(R\H)",
        "frac",
    ]])
