//=============================================================================
// ppsSampleRaw
//-----------------------------------------------------------------------------
//
// A class to load and save raw samples.
//
// $Id: SampleRaw.cpp,v 1.1.1.1 1999/11/06 11:54:01 creinig Exp $
//
// $Log: SampleRaw.cpp,v $
// Revision 1.1.1.1  1999/11/06 11:54:01  creinig
// Back in CVS at last
//
//
//=============================================================================

#include <fstream>
#include <string>
#include <new>

#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/SampleRaw.h>

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

//============================================================================
/// constructor
//============================================================================
SampleRaw::SampleRaw()
{
}


//============================================================================
/// destructor
//============================================================================
SampleRaw::~SampleRaw()
{
    delete [] m_data0;
    m_data0 = 0;
    delete [] m_data1;
    m_data1 = 0;
}


//============================================================================
// SampleRaw::Load
//----------------------------------------------------------------------------
/// assume the sample is 8bit unsigned
///
/// we could change it so that it you have to set the type first and then
/// load the sample ?
//============================================================================
bool SampleRaw::Load(const char *filename)
{
  std::ifstream fin;

  try
    {
      fin.open(filename);

      if (!fin)
        ppThrow (EAccessFailure, "Error opening file");
      fin.seekg(0, std::ios::end);
      m_length = fin.tellg();

      fin.seekg(0, std::ios::beg);

      m_data0 = new unsigned char [m_length];
      if (m_data0==0)
        throw std::bad_alloc ();
      fin.read((char*)m_data0, m_length);

      fin.close();

      // default to 8bit, mono at 11024 with no looping
      Set8Bit();
      m_frequency  = 11024;
      m_loop_start = 0;
      m_loop_end   = 0;
      SetName(filename);
      return true;
    }
  catch (Exception &)
    {
      fin.close();
      return false;
    }
}



//============================================================================
// Sample::saveRAW
//----------------------------------------------------------------------------
/// Save the sample to file as a raw audio.
/// \param filename The naem of the file to save the sample to.
/// \param sample   The Sample to save.
//============================================================================
bool SampleRaw::Save(const char *filename, const Sample& sample) const
{
  std::ofstream fout;
  try
    {
      fout.open(filename);
      if (fout == 0)
        ppThrow (EAccessFailure, "Error opening file.");
      if (sample.GetLength() == 0)
        ppThrow (EInvalidParameter, "No Sample data to save");
      fout.write((const char*)sample.GetData(), sample.GetLength());
      fout.close();
      return true;
    }
  catch (Exception &message)
    {
      fout.close();
      throw message;
    }
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END
