/*
 * Generic simple preprocessor macros and definitions
 * #included by PenguinPlay.h - please do not include directly
 *
 *
 * Project : PenguinPlay
 * Part    : Generic
 * Authors : Christian Reiniger <warewolf@mayn.de>
 *           Adrian Ratnapala <raka@mailhost.bit.net.au>
 * License : See the accompanying file LICENSE
 *
 * Last change by $Author$
 * on             $Date$
 * to             $Revision$
 *
 */


#ifndef _PP_DEFINES_H
#define _PP_DEFINES_H


#include <limits.h> /* required for tests on existence of 64bit ints */


/*
 * ------------------------------------------------------------------- Generic
 */




/* Version of LibPenguinPlay.
 * The patchlevel is not defined here (FIX: is this bad?)
 * FIX: Change names to PP_VERSION_XXXX ?
 */
#define PENGUINPLAY_VERSION_MAJOR 0
#define PENGUINPLAY_VERSION_MINOR 0





/*
 * --------------------------------------------------------- System Properties
 */



/* POSIX support
 *
 * FIX: There has to be a better way to do this
 */

#ifdef HAVE_UNISTD_H
#  define PP_SYS_POSIX
/*#  include <unistd.h>*/
#else
#  undef PP_SYS_POSIX
/*#  error "POSIX functionality currently needed"*/
#endif





/* Processor architecture */

#if defined(__386__) || defined(i386)
#  define PP_SYS_ARCH_I386
#else
#  undef PP_SYS_ARCH_I386
#endif




/* Operating system */

#if defined(__unix__) || defined(unix)
#  define PP_SYS_OS_UNIX
#else
#  undef PP_SYS_OS_UNIX
#endif

#if defined(__linux__) || defined(linux)
#  define PP_SYS_OS_LINUX
#else
#  undef PP_SYS_OS_LINUX
#endif

#if defined (_WIN32) || defined(WIN32)
#  define PP_SYS_OS_WIN32
#else
#  undef PP_SYS_OS_WIN32
#endif





/*
 * Do 64 bit integers exist?
 * Thanks Yong Chi for the hack for detecting
 * 64 bit architectures.
 *
 * PP_SYS_64BIT_ARCH : Are we on a system with native 64bit integers?
 * PP_SYS_64BIT_INTS : Does the system support 64bit integers somehow?
 *
 * FIX: Will this work reliably? Perhaps using autoconf for it is better.
 */

#if INT_MAX < LONG_MAX
#  define PP_SYS_64BIT_ARCH
#  define PP_SYS_64BIT_INTS
#elif defined (__GNUC__)
#  define PP_SYS_64BIT_INTS
#elif defined (_MSC_VER)
#  define PP_SYS_64BIT_INTS
#endif






/*
 * --------------------------------------------------------------------- Other
 */




/* Programming language */

#if defined(__cplusplus) || defined(c_plusplus)
#  define PP_CPLUSPLUS
#  undef  PP_C
#else
#  define PP_C
#  undef  PP_CPLUSPLUS
#endif





/*
 * Language wrappers etc
 */

#ifdef PP_CPLUSPLUS
#  define PP_NAMESPACE_BEGIN namespace pp {
#  define PP_NAMESPACE_END   }
#  define PP_I_NAMESPACE_BEGIN namespace internal {
#  define PP_I_NAMESPACE_END   }
#  define PP_EXTC extern "C"
#else
#  define PP_NAMESPACE_BEGIN
#  define PP_NAMESPACE_END
#  define PP_I_NAMESPACE_BEGIN
#  define PP_I_NAMESPACE_END
#  define PP_EXTC extern
#endif




/* Win32 shared library hints */

#ifdef PP_SYS_OS_WIN32
#  define PP_EXPORT __declspec( dllexport )
#else
#  define PP_EXPORT
#endif




/* [en|dis]able some GCC specifics */
#ifdef __GNUC__

/* mark this function as having printf style varargs, GCC can typecheck */
#  define PP_PRINTF_STYLE(STR, FIRST) \
    __attribute__(( __format__( printf, STR, FIRST ) ))

#else  /* GNUC */
/* mark this function as having printf style varargs, GCC can typecheck
 * FIX: this should do *something* on other systems !! */
#  define PP_PRINTF_STYLE(STR, FIRST)

#endif /* GNUC */





/*
 * Handle alloca: this probably needs fixing when we port.
 *
 * FIX:  The autoconf docs have all sorts of complicated instructions
 * about how to use the "alloca" stuff.  Not doing that, its quite
 * silly.  Hopefully this will work.
 * Should we dump that? Is anyone using alloca anyway?
 */
#ifdef HAVE_ALLOCA
#  ifdef HAVE_ALLOCA_H
#    include <alloca.h>
#  endif /* HAVE_ALLOCA_H */
#  define PP_ALLOCA(TYPE, NUM) ( (TYPE*) alloca( sizeof(TYPE)*NUM ) )
#  define PP_DEALLOCA(PTR)
#else /* HAVE_ALLOCA */
#  ifdef PP_CPLUSPLUS
#    define PP_ALLOCA(TYPE, NUM) (new TYPE[NUM])
#    define PP_DEALLOCA(PTR) delete[](PTR)
#  else  /* PP_CPLUSPLUS */
#    include <memory.h>
#    define PP_ALLOCA(TYPE, NUM)  ( (TYPE*) malloc( sizeof(TYPE)*NUM ) )
#    define PP_DEALLOCA(PTR) free(PTR)
#  endif /* PP_CPLUSPLUS */
#endif /* HAVE_ALLOCA */






#endif /* Include guards */
