#!/usr/bin/env python
# To use:
#       python setup.py install
#
# Be sure to edit the Setup file to include the default
#       paths to the proper libraries and headers. get the
#       proper values into this block of metadata at the
#       top of the script. goodluck!
# 

PROJECT_NAME = 'heidigfx'
PROJECT_VERSION = '0.1 alpha'
PROJECT_URL = 'http://heidigfx.sourceforge.net'
MAINTAINER = 'Scott Russell'
MAINTAINER_EMAIL = 'queuetue@activestudios.com'
DESCRIPTION = '''2d Primitives library for pygame'''



import os.path, glob, sys
import distutils.sysconfig 
from distutils.core import setup, Extension
from distutils.extension import read_setup_file
from distutils.ccompiler import new_compiler


#get compile info for all extensions
try:
    extensions = read_setup_file('Setup')
except IOError:
    raise SystemExit, 'Need a "Setup" file for compiling.'



#try to find libaries and copy them
#(great for windows, bad for linux)
data_path = os.path.join(distutils.sysconfig.get_python_lib(), 'pygame')
data_files = []
if sys.platform == 'win32':
    tempcompiler = new_compiler()
    for e in extensions:
        paths = [os.path.join(d, \
                 tempcompiler.shared_lib_format%(l, \
                     tempcompiler.shared_lib_extension)) \
                 for d in e.library_dirs for l in e.libraries]
        for p in paths:
            if os.path.isfile(p) and p not in data_files:
                data_files.append(p)



setup (name = PROJECT_NAME,
       version = PROJECT_VERSION,
       maintainer = MAINTAINER,
       maintainer_email = MAINTAINER_EMAIL,
       description = DESCRIPTION,
       url = PROJECT_URL,
       packages = [''],
       package_dir = {'pygame': ''},
       extra_path = ('pygame/ignore', 'pygame'),
       ext_modules = extensions,
       data_files = [[data_path, data_files]]
     )
