/*
    pygame - Python Game Library
    Copyright (C) 2000-2001  Pete Shinners

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Pete Shinners
    pete@shinners.org
*/

void drawpixel(SDL_Surface *Surface, Uint32 pixel, int x, int y);
int clip_and_draw_line(SDL_Surface* surf, SDL_Rect* rect, Uint32 color, int* pts);
int clipline(int* pts, int left, int top, int right, int bottom);
void drawline(SDL_Surface* surf, Uint32 color, int startx, int starty, int endx, int endy);
void drawhorzline(SDL_Surface* surf, Uint32 color, int startx, int starty, int endx);
int drawvertline(SDL_Surface *Surface, Uint32 Color, Sint32 Y1, Sint32 Y2, Sint32 X);
int drawrectangle(SDL_Surface* surf, Uint32 forecolor, int startx, int starty, int endx, int endy);
int drawrectanglefilled(SDL_Surface* surf, Uint32 forecolor, Uint32 backcolor, int startx, int starty, int endx, int endy);
int drawellipse(SDL_Surface* surf, Uint32 forecolor, int startx, int starty, int xradius, int yradius);
int drawellipsefilled(SDL_Surface* surf, Uint32 forecolor, Uint32 backcolor, int startx, int starty, int xradius, int yradius);
int drawtriangle(SDL_Surface* surf, Uint32 forecolor, int x1, int y1, int x2, int y2, int x3, int y3);
int drawtrianglefilled(SDL_Surface* surf, Uint32 forecolor, Uint32 backcolor, int x1, int y1, int x2, int y2, int x3, int y3);
int drawpolygon (SDL_Surface *Surface, Uint32  Color, Sint32 Vertices, Sint32 *X, Sint32 *Y);
int drawpolygonfilled (SDL_Surface *Surface, Uint32 Foreground, Uint32 Background, Sint32 Vertices, Sint32 *X, Sint32 *Y);

#define SWAP(x,y,temp) temp=x;x=y;y=temp