import pygame
from pygame.locals import *
import time

def load_image(name, colorkey=None):
    try:
        image = pygame.image.load(name)
    except pygame.error, message:
        print 'Cannot load image:', name
        return None
    image = image.convert()
    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0,0))
        image.set_colorkey(colorkey, RLEACCEL)
    return image, image.get_rect()

def recentered(new, original):
    new_rect = new.get_rect()
    orig_rect = original.get_rect()
    xoffset = new_rect[2]*.5-orig_rect[2]*.5
    yoffset = new_rect[3]*.5-orig_rect[3]*.5
    cropped_rect = new.subsurface((xoffset, yoffset, orig_rect[2], orig_rect[3]))
    return cropped_rect

class orologio:
    def __init__(self, clock_display):
        
        """ Prototype: orologio(surface, path_to_secs_point_image, path_to_mins_point, path_to_hours_point, path_to_blanker)
            This class initializes taking a surfare to which the clock should be rendered and 4 images
            3 pointers and a blanker to make the background refresh after every tick

            At this point it gets the time values and make the first rotation of all the pointers
            till their right position in the display. The only need for this class is to use 4 paths to
            transparent png images to make the pointers and the blanker. This images must have the same width and the
            same height of the surface to which they should be blitted"""
        
        self.clock_display = clock_display
        
        self.secs_point, self.secs_rect = load_image('secspoint.png',-1)
        self.mins_point, self.mins_rect = load_image('minspoint.png',-1)
        self.hours_point, self.hours_rect = load_image('hourspoint.png',-1)
        self.blanker, self.blank_rect = load_image('blanker.png')
        
        self.hours = time.localtime()[3]
        self.mins = time.localtime()[4]
        self.seconds = time.localtime()[5]
        
        self.secs_image = pygame.transform.rotate(self.secs_point, -6*self.seconds)
        self.mins_image = pygame.transform.rotate(self.mins_point, -6*self.mins)
        self.hours_image = pygame.transform.rotate(self.hours_point, -30*self.hours)

        self.clock_display.blit(self.blanker, self.blank_rect)
        self.clock_display.blit(self.secs_point, self.secs_rect)
        self.clock_display.blit(self.mins_point, self.mins_rect)
        self.clock_display.blit(self.hours_point, self.hours_rect)



    def update(self):
        hours_modder = 0.25    # This is needed to make the hours' pointer move with more smoothness between each hour
        self.secs_degrees = -6*time.localtime()[5]
        self.mins_degrees = -6*time.localtime()[4]
        self.hours_degrees = -(30*(time.localtime()[3])+(time.localtime()[4]*hours_modder))
       
        self.secs_image = pygame.transform.rotate(self.secs_point, self.secs_degrees)
        self.mins_image = pygame.transform.rotate(self.mins_point, self.mins_degrees)
        self.hours_image = pygame.transform.rotate(self.hours_point, self.hours_degrees)
        
        self.secs_rect = self.secs_image.get_rect()
        self.mins_rect = self.mins_image.get_rect()
        self.hours_rect = self.hours_image.get_rect()
        
        self.secs_image = recentered(self.secs_image, self.secs_point)
        self.mins_image = recentered(self.mins_image, self.mins_point)
        self.hours_image = recentered(self.hours_image, self.hours_point)

        self.clock_display.blit(self.blanker, self.blank_rect)
        self.clock_display.blit(self.secs_image, self.secs_rect)
        self.clock_display.blit(self.mins_image, self.mins_rect)
        self.clock_display.blit(self.hours_image, self.hours_rect)
        
        pygame.display.flip()

if __name__=='__main__':
    pygame.init()
    clock_display = pygame.display.set_mode((256,256))
    clock = orologio(clock_display)
    quit = None
    while not quit:
        clock.update()
        for event in pygame.event.get():
            if event.type == KEYDOWN:               
                print "posting quit"
                pygame.event.post(pygame.event.Event(QUIT))
                quit = 1
        pygame.time.wait(1000)                                          
        
