import eventnet.driver
import events

import pygame

pygame.init()
pygame.display.set_mode((320,240))
pygame.event.set_blocked(events.MOUSEMOTION)

@eventnet.driver.handle(events.QUIT)
def quit(e):
    """Receives quit event"""
    raise SystemExit

@eventnet.driver.handle(events.MOUSEBUTTONDOWN)
def MBD(e):
    """Registered first, and will modify event"""
    print e.pos
    e.pos = e.pos[0]+10, e.pos[1]+10

@eventnet.driver.handle(events.MOUSEBUTTONDOWN)
def MBD_2(e):
    """Registered second, will recieve a modified event"""
    print e.pos

if __name__ == "__main__":
    while True:
        eventq = pygame.event.get()
        for event in eventq:
            eventnet.driver.post(event.type, **event.dict)
        


