##	jakelib.game
##	Copyright (c) 2008-2008 Jake Bolton
##
##	( license not decided yet, so not sharable to anyone )
"""Testing module: This module contains a basic game rendering classes. It is 
only used to make easier tests when pygame is required. Not actually for games"""
test_game_ver = '0.0.2'

# required
try:
	import pygame
	from pygame.locals import *
except ImportError, err:	
	print "Couldn't load module. %s" % (err)
	sys.exit(2)	
# optionals
# try:
	# from states import StateBase
# except ImportError, err:	
	# print "Couldn't load module. %s. StateGame() may not work!" % (err)

class TestGame():
	"""Handles game init, updating etc... All you have to do is set your own
	two functions for additional init, and additional drawing. Note: You have
	to set two variables:
	
		.func_init = (required)set to your init function
		.func_draw = (required)set to your draw function
		.func_events = (optional)event handler. has argument: event
		
	your function sig should be:
		def my_init(self):
			# .. init code ..
			self.foo = bar
		
	"""
	def __init__(self, func_init, func_draw, func_event, caption="TestGame default title",
		w=800,h=600):
		"""Need to set:
			.func_init = set to your init function
			.func_draw = set to your draw function"""
		self.bDone=False
		self.color_bg = (255,255,255)
		
		pygame.init()
		self.width, self.height = w, h
		self.screen = pygame.display.set_mode( (w,h) )
		pygame.display.set_caption( caption)
		
		self.func_draw = func_draw
		self.func_event = func_event
		func_init(self) # don't have to save
	
	def main_loop(self):
		while not self.bDone:
			self.handle_events()
			self.draw()
		
	def handle_events(self):
		for event in pygame.event.get():
			self.func_event(self, event)
			if event.type == pygame.QUIT: self.bDone = True
			elif event.type == KEYDOWN and event.key == K_ESCAPE: self.bDone=True
				
	def draw(self):
		self.screen.fill( pygame.color.Color("gray") )
		self.func_draw(self)
		pygame.display.flip()
		

class TestGameOpenGL():
	"""todo"""
	pass
class StateTestGameOpenGL():
	"""todo"""
	pass
		
class StateTestGame():
	"""A TestGame() modified to use with state based game flow"""
	"""Game object. rendering, globals etc... Used by StateManager()"""
	def __init__(self, caption, width=800, height=600):
		"""Initialize PyGame"""		
		pygame.init()
		self.width, self.height = width, height
		# if ! log:
			# log = LoggerXML("StateTestGame.xml", "StateGameTest")
		# self.log = log
		
		self.screen = pygame.display.set_mode(( self.width, self.height ))
		pygame.display.set_caption( caption )
		self.clock = pygame.time.Clock()
		# fps: self.fps = FPSText(self)		
		self.bLimitFPS = True
		self.fps_limit = 60
		
	def update(self):
		"""updates that happen in all states; almost nothing"""		
		if self.bLimitFPS: self.clock.tick( self.fps_limit )
		else: self.clock.tick()
			
if __name__ == "__main__":
	# print "see: ./test_text.py"
	from test_game import *
	test()