import midiport
import pygame
from pygame.locals import *

def main():
    pygame.init()
    midiport.initialize()
    try:
        midi_out = midiport.Output(0, 0)
        midi_out.set_instrument(midiport.CHURCH_ORGAN)
        screen = pygame.display.set_mode((200, 200))
        screen.fill((0, 0, 255))
        pygame.display.flip()

        regions = pygame.Surface((200, 200), 0, 24)
        regions.fill((60, 127, 0), (0, 0, 50, 200))
        regions.fill((61, 127, 0), (50, 0, 50, 200))
        regions.fill((62, 127, 0), (100, 0, 50, 200))
        regions.fill((63, 127, 0), (150, 0, 50, 200))

        key_mapping = {pygame.K_q: (60, 127),
                       pygame.K_w: (61, 127),
                       pygame.K_e: (62, 127),
                       pygame.K_r: (63, 127)}

        pygame.event.set_blocked(MOUSEMOTION)
        repeat = 1
        mouse_note = 0
        while repeat:
            for e in pygame.event.get():
                if e.type == pygame.MOUSEBUTTONDOWN:
                    mouse_note, velocity, __, __ = regions.get_at(e.pos)
                    midi_out.note_on(mouse_note, velocity)
                elif e.type == pygame.MOUSEBUTTONUP:
                    midi_out.note_off(mouse_note)
                elif e.type == pygame.QUIT:
                    repeat = 0
                    break
                elif e.type == pygame.KEYDOWN:
                    if e.key == pygame.K_ESCAPE:
                        repeat = 0
                        break
                    try:
                        note, velocity = key_mapping[e.key]
                    except KeyError:
                        pass
                    else:
                        midi_out.note_on(note, velocity)
                elif e.type == pygame.KEYUP:
                    try:
                        note, __ = key_mapping[e.key]
                    except KeyError:
                        pass
                    else:
                        midi_out.note_off(note, 0)
    
            pygame.display.flip()
    finally:
        del midi_out
        midiport.terminate()

if __name__ == '__main__':
    main()
