#!/usr/bin/python
"""
mpegPyCrust based on...

Module  : simplePyCrust.py
Version : 1.0
Author  : Patrick K O'Brien <pobrein@orbtech.com>
Date    : 22nd December, 2002
Purpose : Really simple example of how to embed PyCrust in a wxPython application.
"""

import os

from wxPython import wx
assert wx.wxc.__version__ >= "2.4"

from wxPython.lib import dialogs
from wxPython.lib.PyCrust import shell
from wxPython.lib.PyCrust.crust import CrustFrame

import pygame,pygame.movie
import pprint

# I got the mp3 module at:
# http://www.dotfunk.com/projects/mp3
import mp3
# fileinfo is from http://diveintopython.org/
import fileinfo

def printMP3Info(filename):
    info = fileinfo.MP3FileInfo(filename)
    print "\\n".join(["%s=%s" % (k, v) for k, v in info.items()])
    
    info = mp3.mp3info(filename)
    pprint.pprint(info)


class myFrame(wx.wxFrame):
    def __init__(self, parent, ID, title, pos, size, parentApp):
        wx.wxFrame.__init__(self, parent, ID, title, pos, size)
        
        self.panel = wx.wxPanel(self, -1)

        if 0:
            # A text field
            self.textFld = wx.wxTextCtrl(self.panel, -1, size=(490,200), style=wx.wxTE_MULTILINE)
            
            # A slider
            self.slider = wx.wxSlider(self.panel, -1, 0, 0, 100, point=(10,250), 
                                      size=(100, -1), 
                                      style= wx.wxSL_HORIZONTAL | wx.wxSL_AUTOTICKS | wx.wxSL_LABELS)
            self.slider.SetTickFreq(5, 1)

        
        self.textFld = wx.wxTextCtrl(self.panel, -1, pos=(5,350), size=(200, -1))

        self.btnFile = wx.wxButton(self.panel, -1, "File...", pos=(210,350))
        wx.EVT_BUTTON(self.panel, self.btnFile.GetId(), self.on_btnFile_mouseClick)

        self.btnPlay = wx.wxButton(self.panel, -1, "Play", pos=(300,350))
        wx.EVT_BUTTON(self.panel, self.btnPlay.GetId(), self.on_btnPlay_mouseClick)

        self.btnStop = wx.wxButton(self.panel, -1, "Stop", pos=(400,350))
        wx.EVT_BUTTON(self.panel, self.btnStop.GetId(), self.on_btnStop_mouseClick)

        if 0:
            # Add in the crust, if needed
            self.crustFrame = CrustFrame()
            self.crustFrame.SetSize((700, 500))
            self.crustFrame.Show(wx.TRUE)
            self.crustFrame.shell.interp.locals['pcapp'] = parentApp
            wx.EVT_CLOSE(self.crustFrame, self.onCloseCrustFrame)

        self.movie = None
        self.hwnd = None

    def onCloseCrustFrame(self, event):
        self.crustFrame.Show(False)

    def on_btnFile_mouseClick(self, event):
        # could specify a wildcard here to make sure we
        # only get an MP3 or MPEG
        result = dialogs.openFileDialog(self)
        if result.accepted:
            filename = result.paths[0]
            self.textFld.SetValue(filename)
            printMP3Info(filename)

    def on_btnPlay_mouseClick(self, event):
        filename = self.textFld.GetValue()
        if filename:
            self.play(filename)

    def on_btnStop_mouseClick(self, event):
        self.stop()

    def play(self, filename):
        if not filename.lower().endswith('.mp3') and self.hwnd is None:
            # we have an MPEG movie, but only init once
            # use the panel for playback for now
            # for something real we would want to use a window
            # inside the panel and adjust the overall frame size
            # based on the movie rect
            self.hwnd = self.panel.GetHandle()
            #filename = r'c:\downloads\bio0_320f\bio0_320f.mpg'
            os.environ['SDL_WINDOWID'] = str(self.hwnd) #must be before init
            pygame.display.init()
            display = pygame.display.set_mode((10,10)) #size no matter

        self.movie = pygame.movie.Movie(filename)
        self.movie.play()

    def stop(self):
        if self.movie:
            self.movie.stop()
            self.movie = None

class myApp(wx.wxApp):
    def OnInit(self):
        wx.wxInitAllImageHandlers()
        self.frame = myFrame(None, -1, "MPEG Player with PyCrust", (20, 20), (600, 400), self)
        self.frame.Show(wx.TRUE)
        self.SetTopWindow(self.frame)
        return wx.TRUE

if __name__ == "__main__":
    app = myApp(0)
    app.MainLoop()
