#!/usr/bin/env python
# pygame + PyOpenGL version of Nehe's OpenGL lesson02
# Paul Furber 2001 - m@verick.co.za

import os
import sys

from OpenGL.GL import *
from OpenGL.GLU import *

#from psyco.classes import *

import pygame
import string
from pygame.locals import *
from pygame.font import *
import profile
import Numeric as N
import time
import profile
from random import Random


VERSION = 0.1

class obj:
    
    def __init__(self):
	self.__vertex_count = 0
	self.__vertex_array = []
	self.__next_vertex = 0

	self.__rotate = 0
	self.set_pos(0.0,0.0,-5.0)
	
    class __vertex:

	x = 0.0;
	y = 0.0;
	z = 0.0;
	
	def get(self):
	    return [self.x,self.y,self.z]
	def set(self,x,y="x",z=-1):
	    if (y == "x"):
		self.x,self.y,self.z = x
	    else:
		self.x = x;self.y = y;self.z = z


    
    def load(self,filename=-1):
	split = string.split
	if (filename !=-1):
	    fd = open(filename,"r")
	    tmp = split(fd.read(),"\n")
	    fd.close()
	    for line in tmp:
		va = []
		vertex = self.__vertex()
		line = string.splitfields(line)
		if (len(line) == 3):
		    va.append(float(line[0]))
		    va.append(float(line[1]))
		    va.append(float(line[2]))
		    vertex.set(va)
		self.__vertex_array.append(vertex)
    	    self.__vertex_count = len(self.__vertex_array)
		
	else:
	    return filename
    
    def get_count(self):
	return self.__vertex_count

    def add_vertex(self,x,y=-1,z=-1):
	vertex = self.__vertex()

	if (y ==-1):
	    vertex.set(x)
	else:
	    vertex.set(x,y,z)

        self.__vertex_count = len(self.__vertex_array)
	self.__vertex_array.append(vertex)

    def set_vertex(self,vertex,x,y,z):
	self.__vertex_array[vertex].set(x,y,z)

    def get_vertex(self,vertex):
	return self.__vertex_array[vertex].get()
		
    def get_next_vertex(self):
	if (self.__next_vertex < self.__vertex_count):
	    tmp = self.__next_vertex;self.__next_vertex+=1
	    return self.__vertex_array[tmp].get()
#	elif (self.__vertex_count > 0):
#	    self.__next_vertex =1
#	    return self.__vertex_array[0]
	else:
	    self.__next_vertex = 0
#	    return self.__vertex_array[self.__next_vertex].get()
	    return -1
    def set_pos(self,x,y,z):
        self.pos_x = x ; self.pos_y = y ; self.pos_z = z

    def rotate(self,x,y,z):
	if ( max(x,y,z) > 0):
	    self.__rotate = 1
	    self.rotate_x = x
	    self.rotate_y = y
	    self.rotate_z = z
	else:
	    self.__rotate = 0

    def __rotatefunc(self):
	if (self.__rotate==1):
	    if (self.rotate_z >0):
		glRotate(self.rotate_z,0.0,0.0,1.0)
	    if (self.rotate_x >0):
		glRotate(self.rotate_x,1.0,0.0,0.0)
	    if (self.rotate_y >0):
		glRotate(self.rotate_y,0.0,1.0,0.0)
	
    def __posfunc(self):
	glTranslatef(self.pos_x,self.pos_y,self.pos_z)

    def morph(self,tmp,step):
	
	cur,steps = step
	steps = float(steps)
	
	if (cur == -1):
	    cur = 1.0
	    steps = float(steps)

	glLoadIdentity()
	self.__posfunc()
	self.__rotatefunc()
	
	glBegin(GL_POINTS)
	i = 0
	for vertex in self.__vertex_array:
	    x,y,z = vertex.get()
	    tx,ty,tz = tmp.get_vertex(tmp.get_count()-i-1)
	    mx = (tx + x) / (steps - cur)
	    my = (ty + y) / (steps - cur)
	    mz = (tz + z) / (steps - cur)
	    self.set_vertex(i,x-mx,y-my,z-mz)
	    cx = x;cy=y;cz=z
	    if (cx<0.0):
		cx=cx*-1
	    if (cy<0.0):
		cy=cy*-1
	    if (cz<0.0):
		cz=cz*-1

	    glColor3f(cx,cy,cz)
	    glVertex3f(x-mx,y-my,z-mz)
	    i+=1
	glEnd()
	
	
	cur+=1.0
	if (cur>=steps):
	    cur = -1
	return [cur,steps]

    def draw_points(self):
	
	glLoadIdentity()
	self.__posfunc()
	self.__rotatefunc()
	
	glBegin(GL_POINTS)
	for vertex in self.__vertex_array:
	    x,y,z = vertex.get()
	    cx = x;cy=y;cz=z
	    if (cx<0.0):
		cx=cx*-1
	    if (cy<0.0):
		cy=cy*-1
	    if (cz<0.0):
		cz=cz*-1

	    glColor3f(cx,cy,cz)

	    glVertex3f(x,y,z)
	glEnd()


    def draw_lines(self):

	glLoadIdentity()
	self.__rotatefunc()
	self.__posfunc()
	glBegin(GL_LINE_STRIP)
	for vertex in self.__vertex_array:
	    x,y,z = vertex.get()
	    glVertex3f(x,y,z)
	glEnd()


#    create some objects


    def rand(self,vertexes,scale=1.0):
	g = Random()
	g.seed(time.time()+vertexes)
	i=0;ii=vertexes
	
	scale_m = scale * -1.0
	while(i<ii):
	    va = []
	    vertex = self.__vertex()
	    va.append(g.uniform(scale_m,scale))    
	    va.append(g.uniform(scale_m,scale))    
	    va.append(g.uniform(scale_m,scale))    
	    vertex.set(va)
	    self.__vertex_array.append(vertex)
	    i+=1
    	self.__vertex_count = len(self.__vertex_array)

    def line(self,vertexes,step=0.2):
	step = 0.01
	i=0;ii=vertexes
	xscale = float(vertexes)*float(step)*-1.0
	yscale = float(vertexes)*float(step)
	zscale = float(vertexes)*float(step)*-0.5
	
	
	while(i<ii):
	    va = []
	    vertex = self.__vertex()
	    va.append(xscale)    
	    va.append(yscale)    
	    va.append(zscale)    
	    vertex.set(va)
	    xscale+=step
	    yscale+=step
	    zscale-=step
	    
	    self.__vertex_array.append(vertex)
	    i+=1
    	self.__vertex_count = len(self.__vertex_array)

    def quad(self,vertexes,step=0.01):
	step = 0.05
	line = vertexes*step
	one_line = line / 4
	step_per_line = vertexes/4
	x = []; y = [] ; z = []
	print line,one_line,step_per_line

	i=0
	while(i<step_per_line):
	    x.append(one_line-(step*i));   y.append(0.0-step*i);   z.append(one_line);	i+=1
	
	i=0
	while(i<step_per_line):
	    x.append(0.0);   y.append(0.0+step*i);   z.append(one_line-(step*i));	i+=1

	i=0
	while(i<step_per_line):
	    x.append(step*i);   y.append(0.0-step*i);   z.append(0.0);	i+=1

	i=0
	while(i<step_per_line):
	    x.append(one_line);   y.append(0.0+step*i);   z.append(step*i);	i+=1

	i=len(x)-1
	while(i<vertexes+4):
	    x.append(one_line);y.append(0.0);z.append(one_line)
	    i+=1

		
	i=0;ii = vertexes
	while(i<ii):
	    va = []
	    vertex = self.__vertex()
	    va.append(x[i])    
	    va.append(y[i])    
	    va.append(z[i])    
	    vertex.set(va)
	    
	    self.__vertex_array.append(vertex)
	    i+=1
    	self.__vertex_count = len(self.__vertex_array)


screenx = 800
screeny = 600

classes = []
tmp = obj();tmp.rand(487,20.0);tmp.set_pos(0.0,0.0,-20.0); print "Rand: ",tmp.get_count();classes.append(tmp)
tmp = obj();tmp.load("Data/Tube.txt");tmp.set_pos(0.0,0.0,-20.0); print "Tube: ",tmp.get_count();classes.append(tmp)
tmp = obj();tmp.line(487,0.1);tmp.set_pos(0.0,0.0,-20.0); print "Line: ",tmp.get_count();classes.append(tmp)
tmp = obj();tmp.load("Data/Torus.txt");tmp.set_pos(0.0,0.0,-20.0); print "Torus: ",tmp.get_count();classes.append(tmp)
tmp = obj();tmp.quad(487,0.05);tmp.set_pos(0.0,0.0,-30.0); print "Quad: ",tmp.get_count();classes.append(tmp)
tmp = obj();tmp.load("Data/Sphere.txt");tmp.set_pos(0.0,0.0,-20.0); print "sphere: ",tmp.get_count();classes.append(tmp)
tmp = obj();tmp.rand(487,40.0);tmp.set_pos(0.0,0.0,-20.0); print "Rand: ",tmp.get_count();classes.append(tmp)


class anime:

    def __init__(self):
	pass

    def resize(self,(width, height)):
	if height==0:
    	    height=1

	glViewport(0, 0, width, height)
	glMatrixMode(GL_PROJECTION)

        glLoadIdentity()
	gluPerspective(45, 1.0*width/height, 0.5, 150.0)
        glMatrixMode(GL_MODELVIEW)
	glLoadIdentity()

    def init(self):

	glShadeModel(GL_SMOOTH)
	glClearColor(0.0, 0.0, 0.0, 0.5)
	glClearDepth(1.0)
	glEnable(GL_DEPTH_TEST)
        glDepthFunc(GL_LEQUAL)
        glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
        glBlendFunc(GL_SRC_ALPHA,GL_ONE)
	glEnable(GL_TEXTURE_2D)
#	glLineWidth(2)
#	glEnable(GL_LINE_SMOOTH)
#	glLineStipple(1,2)
	self.rot = 0	
	self.morph = [-1,400]
	
    def desktop(self):
    
	self.rot+=1
#	if (self.rot >=360): 
#	    self.rot=0
	
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
	glLoadIdentity()
#	sphere.rotate(self.rot,self.rot,self.rot*-1)
#	sphere.draw_points()

#	tube.rotate(self.rot,self.rot,self.rot)
#	tube.draw_points()

#	torus.draw_points()
#	tube.draw_points()

	self.helper.rotate(self.rot*0.1,self.rot*0.3,self.rot*0.4)
#	self.helper.draw_points()
	if (self.do_morph == 1):
	    self.morph = self.helper.morph(self.helper2,self.morph)	
	    if (self.morph[0] == -1):
		self.do_morph=0
#		self.helper = self.helper2
	else:
	    self.helper.draw_points()


					
    def main(self):

        video_flags = OPENGL|DOUBLEBUF|RLEACCEL|HWACCEL
    
        pygame.init()
        pygame.display.set_mode((screenx,screeny), video_flags)
        pygame.mouse.set_visible(0)
        self.resize((screenx,screeny))
        self.init()
    
        frames = 0
        ticks = pygame.time.get_ticks()
	self.helper = classes[0]
	self.helper2 = classes[1]
	self.classes = 2

	self.do_morph=0


        while 1:

    	    event = pygame.event.poll()
    	    if event.type == QUIT or (event.type == KEYDOWN and event.key == K_ESCAPE):
        	break
	    elif (event.type == KEYDOWN and event.key == K_TAB):
		pygame.display.toggle_fullscreen()        
	    elif (event.type == KEYDOWN and event.key == K_SPACE):
		if (self.morph[0] == -1 ):
		    self.morph = [-1,400]
		    self.do_morph = 1
		    print self.classes
		    self.helper2 = classes[self.classes]
		    self.classes+=1
		    if (self.classes >=len(classes)):
			self.classes=1
		
	    keystate = pygame.key.get_pressed()
	    self.desktop()
	    pygame.display.flip()
	    frames = frames + 1
#	    time.sleep(.003)

	print "fps:  %d" % ((frames*1000)/(pygame.time.get_ticks()-ticks))

anime = anime()

profile.run('anime.main()')

