#!/usr/bin/env python

########################################
# THE IMPORTANT PIECES IN THE CODE ARE #
#  MARKED BELOW WITH THESE BIG BOXES!  #
########################################

import pygame
from pygame import *

from random import randint

from pointer import *

def random_color():
    return (randint(100,255), randint(100, 255), randint(100, 255))

##################################################
# It is up to the programmer to draw the cursor. #
# I'd rather be using images...                  #
##################################################
def draw_cursor(pos, color):
    draw.circle(display.get_surface(), color, pos, 10)

#############################################
# You need to initiate the joysticks before #
# setting up joystick pointers.             #
#############################################
joysticks = []

def joystick_init():
    global joysticks        
    for x in xrange(0, joystick.get_count()):
        j = joystick.Joystick(x)
        j.init()
        joysticks.append(j)

#######################################
# And here is how to set up pointers. #
#######################################
pointers = []
pointer_colors = {}

def define_pointers():
    global joysticks, pointers

    ###############################
    # Setting up a mouse pointer. #
    ###############################
    pointers.append(MousePointer("mouse")) #A pointer device needs to be named.
    pointer_colors["mouse"] = random_color()

    ##################################
    # Setting up a joystick pointer. #
    ##################################
    for j in joysticks:
        pointer_name = "joystick" + str(j.get_id())  #Give each joystick pointer a different name.
        j_pointer = JoystickPointer(pointer_name, j) #A joystick pointer must receive the joystick object it refers to so it can process (and generate) events correctly.
        pointers.append(j_pointer)
        pointer_colors[pointer_name] = random_color()

###################

pygame.init()
display.set_mode((600,400))
mouse.set_visible(False)

########
# INIT #
########
joystick_init()
define_pointers()

while True:
    if event.get(QUIT):
        break

    event.clear([ACTIVEEVENT, MOUSEMOTION, KEYUP, KEYDOWN, MOUSEBUTTONUP,
                 JOYAXISMOTION, JOYBALLMOTION, JOYHATMOTION, JOYBUTTONUP,
                 VIDEORESIZE, VIDEOEXPOSE])

    display.get_surface().fill((0,0,0))

    ######################################################################
    # Pointers need either MOUSEBUTTONDOWN or JOYBUTTONDOWN events, it's #
    # easier to give both so you can forget about which pointer you are  #
    # talking about.                                                     #
    # You must update the pointers at every frame* so that the joystick  #
    # pointers may have their position displayed correctly and they can  #
    # generate clicks.                                                   #
    ######################################################################
    events = event.get([MOUSEBUTTONDOWN, JOYBUTTONDOWN])
    for pointer in pointers:
        pointer.update(events)

    ##############################################################
    # Also, remember to draw the pointer cursors at every frame. #
    ##############################################################
    for pointer in pointers:
        pointer_position = pointer.get_pos()
        pointer_color    = pointer_colors[pointer.name]
        draw_cursor(pointer_position, pointer_color)

    #################################################################
    # And here's me getting clicks and printing them on the screen. #
    #################################################################
    events = event.get(POINTER_CLICK)
    for e in events:
        print e

    display.update()
    time.wait(20)

