##	jakelib.text
##	Copyright (c) 2008-2009 Jake Bolton ( cpp.monkey@gmail.com )
##
##	( license not decided yet, so not sharable to anyone )
"""This module contains wrapper classes to aid in rendering pygame text

	-better color support ( get details on newer pygame Color() class )
		-make it so can pass (255,255,255) OR 'white' as color args
		-maybe new Color() can use both as constructor?
		
	-add bold, italic, underline
	.align and .align_box:
		-rewrite horizontal to use: font.get_linesize
		
	-TextMultiLine do not use height !
		use: .get_linesize() for height, not heigt !!!
	Todo: pygame.font.SysFont() support
	Todo: do text that can have multiple colors. ( Right now i can only have
		multiple if i want a single one per line on TextMultiLine() )
	todo: use Font.size(text) : return (w,h) for use of multi line
"""
text_ver = '0.0.6'
try:
	import pygame
	from pygame.locals import *
	import os
	pygame.font.init() # must be init, safe to call multiple times
except ImportError, err:	
	print "Couldn't load module. %s" % (err)
	sys.exit(2)	
if not pygame.font: print "Warning, fonts disabled!"
	


def hastext( search, text ):
	"""does this string contain another?"""
	if search.find( text.lower() ) == -1: return False
	return True

class Text(object):
	"""Used to render a single line of text. Only re-renders if text needs to
	be.
	
	members/property()ies:
		.color = pygame foreground text color
		.color_bg = background color. Set to None for transparency
		.font = pygame.Font()
		.font_size =
		.font_name = 
		.text = text to blit
		.antialias = True|False
		.rect = pygame.Rect() or tuple (x,y) of topleft to blit
		
	Pygame documentation:
		Optimization: if you know that the final destination for the text (on the 
		screen) will always have a solid background, and the text is antialiased, you 
		can improve performance by specifying the background color. This will cause 
		the resulting image to maintain transparency information by colorkey rather 
		than (much less efficient) alpha values.			
	"""
	# just created these, re-set in init()
	_font_size = None
	_font = None
	_color = None
	_color_bg = None
	_text = ""
	_antialias = True
	_underline = False
	
	def __init__(self, text=None, font=None, size=18,color="black", bold=False, italic=False):
		"""font can be:
			1) filepath:
				"ttf/arial.ttf"
			2) list of names to search: ( calls self.match_font(list) )
				"arial, verdana, freesans"
			3) None
				use default font
		"""
		self.screen = pygame.display.get_surface()
		self.font_name = font
		self.font_size = size				
		
		self.color = pygame.color.Color( color )
		self.text = text
		self.antialias = True		
		self.color_bg = None
		self.rect = pygame.Rect(15,15,0,0)
		self.bDirty = True # should already be set by property()ies 

		self.match_font('bitstreamverasans, verdana, arial,lucidia console')		
		self._create_font()
		
	def match_font(self, font_list, bold=False, italic=False):
		"""pygame.font.match_font() wrapper, but also sets the font. You can
		call with a commma deliminated list. It chooses the first valid font."""
		filename = pygame.font.match_font(font_list, bold, italic)				
		if not filename: # if failed, fallback on one that works
			filename = pygame.font.match_font('bitstreamverasans, verdana, arial,lucidia console,freesans, freesansbold') # should at least have freesans[bold] since it comes with pygame
		if( filename ):
			self.font_name = filename #was: font_list
			self._create_font()
		
	def align_box(self, align, box, offset=None):
		if not offset: offset = (0,0)
		x,y = self.font.size( self.text )
		"""Not yet implemented.
		
		Acts like Text.align() , except takes a Rect() as an argument, so you can
		define a rect other than the screen."""
	
	def align(self, align, width, height, offset=None):
		"""align text.
		
		Valid values = 	'topright', 'topleft', 'bottomright', 'bottomleft', 'center',
						'middleleft', 'middleright', 'topmiddle', 'bottommiddle'
						
		offset will offset that value,(ie: for margins relative topleft )
		
		( Note:! you can do 'topright' OR 'rightop', order of words doesn't matter. )
		"""
		if not offset: offset = (0,0)
		x,y = self.font.size( self.text )
		r = Rect(0,0,0,0)
		
		if hastext(align, 'top'):
			r.top = 0
		if hastext(align, 'bottom'):
			r.top = height-y
		if hastext(align, 'left'):
			r.left = 0
		if hastext(align, 'right'):
			r.left = width-x
		if hastext(align, 'middle'):
			# default to center, then modify other coord
			r.left = width/2-x/2
			r.top = height/2-y/2
			# x or y?
			if hastext(align, 'left'):
				r.left = 0	
			if hastext(align, 'right'):
				r.left = width-x
			if hastext(align, 'top'):
				r.top = 0
			if hastext(align, 'bottom'):
				r.top = height-y
		if hastext(align, 'center'):
			# r = Rect( width/2-x/2, height/2-y/2,0,0 )
			r.left = width/2-x/2
			r.top = height/2-y/2
			
		r.left += offset[0]
		r.top += offset[1]
		self.rect = r
	
	def draw(self):
		"""blit text. re-render only if needed."""
		self._render()
		self.screen.blit( self.image, self._rect )
	
	# def underline(self, bool=False):
		# self._underline = bool
		# self.font.set_underline( self._underline )
		# self._create_font()
	
	def _create_font(self, font=None):
		"""create Font() object"""
		try:
			self.font = pygame.font.Font( self.font_name, self.font_size )
		except IOError:
			if font:
				self.match_font(font) #, bold, italic)
			# self.font = pygame.font.Font( self.font_name, self.font_size )		
		# if ttf, try using it, otherwise try finding using match_font
		# if ttf:
			# if ttf.find(".ttf") == -1:
				# self.match_font(ttf, bold, italic)
			# else:
				# print "no, ttf=",ttf
	
	def _render(self):
		"""re-render when needed"""
		if self.bDirty == False: return
		self.bDirty = False
		# print '_render(dirty)' #d:
		if self.color_bg:
			self.image = self.font.render( self.text, self.antialias, self.color, self.color_bg)
		else:
			self.image = self.font.render( self.text, self.antialias, self.color)

	# todo: font name get/set
	# get/setters for property()ies
	def _get_font_size(self): return self._font_size
	def _set_font_size(self, size):
		if size == self._font_size: return
		self.bDirty=True; self._font_size=size; self._create_font()
	def _get_font_name(self): return self._font_name
	def _set_font_name(self, name): 
		if self._font_name == name: return
		self.bDirty=True; self._font_name=name; self._create_font()
	def _get_font(self): return self._font
	def _set_font(self, font):
		if self._font == font: return
		self.bDirty=True; self._font = font
	def _get_rect(self): return self._rect
	def _set_rect(self, rect): self._rect = rect
	def _get_text(self): return self._text
	def _set_text(self, text):
		if self._text == text: return
		self.bDirty=True; self._text = text
	def _get_aa(self): return self._antialias
	def _set_aa(self, antialias): 
		if self._antialias == antialias: return
		self.bDirty=True; self._antialias = antialias
	def _get_color(self): return self._color
	def _set_color(self,color):
		if self._color == color: return
		self.bDirty=True; self._color = color # self._color = pygame.color.Color(color)			
	def _get_color_bg(self): return self._color_bg
	def _set_color_bg(self,color_bg):
		if self._color_bg == color_bg: return
		self.bDirty=True;
		# self._color_bg = color_bg
		if color_bg != None: self._color_bg = color_bg #pygame.color.Color(color_bg)
		else: self._color_bg = None
	
	font_size = property(_get_font_size, _set_font_size, None, "Change font size")
	# font_name = property(_get_font_name, _set_font_name, None, "Change font name")
	color = property(_get_color, _set_color, None, "Change the color to use")
	color_bg = property(_get_color_bg, _set_color_bg, None, "Change the background color to use. Default=None")
	font = property(_get_font, _set_font, None, "Change the font to use")
	text = property(_get_text, _set_text, None, "Change the text to draw")
	antialias = property(_get_aa, _set_aa, None, "Toggle text Antialias. Default=False")
	rect = property(_get_rect, _set_rect, None, "Change the Rect() for drawing")
		
## todo: add fps average
class FPSText(Text):
	"""A Text() specialized for FPS."""
	def __init__(self, text=None, ttf=None, size=10):
		Text.__init__(self, text, ttf, size)
		self.clock = pygame.time.Clock()
		self.render_last = pygame.time.get_ticks()
		self.render_delay = 1000.
		self.fps_limit = 60.
		self.bLimitFPS = True
		self.text = "fps: %d" % self.fps_limit
		
	def tick(self):
		"""call once each game update()
		
		note: I could maybe move fps.tick() into it's .draw() func ?but, possible
		it could be used in decoupled display and physics rates?
		[and, maybe can use this to get display and physics rates measurement? ]"""
		now = pygame.time.get_ticks()
		if now - self.render_last >= self.render_delay:
			self.render_last = now
			self.text = "fps: %d" % ( self.clock.get_fps() )
		if self.bLimitFPS: self.clock.tick( self.fps_limit )
		else: self.clock.tick()
	
	
class TextMultiLine():
	"""Handles multiple lines of text. You can either pass an array of strings,
	or a single string. If a single string, then \n will seperate lines"""
	def __init__(self):
		self.text_list = []
		## !!NOTE!! use:
			## Font.get_linesize() : int h;
			## Font.get_size(str) : (int w, int h);
		pass
	
	# todo: func that takes string, wordwrap = on
	# todo: func that takes string with newlines, wordwrap toggle.
	# todo: func that takes an array, wordwrap toggle or off
		
		
	def draw(self):
		"""blit text. re-render only if needed."""
		pass

if __name__ == "__main__":
	# print "see: ./test_text.py"
	from test_text import *
	test()