#!/usr/bin/python

import pygame

import worldstuff

import charstuff as CH
import mappy2 as MP
#import sockme as SK

from worldstuff import *

game = Game("The endless night! v2.0")


def initialise():
	pygame.init()
	game.set_player(CH.Person("cha01.bmp",4))
	game.set_map(MP.Map(12,16,"def.bmp", "mapdata"))
	
	game.smap.drawmap()
	

	pygame.display.flip()


def do_scroll(viewx, viewy, direction):

	(viewx, viewy) = game.smap.scrollmap(direction, viewx, viewy, game.mainPC.speed)
	
	"""TBD:
	Try this algorithm
		moved = 0
		If going up or down
			If the player is not at the centery, or the screen cannot scroll, push the 				character
			moved = 1
		If going left or right
			If the player is not at the centerx, or the screen cannot scroll, push the 				character
			moved = 1
		If moved = 0 (still), push the map.
	"""
	(playerx, playery) = game.mainPC.get_pos()
	scroll_speed = game.mainPC.speed/2
	moved = 0 # check to see if we have decided how to move

	if (direction == 'up') or (direction == 'down'):
		if (playery == screeny/2) and game.smap.can_scroll(direction, viewx, viewy, scroll_speed):
			moved = 1 #yes, we have decided to scroll the map
	if (direction == 'left') or (direction == 'right'):
		if playerx == screenx/2 and game.smap.can_scroll(direction, viewx, viewy, scroll_speed):
			moved = 1
#	print moved
	if (moved == 0): #we're gonna push our player around
		game.mainPC.push(direction)
	if (moved == 1): #we're scrolling the map and moving his legs
		(viewx, viewy) = game.smap.scrollmap(direction, viewx, viewy, scroll_speed)
		game.mainPC.walk_in_place(direction)
		
	game.smap.drawmap(viewx, viewy)
	game.mainPC.update()	
#	SK.send_info(channel,game.mainPC.get_pos())
	return (viewx, viewy)

def main():
	direction ='none'
	initialise()
	camerax = 0
	cameray = 0
	while 1:
		pygame.event.pump()
		keyinput = pygame.key.get_pressed()
		if keyinput[pygame.K_ESCAPE] or pygame.event.peek(pygame.QUIT):
#			SK.kill_sock(channel)
			game.over()
			pygame.time.delay(750)
			break
		if keyinput[pygame.K_DOWN]:
				direction = 'down'
		if keyinput[pygame.K_UP]:
				direction = 'up'
		if keyinput[pygame.K_LEFT]:
				direction = 'left'
		if keyinput[pygame.K_RIGHT]:
				direction = 'right'
		if (direction != 'none'):
			(camerax, cameray) = do_scroll(camerax, cameray, direction)
			direction = 'none'
			pygame.display.flip()
	#	do_clock()

if __name__ == '__main__':
	main()
