import pygame
import sys
import worldstuff

from worldstuff import *

tilesize = mapsize
def showtile(tileno, tset, pos, screen):
	x = tileno*tilesize
	y = tileno//tilesize
	srcrect = pygame.Rect(x,y, tilesize, tilesize)
	screen.blit(tset,pos, srcrect)





mapdir = ['down', 'up', 'left', 'right']

class Map:
	
	def __init__(self, wi, hi, tileset, mapfile, vw=screenx/tilesize, vh=screeny/tilesize):
		self.tset = self.loadtiles(tileset)
		self.tiles = self.loadmap(mapfile)
		self.mapw = wi; self.maph = hi
		self.vheight = vh; self.vwidth = vw
	
	def loadtiles(self,pic):
		tileset = pygame.image.load(pic)
		tileset.convert()
		tileset.convert_alpha()
		tileset.set_colorkey(maptrans,pygame.RLEACCEL)
		return tileset

	def loadmap(self,mpfile):
		mtiles = []
	
		try:
			mf = open(mpfile, "r")
			while 1:
				tile = mf.read(2); 
				if not tile: break
				if tile == '\n': break
				mtiles.append(int(tile)); #print mtiles
		#except IOError:
		#	pass
		finally:
			mf.close()
		return mtiles

	def drawmap(self, camerax=0,cameray=0):

		startx = camerax/tilesize;starty = cameray/tilesize #The tile positions you have to be in

		xoff = camerax&(tilesize-1); yoff = cameray&(tilesize-1) #The
		
		screen.fill((0,0,0))
		endy=self.vheight + starty+1; endx = self.vwidth + startx+1

		
		for y in range(starty, endy):
			for x in range(startx, endx):
				tilepos = y*(self.mapw) + x; #The position in our array of tiles
				showx = x - startx; showy = y - starty  #Adjust the position of map by blitting it to the top
				truex = (showx*tilesize-xoff); truey = (showy*tilesize-yoff)
				#print endy
				tilenum = self.tiles[tilepos]
				showtile(tilenum,self.tset, (truex,truey), screen)
		
	def can_scroll(self,direction, camerax, cameray,distance):	
		if direction == 'down':
			if  cameray < (self.maph*tilesize - ((self.vheight)*tilesize+distance)):
				return True
						
		if direction == 'up':
			if cameray > 0:
				return True
				
		if direction == 'left':
			if camerax > 0:	
				return True
				
		if direction == 'right':
			if camerax < (self.mapw*tilesize - ((self.vwidth)*tilesize+distance)):
				return True
		return False

	def scrollmap(self, direction, camerax, cameray, distance):
		#print (self.maph*tilesize - ((self.vheight)*tilesize+distance))
		if direction == 'down':
			if  cameray < (self.maph*tilesize - ((self.vheight)*tilesize+distance)):
				cameray+=distance
			
				
		if direction == 'up':
			if cameray > 0:
				cameray -=distance
				
		if direction == 'left':
			if camerax > 0:	
				camerax -=distance
				
		if direction == 'right':
			if camerax < (self.mapw*tilesize - ((self.vwidth)*tilesize+distance)):
				camerax +=distance
				
		return (camerax, cameray)

