#! /usr/bin/env python

#main.py - main file for pystarfighter
print("init...")


###
###
weaponcooldowntime = 7


 #for easy adjustment

###
###


#lvl
level1 = [ (60, 0), (80, 0), (100,0), (120,0), (140,0), (160,0), (180,0)] #positions of enemies
level2 = [ (60, 0), (80, 0), (100,0), (120,0), (140,0), (160,0), (180,0) ,(60, 20), (80, 20), (100,20), (120,20), (140,20), (160,20), (180,20) ]
level3 = [ (20, 40), (60, 40), (100, 40), (140,40), (180, 40), (220, 40), (60, 0), (80, 0), (100,0), (120,0), (140,0), (160,0), (180,0), (60, 70), (80, 70), (100,70), (120,70), (140,70), (160,70), (180,70) ]
#/lvl
import pygame, spritemodule,random,copy #import modules
from pygame.locals import *        #


screen = pygame.display.set_mode((256,512))
pygame.display.set_caption("Loading")

gameObjects = pygame.sprite.Group() #canisters


clock=pygame.time.Clock()

weaponheat = 0

spaceship = spritemodule.Player("spaceship.png") #create player object
gameObjects.add(spaceship)                       #
  

#colors

blue = 0,0,255
red = 255, 0, 0

green = 0, 255, 0

black = 0,0,0
white = 255,255,255
#/colors

spaceship.rect.left = 0
spaceship.rect.top = 492

#init pygame fonts
pygame.font.init()


pygame.display.set_caption("PyStarFighter II")
print("init complete")
def setenemies(leveltuples, levelspeed): # put enemies on screen.
	global level
	level = levelspeed
	pygame.display.set_caption("Loading Level") #tell player it's loading
	for item in leveltuples: #loop throug coords in lvl1
		gameObjects.add(spritemodule.Enemy(random.choice(("enemyblue.png", "enemycyan.png", "enemygrey.png", "enemyyellow.png")), item, gameObjects))
	pygame.display.set_caption("PyStarFighter II") #tell player it's done

def startup(): #startup for pystarfighter
	startupText = pygame.font.Font(None, 34)
	timeuntilstart = 300 #frames
	while timeuntilstart > 0:
		clock.tick(30)
		timeuntilstart = timeuntilstart - 1
		for event in pygame.event.get(): #cycle events
			if event.type == QUIT or event.type == KEYDOWN and event.key == K_ESCAPE:
				exit()
		screen.fill(black)
		startupRendered = startupText.render(str(int(timeuntilstart/10)), True, (255,255,255)) #reder time left message
		screen.blit(startupRendered, (100,200))
		pygame.display.flip()
def youwin(): #you win message
	print("You Win!")
	messageText = pygame.font.Font(None, 34)
	messageRendered = messageText.render("You Win!", True, (255,255,255))
	while 1:
		screen.blit(messageRendered, (15, 200))
		for event in pygame.event.get(): #cycle events
			if event.type == QUIT or event.type == KEYDOWN and event.key == K_ESCAPE:
				exit()
		pygame.display.flip()
def mainloop(levelArgGivenToMainloop):
	levelstatus = 0 
	direction = -10
	weaponheat = 0
	bouncedir = -1
	while levelstatus == 0: # main game loop
		clock.tick(30)
		weHaveALiveOne = False #assume that no live enemies have been found.
		#if some are found, this variable will be changed before
		#checking to see if levelstatus can become 1 to end the level.
		for item in gameObjects:
			if isinstance(item, spritemodule.Enemy):
				weHaveALiveOne = True
			if isinstance(item, spritemodule.Enemy) and item.rect.top > 512:
				exit() #game over
		if weHaveALiveOne: #probably the most self-explanatory line in the code
			pass #continue on if there are living enemies
		else: #all enemies have been destroyed
			levelstatus = 1 #passed level
		weaponheat = weaponheat - 1
		if weaponheat < 0:
			weaponheat = 0 #ensure the weaponheat doesn't fall below zero
		spaceship.speed = (0,0)
		key = pygame.key.get_pressed() #create a list of keys
		if key[K_RIGHT] and (spaceship.rect.left < 240): 
			spaceship.speed = (6,0)   
		if key[K_LEFT] and spaceship.rect.left > 0: 
			spaceship.speed = (-6,0)
		if key[K_SPACE] and weaponheat == 0: #shoot
			weaponheat = weaponcooldowntime #just incresed the ROF from 30 frames cooldown to 15
			gameObjects.add(spritemodule.Bullet("bullet.png", spaceship.rect.left, spaceship.rect.top))
		#/keys
		spaceship.rect= spaceship.rect.move(spaceship.speed)
		for event in pygame.event.get(): #cycle events
			if event.type == QUIT or event.type == KEYDOWN and event.key == K_ESCAPE:
				exit()
		for item in gameObjects:#
			item.update(levelArgGivenToMainloop, gameObjects)
			if isinstance(item, spritemodule.Enemy):
				if item.rect.left < 0: #over left bound?
					bouncedir = 1
				if item.rect.left > 240: #over right bound?
					bouncedir = -1
				item.rect = item.rect.move(bouncedir, 0)
		screen.fill(black)
		gameObjects.draw(screen)
		pygame.display.flip()

#begin
#startup() #init message

setenemies(level1,1)
mainloop(1)

setenemies(level2,1)
mainloop(1)

setenemies(level3,1)
mainloop(1)
#########################

setenemies(level1,2)
mainloop(2)

setenemies(level2,2)
mainloop(2)

setenemies(level3, 2)
mainloop(2)

############################

setenemies(level1,3)
mainloop(2)

setenemies(level2,3)
mainloop(2)

setenemies(level3,3)
mainloop(2)

#### if you beat all the levels ####
youwin()
