# jake modifications make it use PyGame ( libSDL ) instead of GLUT
	# first convert to Main() class instead of c-like functions
	
#!/usr/bin/python
# Author:
	# based off of the PyOpenGL NeHe demos
		# now its basically just coordinates from his code, rest was re-written
		# to use python OOP better
	# modified to use pygame instead of GLUT by jake bolton [created: 2007/12/15]	
		# also added showing fps()
		# and limiting by fps

# About: draws 3d pyramid and cube
	
__author__ = "author: Jake bolton 2nd mod to use PyGame [ modified from the PyOpenGL nehe demos ]"

# window title filename
WINDOW_TITLE = __file__ + " : " + __author__
# instructions / keys
INSTRUCTIONS = """\n\n== Keys: ==

ESCAPE
	quits
F1
	randomize rotation
F12
	toggles framerate limit
arrow keys
	rotate triangle, quadrilateral\n"""

try:
	from OpenGL.GL import *
	from OpenGL.GLU import *
	import pygame
	from pygame.locals import *
	import sys
	import math
	import random
	
	from fps import FPS
except ImportError, err:
	print "Couldn't load module. %s" % (err)
	sys.exit(2)

class Player():
	"""player input"""
	
	def __init__(self, game):
		# refs
		self.game = game
		self.fps = self.game.fps
		
		# rotation of triangle and quads		
		self.rot_tri = 0.0
		self.rot_quad = 0.0

		self.MAX_SPEED = 180 # math.radians( 90 ) #openGL uses degrees
	
	def handle_event(self, event):
		"""handle copy of list of all events in main loop"""
		pass
	
	def handle_input(self):
		"""handle input not handled in events"""
		keys = pygame.key.get_pressed()
		
		# left
		if keys[K_LEFT]:
			self.rot_tri -= self.MAX_SPEED * self.fps.delta
		# right
		if keys[K_RIGHT]:
			self.rot_tri += self.MAX_SPEED * self.fps.delta
		# up
		if keys[K_UP]:
			self.rot_quad -= self.MAX_SPEED * self.fps.delta
		# down
		if keys[K_DOWN]:
			self.rot_quad += self.MAX_SPEED * self.fps.delta

class Game():
	"""re-write using PyGame"""
	def __init__( self, width=None, height=None ):
		"""init opengl"""
		pygame.init()
		
		self.bDone = False		
		self.fps = FPS()		
		self.player = Player( self )		
		
		if width == None or height == None:
			# get 2nd highest resolution
			l = pygame.display.list_modes()
			width, height = l[1]
			print "You didn't set a resolution, so trying: %dx%d" % (
				width, height )
		
		# init graphics
		self.width, self.height = width, height
		self.screen = pygame.display.set_mode(( self.width, self.height ),
			pygame.DOUBLEBUF | pygame.OPENGL)
		
		pygame.display.set_caption( WINDOW_TITLE )
		
		# init opengl
		glClearColor( 0.0, 0.0, 0.0, 0.0 )
		glClearDepth( 1.0 )
		glDepthFunc( GL_LESS )
		glEnable( GL_DEPTH_TEST )
		glShadeModel( GL_SMOOTH )
		
		# set which matrix stack is target of subsequent matrix operations
		glMatrixMode( GL_PROJECTION )
		glLoadIdentity()
		
		# calc aspect ratio of window
		gluPerspective(45.0, float(width) / float(height), 0.1, 100.0 )
		
		# switch matrix stack target
		glMatrixMode( GL_MODELVIEW )
		
		self.print_status()
		
		print INSTRUCTIONS
		
	def handle_events( self ):
		"""event loop"""
		for event in pygame.event.get():			
			# == copy events to other classes here ==			
			# copy events to player
			self.player.handle_event( event )
						
			if event.type == pygame.QUIT: sys.exit()
			# event: keydown
			elif event.type == KEYDOWN:
				# exit on 'escape'
				if event.key == K_ESCAPE: self.bDone = True
				# F1: randomize rotation
				elif event.key == K_F1:
					self.player.rot_tri = random.randint( -360, 360 )
					self.player.rot_quad = random.randint( -360, 360 )
				# F2: reset rotation
				elif event.key == K_F2:
					self.player.rot_tri = 0
					self.player.rot_quad = 0
				
				# F12: toggle limit framerate
				elif event.key == K_F12:
					self.fps.bLimitFPS = not self.fps.bLimitFPS
					print "limitFPS = %s [ max=%d ]" % ( self.fps.bLimitFPS, self.fps.max_fps )
		
	def draw( self ):
		"""draw"""
		# clear screen and depth
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )
		
		# move left 1.5 units, and into screen 6.0 units
		glLoadIdentity()				
		glTranslatef( -1.5, 0.0, -6.0 )
		
		# ==== draw pyramid ====
			# rotated on the Y axis
		
		glRotatef( self.player.rot_tri, 1.0, 1.0, 0.0)

		glBegin(GL_TRIANGLES)

		# triangle: front face
			# coords: top, left, right
			# colors: red, green, blue			
		# top
		glColor3f(1.0,0.0,0.0)			
		glVertex3f( 0.0, 1.0, 0.0)
		# left
		glColor3f(0.0,1.0,0.0)
		glVertex3f(-1.0,-1.0, 1.0)
		# right
		glColor3f(0.0,0.0,1.0)
		glVertex3f( 1.0,-1.0, 1.0)

		# triangle: right face
			# coords: top, left, right
			# colors: red, blue, green
		# top
		glColor3f(1.0,0.0,0.0)
		glVertex3f( 0.0, 1.0, 0.0)
		# left
		glColor3f(0.0,0.0,1.0)
		glVertex3f( 1.0,-1.0, 1.0)
		# right
		glColor3f(0.0,1.0,0.0)
		glVertex3f( 1.0,-1.0, -1.0)

		# triangle: back face
			# coords: top, left, right
			# colors: red, green, blue
		# top
		glColor3f(1.0,0.0,0.0)
		glVertex3f( 0.0, 1.0, 0.0)
		# left
		glColor3f(0.0,1.0,0.0)
		glVertex3f( 1.0,-1.0, -1.0)
		# right
		glColor3f(0.0,0.0,1.0)
		glVertex3f(-1.0,-1.0, -1.0)

		# triangle: left face
			# coords: top, left, right
			# colors: red, blue, green
		# top
		glColor3f(1.0,0.0,0.0)
		glVertex3f( 0.0, 1.0, 0.0)
		# left
		glColor3f(0.0,0.0,1.0)
		glVertex3f(-1.0,-1.0,-1.0)
		# right
		glColor3f(0.0,1.0,0.0)
		glVertex3f(-1.0,-1.0, 1.0)
		
		glEnd()	

		# reset, move, to draw the cube		
		glLoadIdentity();
		glTranslatef( 1.5, 0.0, -7.0)
		glRotatef( self.player.rot_quad, 1.0, 1.0, 1.0)
				
		# ==== draw cube ====
			# rotated on X, Y and Z axis
		glBegin(GL_QUADS)

		# cube: top face
			# coords: top right, top left, bottom left, bottom right
			# colors: green		
		glColor3f(0.0,1.0,0.0)
		# top right
		glVertex3f( 1.0, 1.0,-1.0)
		# top left
		glVertex3f(-1.0, 1.0,-1.0)
		# bottom left
		glVertex3f(-1.0, 1.0, 1.0)
		# bottom right
		glVertex3f( 1.0, 1.0, 1.0)
		
		# cube: top face
			# coords: top right, top left, bottom left, bottom right
			# color: orange
		glColor3f(1.0,0.5,0.0)
		glVertex3f( 1.0,-1.0, 1.0)
		glVertex3f(-1.0,-1.0, 1.0)
		glVertex3f(-1.0,-1.0,-1.0)
		glVertex3f( 1.0,-1.0,-1.0)

		# cube: top face
			# coords: top right, top left, bottom left, bottom right
			# colors: red
		glColor3f(1.0,0.0,0.0)
		glVertex3f( 1.0, 1.0, 1.0)
		glVertex3f(-1.0, 1.0, 1.0)
		glVertex3f(-1.0,-1.0, 1.0)
		glVertex3f( 1.0,-1.0, 1.0)

		# cube: top face
			# coords: top right, top left, bottom left, bottom right
			# colors: yellow
		glColor3f(1.0,1.0,0.0)
		glVertex3f( 1.0,-1.0,-1.0)
		glVertex3f(-1.0,-1.0,-1.0)
		glVertex3f(-1.0, 1.0,-1.0)
		glVertex3f( 1.0, 1.0,-1.0)

		# cube: top face
			# coords: top right, top left, bottom left, bottom right
			# colors: blue
		glColor3f(0.0,0.0,1.0)
		glVertex3f(-1.0, 1.0, 1.0)
		glVertex3f(-1.0, 1.0,-1.0)
		glVertex3f(-1.0,-1.0,-1.0)
		glVertex3f(-1.0,-1.0, 1.0)

		# cube: top face
			# coords: top right, top left, bottom left, bottom right
			# colors: purple
		glColor3f(1.0,0.0,1.0)
		glVertex3f( 1.0, 1.0,-1.0)
		glVertex3f( 1.0, 1.0, 1.0)
		glVertex3f( 1.0,-1.0, 1.0)
		glVertex3f( 1.0,-1.0,-1.0)
		glEnd()

		pygame.display.flip()

	def update( self ):
		"""update"""
		self.player.handle_input()
		self.fps.tick()
	
	def loop( self ):
		"""main loop"""
		while not self.bDone:
			self.update()
			self.handle_events()
			self.draw()
			
	def print_status( self ):
		"""print status"""
		print "\n== members: ==\n"
		print "limitFPS = %s [ max=%d ]" % ( self.fps.bLimitFPS, self.fps.max_fps )
		
		print "\n== pygame.display.Info() ==\n"
		print pygame.display.Info()
		print "\n== misc info ==\n"
		print "driver: ", pygame.display.get_driver()
		print "\n== OpenGL flags: ==\n"
		self.print_gl_flags()
		
	def print_gl_flags( self ):
		"""print the opengl flags status"""			
		d = { GL_ALPHA_SIZE:'GL_ALPHA_SIZE', GL_DEPTH_SIZE:'GL_DEPTH_SIZE',
			GL_STENCIL_SIZE:'GL_STENCIL_SIZE', GL_ACCUM_RED_SIZE:'GL_ACCUM_RED_SIZE',
			GL_ACCUM_GREEN_SIZE:'GL_ACCUM_GREEN_SIZE', GL_ACCUM_BLUE_SIZE:'GL_ACCUM_BLUE_SIZE',
			GL_ACCUM_ALPHA_SIZE:'GL_ACCUM_ALPHA_SIZE', GL_MULTISAMPLEBUFFERS:'GL_MULTISAMPLEBUFFERS',
			GL_MULTISAMPLESAMPLES:'GL_MULTISAMPLESAMPLES', GL_STEREO:'GL_STEREO'
		}

		# semi-'nice' output of flags
		for flag, name in d.iteritems():
			attr = pygame.display.gl_get_attribute( flag )
			print "\tflag: %s \t= %s" % ( name, attr )
	
# old: but on-resize event code
def ResizeGLScene( width, height ):
	"""old code. could be called on pygame resize window I guess but skipped for now.
	
	this is called when window is re-sized"""
	# prevent divide by zero
	if height == 0: height = 1
	
	glViewport( 0, 0, width, height )
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()
	gluPerspective( 45.0, float(width) / float(height), 0.1, 100.0)
	glMatrixMode(GL_MODELVIEW)

# == entry point ==
if __name__ == "__main__":
	print "press ESC to quit."
	g = Game(640, 480)
	g.loop()
	
	print "\nDone!\n"