# jake modifications make it use PyGame ( libSDL ) instead of GLUT
	# first convert to Main() class instead of c-like functions
	
#!/usr/bin/python
# Author:
	# based off of the c Nehe demos
		# i'm converting it to python
	# modified to use pygame instead of GLUT by jake bolton [created: 2007/12/15]	
		# also added showing fps()
		# and limiting by fps

# About: blending
	# converted his code to use pygame image loading calls ( vs his external lib )
	
BLEND_INFO = """Transparency is best implemented using blend function (GL_SRC_ALPHA,
	GL_ONE_MINUS_SRC_ALPHA) with primitives sorted from farthest to nearest. Note that this
	transparency calculation does not require the presence of alpha bitplanes in the frame buffer.



	Blend function (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA) is also useful for
	rendering antialiased points and lines in arbitrary order.



	Polygon antialiasing is optimized using blend function (GL_SRC_ALPHA_SATURATE,
	GL_ONE) with polygons sorted from nearest to farthest. (See the glEnable, glDisable reference page and the
	GL_POLYGON_SMOOTH argument for information on polygon antialiasing.) Destination alpha bitplanes,
	which must be present for this blend function to operate correctly, store the accumulated coverage."""
	
__author__ = "author: Jake bolton 2nd mod to use PyGame [ modified from the PyOpenGL nehe demos ]"

# window title filename
WINDOW_TITLE = __file__ + " : " + __author__
# instructions / keys
INSTRUCTIONS = """\n\n== about ==
	blending example.

== Keys: ==

	== misc ==
		
		ESCAPE
			quits	
		F12
			toggles framerate limit

	== lighting ==
		
		F
			cycle different texture filters
		F1
			Lighting on ( show shading )
		F2
			Lighting off ( no shading, all bright )			
		B
			toggle blending ( transparency )

	== movement ==

		WASD, QE
			rotate cube on 3 axis
		Arrow keys
			move world

\n"""

try:
	from OpenGL.GL import *
	from OpenGL.GLU import *
	import pygame
	from pygame.locals import *
	import os, sys
	import math
	import random
	
	from fps import FPS
except ImportError, err:
	print "Couldn't load module. %s" % (err)
	sys.exit(2)

class Player():
	"""player input"""
	
	def __init__(self, game):
		# refs
		self.game = game
		self.fps = self.game.fps
		
		# rotation of triangle and quads		
		self.rot_x = 40.0 # 0.0
		self.rot_y = 40.0 # 0.0
		self.rot_z = 0.0
		
		self.loc_z = -6.0

		self.MAX_SPEED = 180 # math.radians( 90 ) #openGL uses degrees
		self.ZOOM_SPEED = 10
	
	def handle_event(self, event):
		"""handle copy of list of all events in main loop"""
		pass

	def handle_input(self):
		"""handle input not handled in events"""
		keys = pygame.key.get_pressed()
				
		# left
		if keys[K_a]:
			self.rot_y -= self.MAX_SPEED * self.fps.delta
		# right
		if keys[K_d]:
			self.rot_y += self.MAX_SPEED * self.fps.delta
		# up
		if keys[K_w]:
			self.rot_x -= self.MAX_SPEED * self.fps.delta
		# down
		if keys[K_s]:
			self.rot_x += self.MAX_SPEED * self.fps.delta			
		# e
		if keys[K_e]:
			self.rot_z += self.MAX_SPEED * self.fps.delta			
		# q
		if keys[K_q]:
			self.rot_z -= self.MAX_SPEED * self.fps.delta
			
		# up: zoom in
		if keys[K_UP]:
			self.loc_z += self.ZOOM_SPEED * self.fps.delta			
		# down: zoom out
		if keys[K_DOWN]:
			self.loc_z -= self.ZOOM_SPEED * self.fps.delta
			

class Game():
	"""re-write using PyGame"""
	def __init__( self, width=None, height=None ):
		"""init opengl"""
		pygame.init()
		
		self.bDone = False		
		self.fps = FPS()		
		self.player = Player( self )		
		
		self.bCubeNormals = True # toggle using normals or not
		self.bShowBlend = True # toggle blending
		
		# light:
			# ambient
			# diffuse		
		self.bShowLight = True
		self.light_ambient = (0.2, 0.2, 0.2, 1.0 )
		self.light_diffuse = (0.8, 0.8, 0.8 ) # self.light_diffuse = (0.8, 0.8, 0.8, 1.0 ) # todo: last arg is 0 or 1?
		self.light_position = ( -2, 0, 3, 1 )
		
		# self.id_list = # set in .init_OpenGL()
		self.id_cur = 3 # current image/texture ID		
		
		if width == None or height == None:
			# get 2nd highest resolution
			l = pygame.display.list_modes()
			width, height = l[1]
			print "You didn't set a resolution, so trying: %dx%d" % (
				width, height )
		
		# init graphics
		self.width, self.height = width, height
		self.screen = pygame.display.set_mode(( self.width, self.height ),
			pygame.DOUBLEBUF | pygame.OPENGL)
		
		pygame.display.set_caption( WINDOW_TITLE )
		
		# init opengl
		self.init_OpenGL()
		
		# debug:
		if False: self.print_status()		
		
		print INSTRUCTIONS
		
	def init_OpenGL( self ):
		"""OpenGL specific init"""
		glClearColor( 0.0, 0.0, 0.0, 0.0 )
		glClearDepth( 1.0 )
		glDepthFunc( GL_LESS )
		glEnable( GL_DEPTH_TEST )
		glShadeModel( GL_SMOOTH )
		
		# textures
			# todo: find why does the tut load textures, then after that,
			# enables GL_TEXTURE_2D ( instead of enabling first? is he wrong? )
				# **should** the load function be doing that?
				# **is** it assuming i'm going to do it here?
		self.id_list = self.load_textures()
		glEnable( GL_TEXTURE_2D )
				
		# set which matrix stack is target of subsequent matrix operations
		glMatrixMode( GL_PROJECTION )
		glLoadIdentity()
		
		# calc aspect ratio of window
		gluPerspective(45.0, float(self.width) / float(self.height), 0.1, 100.0 )
		
		# switch matrix stack target
		glMatrixMode( GL_MODELVIEW )
		
		# set up lights
		glLightfv( GL_LIGHT1, GL_AMBIENT, self.light_ambient )
		glLightfv( GL_LIGHT1, GL_DIFFUSE, self.light_diffuse )
		glLightfv( GL_LIGHT1, GL_POSITION, self.light_position )
		glEnable( GL_LIGHT1 )
		
		glEnable( GL_LIGHTING )
		# for this demo, blending, effect is more obvious with lights off
		self.toggle_light( False )
		
		# some other modes: but they don't look right with current geometry
		BLENDSTYLES = [
			(),
			(GL_SRC_ALPHA, GL_ONE), # what the demo uses originally
			(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA), # this is what should be used with sorted triangles
			(GL_SRC_ALPHA, GL_DST_ALPHA), # just for kicks...
		]
		# glBlendFunc( * BLENDSTYLES[ 2 ] )
		
		# setup blending				
		glBlendFunc( GL_SRC_ALPHA, GL_ONE )		
		glColor4f( 1.0, 1.0, 1.0, 0.5 ) # full brightness, 50% opacity
		self.toggle_blend( True )			
		
	def toggle_blend( self, bOn = None ):
		"""defaults to toggle blending, but optionally can force a mode"""
		if bOn == None:
			bOn = not self.bShowBlend
		self.bShowBlend = bOn
		# self.bShowBlend = not self.bShowBlend
		
		# when blending, disable depth test
		if self.bShowBlend:
			glEnable( GL_BLEND )
			glDisable( GL_DEPTH_TEST )
		else:
			glDisable( GL_BLEND )
			glEnable( GL_DEPTH_TEST )
	
	
	def toggle_light( self, bOn = None ):
		"""defaults to toggle lighting, but optionally can force a mode"""
		if bOn == None:
			bOn = not self.bShowLight
		self.bShowLight = bOn
		
		# lights on
		if self.bShowLight:
			glEnable( GL_LIGHTING )
			glEnable( GL_LIGHT1 )
			glDisable( GL_LIGHT0 ) # not sure why I toggle light0 as well as mine
		# lights off
		else: 
			glDisable( GL_LIGHTING )
			glDisable( GL_LIGHT1 )
			glDisable( GL_LIGHT0 )
			
		print "lighting =", self.bShowLight
	
	def load_textures( self ):
		"""load GL_TEXTURE_2D textures
		
		see also:
			self.load_texture( image )
			self.load_texture_images( image )"""
		image = 'glass.bmp'
		
		# == old, single texture ==
			# load as an OpenGL texture
			# texture, width, height = self.load_texture( image )		
			# self.texture = texture
		
		# == new, texture ID list ==
		id_list = self.load_texture_images( image )
		return id_list

	def load_texture( self, image ):
		"""load a texture : used to load a single texture
		
		returns: texture, width, height
		where:
			texture = glGenTextures(1)
			
		re-write these two as one load function like:
			id_list.append( self.load_texture( image, "nearest" ))
			id_list.append( self.load_texture( image, "linear" ))
			id_list.append( self.load_texture( image, "mipmap" ))
		and if no 'mode' argument, default to nearest or linear or whatever I choose default"""
			
		filepath = os.path.join('data', 'Data07', image )
		
		# load as pygame surface
		try:
			textureSurface = pygame.image.load( filepath )
		except pygame.error, message:
			print 'Cannot load image:', filepath
			print "\terror: ", pygame.get_error()
			raise SystemExit, message
			
		# not exactly sure? converting pixel format to opengl format order?
		textureData = pygame.image.tostring( textureSurface, "RGBA", True )
		
		width = textureSurface.get_width()
		height = textureSurface.get_height()
		
		texture = glGenTextures(1)
		glBindTexture( GL_TEXTURE_2D, texture )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR )
		# target, level, internal_format, w, h, border, format, type, pixels
		glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA,
			GL_UNSIGNED_BYTE, textureData )

		return texture, width, height
		
	def load_texture_images( self, image ):
		"""loads single image as 3 filter types
		
		returns ID's of the 3 created textures, of the same image with different
		filter types
		
		todo: combine with .load_texture( ..., mode ) to make one load function
		so this one would do something like:
			id_list.append( self.load_texture( image, "nearest" ))
			id_list.append( self.load_texture( image, "linear" ))
			id_list.append( self.load_texture( image, "mipmap" ))
		"""
		
		id_list = []
		
		filepath = os.path.join('data', 'Data08', image )
		
		# load as pygame surface
		try:
			textureSurface = pygame.image.load( filepath )
		except pygame.error, message:
			print 'Cannot load image:', filepath
			print "\terror: ", pygame.get_error()
			raise SystemExit, message
			
		# not exactly sure? converting pixel format to opengl format order?
		textureData = pygame.image.tostring( textureSurface, "RGBA", True )		
		width = textureSurface.get_width()
		height = textureSurface.get_height()
		
		# [1] nearest-filtered texture
		id_cur = glGenTextures(1)
		id_list.append( id_cur )
		
		glBindTexture( GL_TEXTURE_2D, id_cur )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST )
		glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA,
			GL_UNSIGNED_BYTE, textureData )
		
		# [2] linear-filtered texture
		id_cur = glGenTextures(1)
		id_list.append( id_cur )
		
		glBindTexture( GL_TEXTURE_2D, id_cur )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR )
		glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA,
			GL_UNSIGNED_BYTE, textureData )
		
		# [3] linear + mip-mapping texture		
		id_cur = glGenTextures(1)
		id_list.append( id_cur )
		
		glBindTexture( GL_TEXTURE_2D, id_cur )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR )
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST )
		glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA,
			GL_UNSIGNED_BYTE, textureData )
			
		print "building mipmaps: starting:"
		gluBuild2DMipmaps( GL_TEXTURE_2D, GL_RGBA, width, height, GL_RGBA,
			GL_UNSIGNED_BYTE, textureData )
		print "building mipmaps: complete!"
		
		return id_list
	
	def handle_events( self ):
		"""event loop"""
		for event in pygame.event.get():			
			# == copy events to other classes here ==			
			# copy events to player
			self.player.handle_event( event )
						
			if event.type == pygame.QUIT: sys.exit()
			# event: keydown
			elif event.type == KEYDOWN:
				
				# exit on 'escape'
				if event.key == K_ESCAPE: self.bDone = True
					
				# F1 : lights on
				if event.key == K_F1:
					self.toggle_light( True )
					
					# old:
					# glEnable( GL_LIGHTING )
					# glEnable( GL_LIGHT1 )
					# glDisable( GL_LIGHT0 ) #todo: disable here? is that correct?
				# F2 : lights off
				elif event.key == K_F2:
					self.toggle_light( False )
					
					# old:
					# glDisable( GL_LIGHTING )
					# glDisable( GL_LIGHT1 )
					# glDisable( GL_LIGHT0 )
					
				# F : cycle filter mode
				elif event.key == K_f:
					# inc id, keep <= total filters
					self.id_cur += 1
					if self.id_cur > len( self.id_list ):
						self.id_cur = 1											
					print "filter set to:", self.id_cur							
					
				# B : blending toggle
				elif event.key == K_b:
					self.toggle_blend()					
					print "draw with blending =", self.bShowBlend					
					
				# elif event.key == K_d:
					# print "loc:\n\t%s\n\t%s\n\t%s" % ( self.player.rot_x, self.player.rot_y, self.player.rot_z, )
				
				# F12: toggle limit framerate				
				elif event.key == K_F12:
					self.fps.bLimitFPS = not self.fps.bLimitFPS
					print "limitFPS = %s [ max=%d ]" % ( self.fps.bLimitFPS, self.fps.max_fps )
		
	def draw( self ):
		"""draw"""
		# clear screen and depth
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )		
		
		# move left 1.5 units, and into screen 6.0 units
		glLoadIdentity()				
		# glTranslatef( 0, 0.0, -6.0 )				
		glTranslatef( 0.0, 0.0, self.player.loc_z )
		
		# rotate cube on X, Y, and Z axis ( using unique degrees )
		glRotatef( self.player.rot_x, 1.0,0.0,0.0)
		glRotatef( self.player.rot_y, 0.0,1.0,0.0)
		glRotatef( self.player.rot_z, 0.0,0.0,1.0)
		
		# toggle drawing with or without normals
		if self.bCubeNormals:
			self.draw_cube()
		else:
			self.draw_cube_old()

		pygame.display.flip()
		
	def draw_cube( self ):
		"""like .draw_cube() but adds normals"""
		# ==== draw cube ====
			# rotated on X, Y and Z axis
			# with normals
		glBindTexture( GL_TEXTURE_2D, self.id_cur )
		
		glBegin(GL_QUADS);
		glNormal3f( 0.0, 0.0, 1.0)
		glTexCoord2f(0.0, 0.0); glVertex3f(-1.0, -1.0,  1.0);
		glTexCoord2f(1.0, 0.0); glVertex3f( 1.0, -1.0,  1.0);
		glTexCoord2f(1.0, 1.0); glVertex3f( 1.0,  1.0,  1.0);
		glTexCoord2f(0.0, 1.0); glVertex3f(-1.0,  1.0,  1.0);

		glNormal3f( 0.0, 0.0,-1.0);
		glTexCoord2f(1.0, 0.0); glVertex3f(-1.0, -1.0, -1.0);
		glTexCoord2f(1.0, 1.0); glVertex3f(-1.0,  1.0, -1.0);
		glTexCoord2f(0.0, 1.0); glVertex3f( 1.0,  1.0, -1.0);
		glTexCoord2f(0.0, 0.0); glVertex3f( 1.0, -1.0, -1.0);

		glNormal3f( 0.0, 1.0, 0.0)
		glTexCoord2f(0.0, 1.0); glVertex3f(-1.0,  1.0, -1.0);
		glTexCoord2f(0.0, 0.0); glVertex3f(-1.0,  1.0,  1.0);
		glTexCoord2f(1.0, 0.0); glVertex3f( 1.0,  1.0,  1.0);
		glTexCoord2f(1.0, 1.0); glVertex3f( 1.0,  1.0, -1.0);

		glNormal3f( 0.0,-1.0, 0.0)
		glTexCoord2f(1.0, 1.0); glVertex3f(-1.0, -1.0, -1.0);
		glTexCoord2f(0.0, 1.0); glVertex3f( 1.0, -1.0, -1.0);
		glTexCoord2f(0.0, 0.0); glVertex3f( 1.0, -1.0,  1.0);
		glTexCoord2f(1.0, 0.0); glVertex3f(-1.0, -1.0,  1.0);

		glNormal3f( 1.0, 0.0, 0.0)
		glTexCoord2f(1.0, 0.0); glVertex3f( 1.0, -1.0, -1.0);
		glTexCoord2f(1.0, 1.0); glVertex3f( 1.0,  1.0, -1.0);
		glTexCoord2f(0.0, 1.0); glVertex3f( 1.0,  1.0,  1.0);
		glTexCoord2f(0.0, 0.0); glVertex3f( 1.0, -1.0,  1.0);

		glNormal3f(-1.0, 0.0, 0.0)
		glTexCoord2f(0.0, 0.0); glVertex3f(-1.0, -1.0, -1.0);
		glTexCoord2f(1.0, 0.0); glVertex3f(-1.0, -1.0,  1.0);
		glTexCoord2f(1.0, 1.0); glVertex3f(-1.0,  1.0,  1.0);
		glTexCoord2f(0.0, 1.0); glVertex3f(-1.0,  1.0, -1.0);
		glEnd()
	
	def update( self ):
		"""update"""
		self.player.handle_input()
		self.fps.tick()
	
	def loop( self ):
		"""main loop"""
		while not self.bDone:
			self.update()
			self.handle_events()
			self.draw()
			
	def print_status( self ):
		"""print status"""
		print "\n== members: ==\n"
		print "limitFPS = %s [ max=%d ]" % ( self.fps.bLimitFPS, self.fps.max_fps )
		
		print "\n== pygame.display.Info() ==\n"
		print pygame.display.Info()
		print "\n== misc info ==\n"
		print "driver: ", pygame.display.get_driver()
		print "\n== OpenGL flags: ==\n"
		self.print_gl_flags()
		
	def print_gl_flags( self ):
		"""print the opengl flags status"""			
		d = { GL_ALPHA_SIZE:'GL_ALPHA_SIZE', GL_DEPTH_SIZE:'GL_DEPTH_SIZE',
			GL_STENCIL_SIZE:'GL_STENCIL_SIZE', GL_ACCUM_RED_SIZE:'GL_ACCUM_RED_SIZE',
			GL_ACCUM_GREEN_SIZE:'GL_ACCUM_GREEN_SIZE', GL_ACCUM_BLUE_SIZE:'GL_ACCUM_BLUE_SIZE',
			GL_ACCUM_ALPHA_SIZE:'GL_ACCUM_ALPHA_SIZE', GL_MULTISAMPLEBUFFERS:'GL_MULTISAMPLEBUFFERS',
			GL_MULTISAMPLESAMPLES:'GL_MULTISAMPLESAMPLES', GL_STEREO:'GL_STEREO'
		}

		# semi-'nice' output of flags
		for flag, name in d.iteritems():
			attr = pygame.display.gl_get_attribute( flag )
			print "\tflag: %s \t= %s" % ( name, attr )
	
# old: but on-resize event code
# def ResizeGLScene( width, height ):
	# """old code. could be called on pygame resize window I guess but skipped for now.
	
	# this is called when window is re-sized"""
	# prevent divide by zero
	# if height == 0: height = 1
	
	# glViewport( 0, 0, width, height )
	# glMatrixMode(GL_PROJECTION)
	# glLoadIdentity()
	# gluPerspective( 45.0, float(width) / float(height), 0.1, 100.0)
	# glMatrixMode(GL_MODELVIEW)

# == entry point ==
if __name__ == "__main__":
	print "press ESC to quit."
	g = Game(640, 480)
	g.loop()	
	
	print "\nDone!\n"