#!/usr/bin/python
#!/usr/bin/env python
# Author: jake bolton [created: 2007/06/15]
# About: FPS utility class : stripped of functions

# == NOTE !! ==
	# modified from ZombieHunt
		# so get the version from there.

import pygame
from pygame.locals import *

class FPS:
	"""FPS utility, track and render fps text
	
	methods:
		render() = draw FPS to screen
		tick() = call pygame.Clock.tick()
	members:
		bLimitFPS = set max FPS
		max_fps = max fps to use if bLimitFPS
		clock = pygame.time.Clock()
		font = pygame.font.Font()
		screen = screen surface
		render_time = time to wait before re-rendering text
		render_last = time text was last rendered
		
	"""
	
	# def __init__(self, console, bLimitFPS=True):
	def __init__(self, bLimitFPS=True ):
		"""initialize FPS()"""
		# self.game = game
		
		self.bLimitFPS = bLimitFPS
		self.clock = pygame.time.Clock()
		self.max_fps = 60
		
		# time related to re-draws
		self.render_time = 1000	# ms to wait before next render
		self.render_last = pygame.time.get_ticks() # ticks of last render
		
		# FPS() calc's delta ( AKA: fps_elapsed )
		self.ticks_cur = pygame.time.get_ticks()
		self.ticks_last = pygame.time.get_ticks()
		
		# alias for shorter code / clarity
		# self.console = self.game.console
		# self.console.set("fps", "fps: %s" % self.clock.get_fps(), "white")

	def tick(self):
		"""call each game-loop, does .clock.tick() or .clock.tick(max_fps)
		
		based on bLimitFPS. Returns same value as Clock.tick().
		
		Also updates fps string that console blits."""
		
		# calculate delta
		self.ticks_cur = pygame.time.get_ticks()		
		self.delta = ( self.ticks_cur - self.ticks_last ) / 1000.0
		self.ticks_last = self.ticks_cur
		
		# update new value, but don't make it redraw every frame
		now = pygame.time.get_ticks()
		if now - self.render_last > self.render_time:
			self.render_last = now
			print "fps: %d" % self.clock.get_fps()
			# self.console.set("fps", "fps: %d" % self.clock.get_fps(), "white" )

		if self.bLimitFPS: 
			return self.clock.tick( self.max_fps )
		else:
			return self.clock.tick()
			