
import os
import pygame

pygame.init()

surface = pygame.display.set_mode((800, 400))#, pygame.SRCALPHA)

source = pygame.image.load(os.path.join('sprites.png')).convert()

bird = pygame.sprite.DirtySprite()
bird.image = source
bird.image.set_colorkey((255, 0, 255))
bird.source_rect = pygame.Rect(0, 148, 35, 24)
bird.rect = pygame.Rect(100, 100, 35, 24)

get_ready = pygame.sprite.DirtySprite()
get_ready.image = source
get_ready.image.set_colorkey((255, 0, 255))
get_ready.source_rect = pygame.Rect(0, 322, 184, 50)
get_ready.rect = pygame.Rect(70, 100, 184, 50)

background = pygame.Surface((800, 400))
background.fill((0, 0, 0))

layer = pygame.sprite.LayeredDirty()
layer.clear(surface, background)
layer.add(get_ready)
layer.add(bird)

clock = pygame.time.Clock()

running = True

# Main game loop
while running:

	# Manages events
	events = pygame.event.get()
	for event in events:
		if event.type == pygame.QUIT:
			running = False

	bird.rect = bird.rect.move(2, 0)
	bird.dirty = 1
	#get_ready.dirty = 1

	pygame.display.update(layer.draw(surface))

	# Waits, 10 frames per second
	clock.tick(10)

pygame.quit()