import os, sys
from iniparse import INIConfig
import pygame
from pygame.locals import *

data_py = os.path.abspath(os.path.dirname(__file__))
data_dir = os.path.normpath(os.path.join(data_py, '..', 'data'))

def load_graphic(name):
	def loadimage(filename, mode='rb'):
		return pygame.image.load(os.path.join(data_dir, 'graphics', filename))
	try:
		image = loadimage(name)
	except pygame.error, message:
		print 'Cannot load image:', name
		raise SystemExit, message
	image = image.convert_alpha()
	return image, image.get_rect()

class load_sprite:
	def __init__(self, filename):
		self.sheet = pygame.image.load(os.path.join('data', 'graphics', filename))
	def image(self, rect, colorkey = None):
		rect = Rect(rect)
		image = pygame.Surface(rect.size).convert()
		image.blit(self.sheet, (0, 0), rect)
		if colorkey is not None:
			if colorkey is -1:
				colorkey = image.get_at((0, 0))
			image.set_colorkey(colorkey, RLEACCEL)
		return image
	def images(self, rects, colorkey = None):
		imgs = []
		for rect in rects:
			imgs.append(self.image(rect, colorkey))
		return imgs

def load_font(name, size):
	font_file = os.path.join(data_dir, 'fonts', name + '.ttf')
	font = pygame.font.Font(font_file, size)
	return font

def load_level(map, mode='rb'):
	return open(os.path.join(data_dir, 'maps', 'map' + str(map) + '.map'), mode)

def load_mapcfg(map, mode='rb'):
	return INIConfig(open(os.path.join(data_dir, 'maps', 'map' + str(map) + '.cfg'), mode))

def load_sfx(name):
	class DummySound(object):
		def play(self): pass
	try:
		return pygame.mixer.Sound(os.path.join(data_dir, 'audio', name + '.ogg'))
	except pygame.error:
		return DummySound()

def load_music(name):
	class DummySound(object):
		def play(self): pass
	try:
		return pygame.mixer.music.load(os.path.join(data_dir, 'audio', name + '.ogg'))
	except pygame.error:
		return DummySound()

def loop_music():
# This is to bypass a bug in the looping of OGG Vorbis files causing them to sound very degraded.
# TODO: Check if this bug still exists in recent SDL/Pygame versions.
	if not pygame.mixer.music.get_busy():
		pygame.mixer.music.play()
